/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.settings.composites;

import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.katalon.plugin.smart_xpath.settings.composites.ExcludeKeywordsEditingSupport;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.execution.setting.MobileSettingStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class SelfHealingMobileExcludedKeywordsComposite
extends Composite {
    private TableViewer tableViewer;
    private List<String> excludeKeywords = Collections.emptyList();
    private int TITLE_COMPOSITE_HEIGHT_HINT = 20;

    public SelfHealingMobileExcludedKeywordsComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent(parent);
    }

    public void createContent(Composite parent) {
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 128, true, false));
        Composite titleComposite = new Composite(parent, 0);
        GridData titleData = new GridData(4, 128, true, false);
        titleData.heightHint = this.TITLE_COMPOSITE_HEIGHT_HINT;
        titleComposite.setLayoutData((Object)titleData);
        GridLayout titleCompositeLayout = new GridLayout(2, false);
        titleCompositeLayout.marginHeight = 0;
        titleCompositeLayout.marginWidth = 0;
        titleComposite.setLayout((Layout)titleCompositeLayout);
        Label titleLabel = new Label(titleComposite, 0);
        titleLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        titleLabel.setText(SmartXPathMessageConstants.LBL_EXCLUDE_OBJECTS_USED_WITH_MOBILE_KEYWORDS);
        Composite excludedKeywordComposite = new Composite(parent, 0);
        excludedKeywordComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout excludedKeywordCompositeLayout = new GridLayout(1, true);
        excludedKeywordCompositeLayout.marginLeft = 1;
        excludedKeywordCompositeLayout.marginRight = 1;
        excludedKeywordCompositeLayout.marginHeight = 0;
        excludedKeywordComposite.setLayout((Layout)excludedKeywordCompositeLayout);
        Group excludedKeywordsGroup = new Group(excludedKeywordComposite, 0);
        excludedKeywordsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout excludedKeywordsGroupLayout = new GridLayout(1, true);
        excludedKeywordsGroup.setLayout((Layout)excludedKeywordsGroupLayout);
        Composite compositeToolbar = new Composite((Composite)excludedKeywordsGroup, 0);
        compositeToolbar.setLayout((Layout)new FillLayout(256));
        compositeToolbar.setLayoutData((Object)new GridData(4, 128, true, false));
        ToolBar toolBar = new ToolBar(compositeToolbar, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        ToolItem tltmAddVariable = new ToolItem(toolBar, 0);
        tltmAddVariable.setText("Add");
        tltmAddVariable.setImage(ImageManager.getImage((String)"add_16.png"));
        Menu addMenu = new Menu((Control)tltmAddVariable.getParent().getShell());
        tltmAddVariable.setData((Object)addMenu);
        tltmAddVariable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int newDefaultKeywordIndex = 0;
                List<KeywordMethod> mobileKeywords = SelfHealingMobileExcludedKeywordsComposite.this.getMobileBuiltinKeywords();
                KeywordMethod newDefaultKeyword = mobileKeywords.get(newDefaultKeywordIndex);
                int i = 0;
                while (i < SelfHealingMobileExcludedKeywordsComposite.this.excludeKeywords.size()) {
                    if (newDefaultKeyword.getName().equals(SelfHealingMobileExcludedKeywordsComposite.this.excludeKeywords.get(i))) {
                        newDefaultKeyword = mobileKeywords.get(++newDefaultKeywordIndex);
                        i = -1;
                    }
                    ++i;
                }
                SelfHealingMobileExcludedKeywordsComposite.this.excludeKeywords.add(newDefaultKeyword.getName());
                SelfHealingMobileExcludedKeywordsComposite.this.tableViewer.refresh();
                SelfHealingMobileExcludedKeywordsComposite.this.handleSelectionChange(null);
            }
        });
        ToolItem tltmRemoveVariable = new ToolItem(toolBar, 0);
        tltmRemoveVariable.setText("Remove");
        tltmRemoveVariable.setImage(ImageManager.getImage((String)"delete_16.png"));
        tltmRemoveVariable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Table table = SelfHealingMobileExcludedKeywordsComposite.this.tableViewer.getTable();
                table.setRedraw(false);
                IStructuredSelection selection = (IStructuredSelection)SelfHealingMobileExcludedKeywordsComposite.this.tableViewer.getSelection();
                for (String selectedObject : selection) {
                    SelfHealingMobileExcludedKeywordsComposite.this.tableViewer.remove((Object)selectedObject);
                    SelfHealingMobileExcludedKeywordsComposite.this.excludeKeywords.remove(selectedObject);
                }
                table.setRedraw(true);
                if (OSUtil.isMacBigSurOrLater()) {
                    table.redraw();
                }
                SelfHealingMobileExcludedKeywordsComposite.this.handleSelectionChange(null);
            }
        });
        Composite tableExcludedKeywordsComposite = new Composite((Composite)excludedKeywordsGroup, 0);
        GridData ldTableComposite = new GridData(4, 4, true, true, 1, 1);
        ldTableComposite.minimumHeight = 100;
        tableExcludedKeywordsComposite.setLayoutData((Object)ldTableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableExcludedKeywordsComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(tableExcludedKeywordsComposite, 68114);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn tvcName = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tName = tvcName.getColumn();
        tName.setText(SmartXPathMessageConstants.COLUMN_KEYWORD);
        tvcName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SelectorMethod label = (SelectorMethod)element;
                return label.getName();
            }
        });
        tvcName.setEditingSupport((EditingSupport)new ExcludeKeywordsEditingSupport(this.tableViewer, this.getMobileKeywordsStringList()){

            @Override
            protected void setValue(Object element, Object value) {
                String property;
                if (element != null && element instanceof String && value != null && value instanceof String && !value.equals(property = (String)element)) {
                    try {
                        KeywordMethod newProperty = KeywordController.getInstance().getBuiltInKeywordByName(SmartXPathMessageConstants.MOBILE_BUILT_IN_KEYWORDS_CLASS_NAME, (String)value);
                        int changedKeywordIndex = SelfHealingMobileExcludedKeywordsComposite.this.excludeKeywords.indexOf(property);
                        if (changedKeywordIndex >= 0) {
                            SelfHealingMobileExcludedKeywordsComposite.this.excludeKeywords.set(changedKeywordIndex, newProperty.getName());
                        }
                        SelfHealingMobileExcludedKeywordsComposite.this.tableViewer.refresh();
                        SelfHealingMobileExcludedKeywordsComposite.this.handleSelectionChange(null);
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return this.getCellEditor(element, SelfHealingMobileExcludedKeywordsComposite.this.getMobileKeywordsStringList());
            }
        });
        tvcName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String keyword = (String)element;
                return keyword;
            }
        });
        tableColumnLayout.setColumnData((Widget)tName, (ColumnLayoutData)new ColumnWeightData(80, 100));
    }

    public void setInput(List<String> excludedKeywords) {
        this.excludeKeywords = excludedKeywords.stream().filter(k -> !MobileSettingStore.EXCLUDED_SELF_HEALING_KEYWORDS.contains(k)).collect(Collectors.toList());
        this.tableViewer.setInput(this.excludeKeywords);
    }

    private String[] getMobileKeywordsStringList() {
        List<KeywordMethod> mobileKeywords = this.getMobileBuiltinKeywords();
        ArrayList<String> mobileKeywordStringList = new ArrayList<String>();
        for (KeywordMethod keyword : mobileKeywords) {
            if (this.excludeKeywords.contains(keyword.getName())) continue;
            mobileKeywordStringList.add(keyword.getName());
        }
        return mobileKeywordStringList.toArray(new String[0]);
    }

    public List<String> getInput() {
        return Stream.concat(MobileSettingStore.EXCLUDED_SELF_HEALING_KEYWORDS.stream(), this.excludeKeywords.stream()).collect(Collectors.toList());
    }

    public boolean compareInput(List<String> excludeKeyword) {
        return excludeKeyword.equals(this.getInput());
    }

    private void handleSelectionChange(TypedEvent selectionEvent) {
        this.dispatchSelectionEvent(selectionEvent);
    }

    private void dispatchSelectionEvent(TypedEvent selectionEvent) {
        this.notifyListeners(13, null);
        this.notifyListeners(14, null);
    }

    private List<KeywordMethod> getMobileBuiltinKeywords() {
        List mobileKeywords = KeywordController.getInstance().getBuiltInKeywords(SmartXPathMessageConstants.MOBILE_BUILT_IN_KEYWORDS_SIMPLE_CLASS_NAME, true);
        return mobileKeywords.stream().filter(k -> !MobileSettingStore.EXCLUDED_SELF_HEALING_KEYWORDS.contains(k.getName())).collect(Collectors.toList());
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((EventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }
}

