/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.dialog;

import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PrepareForMigrationDialog
extends Dialog {
    private final String migrationGuideUrl;
    private Runnable startMigrationHandler;

    public PrepareForMigrationDialog(Shell parentShell, String migrationGuideUrl) {
        super(parentShell);
        this.migrationGuideUrl = migrationGuideUrl;
    }

    public void setStartMigrationHandler(Runnable handler) {
        this.startMigrationHandler = handler;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Prepare for migration");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        ComponentUtil.setMargin((Composite)container, (int)10, (int)10);
        ComponentBuilder.label((Composite)container, (int)64).text("You're about to migrate your project scripts to the latest version. This may update or reformat your existing test scripts.\n\u26a0\ufe0f Do not edit project files during migration - any changes may be lost.\nWe recommend:\n").build();
        Composite recommend = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)1).fill().build();
        ComponentBuilder.link((Composite)recommend, (int)64).text("\u2022 Review <a href=\"" + this.migrationGuideUrl + "\">the migration guide</a> to see what will change").build();
        ComponentBuilder.label((Composite)recommend, (int)64).text("\u2022 Back up your project as an extra precaution").build();
        ComponentBuilder.label((Composite)recommend, (int)64).text("\nDo you want to continue?").build();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Cancel", false);
        Button startButton = this.createButton(parent, 0, "Start Migration", true);
        startButton.addListener(13, e -> {
            if (this.startMigrationHandler != null) {
                this.startMigrationHandler.run();
            }
            this.close();
        });
    }
}

