/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.handler;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.components.services.PartServiceSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.migration.controller.MigrationController;
import com.kms.katalon.migration.dialog.MigrationHistoryDialog;
import com.kms.katalon.migration.dialog.PatchViewerDialog;
import com.kms.katalon.migration.dialog.PostCancelMigrationDialog;
import com.kms.katalon.migration.dialog.PostCompleteDialog;
import com.kms.katalon.migration.dialog.PostFailMigrationDialog;
import com.kms.katalon.migration.dialog.PrepareForMigrationDialog;
import com.kms.katalon.migration.model.MigrationAttempt;
import com.kms.katalon.migration.model.MigrationPlan;
import com.kms.katalon.migration.model.ProgressUpdate;
import com.kms.katalon.migration.parts.MigrationProgressPart;
import com.kms.katalon.migration.service.MigrationAttemptLoggerFactory;
import com.kms.katalon.tracking.service.Trackings;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MigrateHandler {
    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    public void execute(Shell shell, String fromVersion, String toVersion) {
        final ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"No project is open to migrate.");
            return;
        }
        Trackings.trackAutoMigrateSelectRecipes((String)String.format("%s_to_%s", fromVersion, toVersion));
        MigrationController controller = new MigrationController();
        AtomicReference migrationPlanHolder = new AtomicReference();
        try {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
            progressDialog.run(true, false, monitor -> {
                monitor.beginTask("Loading migration plan...", -1);
                migrationPlanHolder.set(controller.fetchMigrationPlan(fromVersion, toVersion));
                monitor.done();
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)("Failed to load migration plan: " + e.getMessage()));
            return;
        }
        final MigrationPlan migrationPlan = (MigrationPlan)migrationPlanHolder.get();
        PrepareForMigrationDialog prepareDialog = new PrepareForMigrationDialog(shell, migrationPlan.getDocumentationLink());
        AtomicBoolean userAgreedToMigrate = new AtomicBoolean(false);
        prepareDialog.setStartMigrationHandler(() -> userAgreedToMigrate.set(true));
        prepareDialog.open();
        if (!userAgreedToMigrate.get()) {
            return;
        }
        final MigrationProgressPart migrationProgressView = this.openMigrationProgressView();
        if (migrationProgressView == null) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Migration progress view could not be opened.");
            return;
        }
        Job migrateJob = new Job("Katalon Project Migration"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    MigrateHandler.this.runMigrationTest(project, migrationPlan, migrationProgressView);
                    return Status.OK_STATUS;
                }
                catch (Throwable t) {
                    return new Status(4, "com.kms.katalon.migration", "Migration job failed: " + t.getMessage(), t);
                }
            }
        };
        migrateJob.setUser(false);
        migrateJob.setPriority(30);
        migrateJob.schedule();
    }

    private MigrationProgressPart openMigrationProgressView() {
        MPart migrationProgressPart;
        EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
        MApplication application = ApplicationSingleton.getInstance().getApplication();
        EPartService partService = PartServiceSingleton.getInstance().getPartService();
        List psList = modelService.findElements((MUIElement)application, null, MPerspectiveStack.class, null);
        MPartStack consolePartStack = (MPartStack)modelService.find("com.kms.katalon.partstack.console", ((MPerspectiveStack)psList.get(0)).getSelectedElement());
        consolePartStack.getTags().remove("Minimized");
        consolePartStack.setVisible(true);
        if (!consolePartStack.isToBeRendered()) {
            consolePartStack.setToBeRendered(true);
        }
        if ((migrationProgressPart = (MPart)modelService.find("com.kms.katalon.migration.part.progress", (MUIElement)consolePartStack)) == null) {
            return null;
        }
        if (!consolePartStack.getChildren().contains(migrationProgressPart)) {
            partService.createPart("com.kms.katalon.migration.part.progress");
            consolePartStack.getChildren().add(migrationProgressPart);
        }
        if (!migrationProgressPart.isToBeRendered()) {
            migrationProgressPart.setToBeRendered(true);
        }
        migrationProgressPart.setVisible(true);
        consolePartStack.setSelectedElement((MUIElement)migrationProgressPart);
        partService.activate(migrationProgressPart, true);
        return (MigrationProgressPart)migrationProgressPart.getObject();
    }

    private void runMigrationTest(ProjectEntity project, MigrationPlan migrationPlan, MigrationProgressPart migrationProgressPart) {
        MigrationController controller = new MigrationController();
        MigrationAttempt attempt = controller.initializeMigrationAttempt(project, migrationPlan);
        migrationProgressPart.prepareToRunWithPlan(attempt.getMigrationPlan());
        Consumer<ProgressUpdate> progressCallback = update -> migrationProgressPart.onProgressUpdate((ProgressUpdate)update);
        migrationProgressPart.setStopHandler(() -> {
            controller.cancel(attempt, progressCallback);
            Shell shell = Display.getCurrent().getActiveShell();
            PostCancelMigrationDialog dialog = new PostCancelMigrationDialog(shell);
            dialog.setRevertHandler(() -> controller.revert(attempt, progressCallback));
            dialog.setKeepChangesHandler(() -> {});
            dialog.open();
        });
        migrationProgressPart.setRevertHandler(() -> {
            Shell shell = Display.getCurrent().getActiveShell();
            List<MigrationAttempt> attempts = controller.loadAttemptsHistory(project);
            MigrationHistoryDialog dialog = new MigrationHistoryDialog(shell, attempts);
            dialog.setRevertHandler(selectedAttempt -> controller.revert((MigrationAttempt)selectedAttempt, progressCallback));
            dialog.open();
        });
        migrationProgressPart.setViewChangeLogHandler(() -> {
            Shell shell = Display.getCurrent().getActiveShell();
            PatchViewerDialog.openStandalonePatchViewer(shell, attempt);
        });
        migrationProgressPart.setOpenDocumentationHandler(() -> Program.launch((String)attempt.getMigrationPlan().getDocumentationLink()));
        MigrationAttemptLoggerFactory.getInstance().muteOpenRewriteLogger();
        controller.dryRun(attempt, progressCallback);
        controller.apply(attempt, progressCallback);
        MigrationAttempt.Status attemptStatus = attempt.getStatus();
        UISynchronizeService.asyncExec(() -> {
            Shell shell = Display.getCurrent().getActiveShell();
            switch (attemptStatus) {
                case APPLIED: {
                    PostCompleteDialog dialogOk = new PostCompleteDialog(shell);
                    dialogOk.open();
                    break;
                }
                case APPLY_FAILED: {
                    PostFailMigrationDialog dialogFail = new PostFailMigrationDialog(shell, attempt.getErrorMessage());
                    dialogFail.setRevertHandler(() -> controller.revert(attempt, progressCallback));
                    dialogFail.setKeepChangesHandler(() -> {});
                    dialogFail.open();
                    break;
                }
            }
        });
    }
}

