/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.model;

import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AppiumConstants {
    private static final Map<String, String> DEPRECATED_MOBILE_CAP_TYPE_MAP = new HashMap<String, String>();
    public static Set<String> W3C_STANDARD_CAPS;
    public static Set<String> APPIUM_PREFIX_REQUIRED_CAPS;
    public static final Set<String> APPIUM_DRIVER_CLASS_SIMPLE_NAMES;

    static {
        APPIUM_PREFIX_REQUIRED_CAPS = new HashSet<String>();
        W3C_STANDARD_CAPS = Set.of("browserName", "browserVersion", "platformName", "acceptInsecureCerts", "pageLoadStrategy", "proxy", "setWindowRect", "timeouts", "unhandledPromptBehavior");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("APP", "app");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("APP_ACTIVITY", "appActivity");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("APP_PACKAGE", "appPackage");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("APP_WAIT_ACTIVITY", "appWaitActivity");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("APP_WAIT_PACKAGE", "appWaitPackage");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("APPIUM_VERSION", "appiumVersion");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("AUTO_WEBVIEW", "autoWebview");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("AUTOMATION_NAME", "automationName");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("AUTO_ACCEPT_ALERTS", "autoAcceptAlerts");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("BROWSER_NAME", "browserName");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("CLEAR_SYSTEM_FILES", "clearSystemFiles");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("DEVICE_NAME", "deviceName");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("DEVICE_READY_TIMEOUT", "deviceReadyTimeout");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("DONT_STOP_APP_ON_RESET", "dontStopAppOnReset");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("EVENT_TIMINGS", "eventTimings");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("FORCE_MJSONWP", "forceMjsonwp");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("FULL_RESET", "fullReset");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("LANGUAGE", "language");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("LOCALE", "locale");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("LAUNCH_TIMEOUT", "launchTimeout");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("NEW_COMMAND_TIMEOUT", "newCommandTimeout");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("NO_RESET", "noReset");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("ORIENTATION", "orientation");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("PLATFORM_NAME", "platformName");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("PLATFORM_VERSION", "platformVersion");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("UDID", "udid");
        DEPRECATED_MOBILE_CAP_TYPE_MAP.put("UNICODE_KEYBOARD", "unicodeKeyboard");
        APPIUM_PREFIX_REQUIRED_CAPS = DEPRECATED_MOBILE_CAP_TYPE_MAP.values().stream().filter(value -> !W3C_STANDARD_CAPS.contains(value)).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        APPIUM_PREFIX_REQUIRED_CAPS.addAll(Set.of("appWaitDuration", "autoGrantPermissions", "androidInstallTimeout", "bundleId", "ignoreUnimportantViews", "safariInitialUrl"));
        APPIUM_DRIVER_CLASS_SIMPLE_NAMES = Set.of("AppiumDriver", "AndroidDriver", "IOSDriver", "MobileDriver");
    }

    public static String convertMobileCapabilityTypeEnumToString(String deprecatedCap) {
        if (deprecatedCap == null) {
            return null;
        }
        return DEPRECATED_MOBILE_CAP_TYPE_MAP.get(deprecatedCap);
    }
}

