/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.migration.model.MigrationEntry;
import com.kms.katalon.migration.model.MigrationPlan;
import com.kms.katalon.migration.model.ProblemMarkerInfo;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MigrationAttempt {
    private static final String METADATA_JSON_FILE_NAME = "attempt.json";
    private String attemptId;
    private String projectUuid;
    private String projectRootPath;
    private String projectNameId;
    private MigrationPlan migrationPlan;
    private Path migrationAttemptDirPath;
    private Path metadataJsonPath;
    private Path backupPath;
    private Path logFilePath;
    private Path diffFilePath;
    private Path beforeMigrationCompileResultPath;
    private Path afterMigrationCompileResultPath;
    private Stats stats = new Stats();
    private Date startTime;
    @JsonIgnore
    private List<MigrationEntry> entries;
    private volatile Status status;
    private String errorMessage;

    public MigrationAttempt() {
    }

    public MigrationAttempt(ProjectEntity projectEntity, MigrationPlan migrationPlan) {
        Date now = new Date();
        this.attemptId = String.valueOf(now.toInstant().toEpochMilli());
        this.projectUuid = projectEntity.getUUID();
        this.projectRootPath = projectEntity.getFolderLocation();
        this.projectNameId = projectEntity.getLocation().toString().replace(File.separator, "%").replace(":", "%");
        this.migrationPlan = migrationPlan;
        this.startTime = now;
        this.status = Status.INIT;
        this.entries = new ArrayList<MigrationEntry>();
        String migrationAttemptDir = MigrationAttempt.getMigrationAttemptsDir(projectEntity.getUUID()) + File.separator + this.attemptId;
        this.migrationAttemptDirPath = Path.of(migrationAttemptDir, new String[0]);
        this.metadataJsonPath = Path.of(migrationAttemptDir, METADATA_JSON_FILE_NAME);
        this.backupPath = Path.of(migrationAttemptDir, "backup");
        this.logFilePath = Path.of(migrationAttemptDir, "migration.log");
        this.diffFilePath = Path.of(migrationAttemptDir, "diff.txt");
        this.beforeMigrationCompileResultPath = Path.of(migrationAttemptDir, "before-migration-compile-result.txt");
        this.afterMigrationCompileResultPath = Path.of(migrationAttemptDir, "after-migration-compile-result.txt");
        this.setStats(new Stats());
    }

    private static String getMigrationAttemptsDir(String projectUUID) {
        return GlobalStringConstants.KATALON_PROJECTS_DIR + File.separator + projectUUID + File.separator + "migration-attempts";
    }

    public static List<MigrationAttempt> loadMigrationAttempts(ProjectEntity projectEntity) {
        ArrayList<MigrationAttempt> attempts = new ArrayList<MigrationAttempt>();
        Path attemptsDirPath = Path.of(MigrationAttempt.getMigrationAttemptsDir(projectEntity.getUUID()), new String[0]);
        if (!Files.exists(attemptsDirPath, new LinkOption[0]) || !Files.isDirectory(attemptsDirPath, new LinkOption[0])) {
            return attempts;
        }
        try {
            Files.list(attemptsDirPath).filter(path -> Files.isDirectory(path, new LinkOption[0])).forEach(attemptDir -> {
                MigrationAttempt attempt = MigrationAttempt.safelyGetRevertableAttemptFromJsonFile(attemptDir);
                if (attempt != null) {
                    attempts.add(attempt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        attempts.sort((a, b) -> {
            if (a.getStartTime() == null && b.getStartTime() == null) {
                return 0;
            }
            if (a.getStartTime() == null) {
                return 1;
            }
            if (b.getStartTime() == null) {
                return -1;
            }
            return b.getStartTime().compareTo(a.getStartTime());
        });
        return attempts.subList(0, Math.min(attempts.size(), 20));
    }

    public static boolean hasAtLeastOneRevertableAttempt(ProjectEntity projectEntity) {
        Path attemptsDirPath = Path.of(MigrationAttempt.getMigrationAttemptsDir(projectEntity.getUUID()), new String[0]);
        if (!Files.exists(attemptsDirPath, new LinkOption[0]) || !Files.isDirectory(attemptsDirPath, new LinkOption[0])) {
            return false;
        }
        AtomicBoolean found = new AtomicBoolean(false);
        try {
            Files.list(attemptsDirPath).filter(path -> Files.isDirectory(path, new LinkOption[0])).forEach(attemptDir -> {
                if (found.get()) {
                    return;
                }
                MigrationAttempt attempt = MigrationAttempt.safelyGetRevertableAttemptFromJsonFile(attemptDir);
                if (attempt != null) {
                    found.set(true);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return found.get();
    }

    private static MigrationAttempt safelyGetRevertableAttemptFromJsonFile(Path attemptDir) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            MigrationAttempt attempt = (MigrationAttempt)mapper.readValue(attemptDir.resolve(METADATA_JSON_FILE_NAME).toFile(), MigrationAttempt.class);
            if (attempt.canRevert() && Files.exists(attempt.getBackupPath(), new LinkOption[0])) {
                return attempt;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return null;
    }

    public void safelySaveToJsonFile() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Path parent = this.metadataJsonPath.getParent();
            if (parent != null) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (Exception exception) {}
            }
            mapper.writeValue(this.metadataJsonPath.toFile(), (Object)this);
        }
        catch (Exception exception) {}
    }

    public boolean isCancelled() {
        return this.status == Status.CANCELLED;
    }

    public boolean canRevert() {
        return this.status == Status.APPLIED || this.status == Status.APPLYING || this.status == Status.APPLY_FAILED || this.status == Status.CANCELLED || this.status == Status.REVERTED;
    }

    public boolean canApply() {
        return this.status == Status.DRY_RUN_COMPLETED;
    }

    public boolean changeAndSaveStatus(Status newStatus) {
        if (this.status == Status.CANCELLED) {
            return false;
        }
        this.status = newStatus;
        this.safelySaveToJsonFile();
        return true;
    }

    public MigrationEntry addEntry(MigrationEntry entry) {
        this.entries.add(entry);
        return entry;
    }

    public void calculateStats() {
        int groovyAstFiles = 0;
        int groovyNonAstFiles = 0;
        int jsonPropertiesFiles = 0;
        int groovyAstFileChanges = 0;
        int groovyNonAstFileChanges = 0;
        int jsonPropertiesFileChanges = 0;
        for (MigrationEntry entry : this.entries) {
            if (entry.getSourceFileSyntaxType() == MigrationEntry.SourceFileSyntaxType.GROOVY_AST) {
                ++groovyAstFiles;
                if (entry.getStatus() != MigrationEntry.Status.CHANGED) continue;
                ++groovyAstFileChanges;
                continue;
            }
            if (entry.getSourceFileSyntaxType() == MigrationEntry.SourceFileSyntaxType.GROOVY_NON_AST) {
                ++groovyNonAstFiles;
                if (entry.getStatus() != MigrationEntry.Status.CHANGED) continue;
                ++groovyNonAstFileChanges;
                continue;
            }
            if (entry.getSourceFileSyntaxType() != MigrationEntry.SourceFileSyntaxType.JSON_PROPERTIES) continue;
            ++jsonPropertiesFiles;
            if (entry.getStatus() != MigrationEntry.Status.CHANGED) continue;
            ++jsonPropertiesFileChanges;
        }
        this.stats.setNumGroovyAstFiles(groovyAstFiles);
        this.stats.setNumGroovyNonAstFiles(groovyNonAstFiles);
        this.stats.setNumJsonPropertiesFiles(jsonPropertiesFiles);
        this.stats.setNumGroovyAstFileChanges(groovyAstFileChanges);
        this.stats.setNumGroovyNonAstFileChanges(groovyNonAstFileChanges);
        this.stats.setNumJsonPropertiesFileChanges(jsonPropertiesFileChanges);
    }

    public void updateProblemStatsBeforeMigration(List<ProblemMarkerInfo> problems) {
        if (problems == null) {
            return;
        }
        int errors = (int)problems.stream().filter(p -> "ERROR".equals(p.getSeverity())).count();
        int warnings = (int)problems.stream().filter(p -> "WARNING".equals(p.getSeverity())).count();
        this.stats.setNumProblemsErrorBefore(errors);
        this.stats.setNumProblemsWarningBefore(warnings);
        this.safelySaveToJsonFile();
    }

    public void updateProblemStatsAfterMigration(List<ProblemMarkerInfo> problems) {
        if (problems == null) {
            return;
        }
        int errors = (int)problems.stream().filter(p -> "ERROR".equals(p.getSeverity())).count();
        int warnings = (int)problems.stream().filter(p -> "WARNING".equals(p.getSeverity())).count();
        this.stats.setNumProblemsErrorAfter(errors);
        this.stats.setNumProblemsWarningAfter(warnings);
        this.safelySaveToJsonFile();
    }

    public String getAttemptId() {
        return this.attemptId;
    }

    public void setAttemptId(String attemptId) {
        this.attemptId = attemptId;
    }

    public MigrationPlan getMigrationPlan() {
        return this.migrationPlan;
    }

    public void setMigrationPlan(MigrationPlan migrationPlan) {
        this.migrationPlan = migrationPlan;
    }

    public Path getBackupPath() {
        return this.backupPath;
    }

    public void setBackupPath(Path backupPath) {
        this.backupPath = backupPath;
    }

    public List<MigrationEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<MigrationEntry> entries) {
        this.entries = entries;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Path getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(Path logFilePath) {
        this.logFilePath = logFilePath;
    }

    public Path getDiffFilePath() {
        return this.diffFilePath;
    }

    public void setDiffFilePath(Path diffFilePath) {
        this.diffFilePath = diffFilePath;
    }

    public Path getBeforeMigrationCompileResultPath() {
        return this.beforeMigrationCompileResultPath;
    }

    public void setBeforeMigrationCompileResultPath(Path beforeMigrationCompileResultPath) {
        this.beforeMigrationCompileResultPath = beforeMigrationCompileResultPath;
    }

    public Path getAfterMigrationCompileResultPath() {
        return this.afterMigrationCompileResultPath;
    }

    public void setAfterMigrationCompileResultPath(Path afterMigrationCompileResultPath) {
        this.afterMigrationCompileResultPath = afterMigrationCompileResultPath;
    }

    public Path getMetadataJsonPath() {
        return this.metadataJsonPath;
    }

    public void setMetadataJsonPath(Path metadataJsonPath) {
        this.metadataJsonPath = metadataJsonPath;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public void setProjectUuid(String projectUuid) {
        this.projectUuid = projectUuid;
    }

    public String getProjectRootPath() {
        return this.projectRootPath;
    }

    public void setProjectRootPath(String projectRootPath) {
        this.projectRootPath = projectRootPath;
    }

    public String getProjectNameId() {
        return this.projectNameId;
    }

    public void setProjectNameId(String projectNameId) {
        this.projectNameId = projectNameId;
    }

    @JsonSetter(value="stats")
    public void setStatsSafe(Stats stats) {
        try {
            this.stats = stats != null ? stats : new Stats();
        }
        catch (Exception exception) {
            this.stats = new Stats();
        }
    }

    public Stats getStats() {
        return this.stats;
    }

    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public Path getMigrationAttemptDirPath() {
        return this.migrationAttemptDirPath;
    }

    public void setMigrationAttemptDirPath(Path migrationAttemptDirPath) {
        this.migrationAttemptDirPath = migrationAttemptDirPath;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Stats {
        private int numGroovyAstFiles;
        private int numGroovyNonAstFiles;
        private int numGroovyAstFileChanges;
        private int numGroovyNonAstFileChanges;
        private int numJsonPropertiesFiles;
        private int numJsonPropertiesFileChanges;
        private int numProblemsErrorBefore;
        private int numProblemsWarningBefore;
        private int numProblemsErrorAfter;
        private int numProblemsWarningAfter;

        @JsonIgnore
        public int getTotalFileChanges() {
            return this.numGroovyAstFileChanges + this.numGroovyNonAstFileChanges + this.numJsonPropertiesFileChanges;
        }

        public Map<String, Integer> toTrackingProps() {
            return Map.of("groovy_ast_files", this.numGroovyAstFiles, "groovy_non_ast_files", this.numGroovyNonAstFiles, "json_properties_files", this.numJsonPropertiesFiles, "groovy_ast_file_changed", this.numGroovyAstFileChanges, "groovy_non_ast_files_changed", this.numGroovyNonAstFileChanges, "json_properties_files_changed", this.numJsonPropertiesFileChanges);
        }

        public int getNumGroovyAstFiles() {
            return this.numGroovyAstFiles;
        }

        public void setNumGroovyAstFiles(int numAstParsedFiles) {
            this.numGroovyAstFiles = numAstParsedFiles;
        }

        public int getNumGroovyNonAstFiles() {
            return this.numGroovyNonAstFiles;
        }

        public void setNumGroovyNonAstFiles(int numPlainTextFiles) {
            this.numGroovyNonAstFiles = numPlainTextFiles;
        }

        public int getNumGroovyAstFileChanges() {
            return this.numGroovyAstFileChanges;
        }

        public void setNumGroovyAstFileChanges(int numAstFileChanges) {
            this.numGroovyAstFileChanges = numAstFileChanges;
        }

        public int getNumGroovyNonAstFileChanges() {
            return this.numGroovyNonAstFileChanges;
        }

        public void setNumGroovyNonAstFileChanges(int numPlainTextFileChanges) {
            this.numGroovyNonAstFileChanges = numPlainTextFileChanges;
        }

        public int getNumJsonPropertiesFiles() {
            return this.numJsonPropertiesFiles;
        }

        public void setNumJsonPropertiesFiles(int numJsonPropertiesFiles) {
            this.numJsonPropertiesFiles = numJsonPropertiesFiles;
        }

        public int getNumJsonPropertiesFileChanges() {
            return this.numJsonPropertiesFileChanges;
        }

        public void setNumJsonPropertiesFileChanges(int numJsonPropertiesFileChanges) {
            this.numJsonPropertiesFileChanges = numJsonPropertiesFileChanges;
        }

        public int getNumProblemsErrorBefore() {
            return this.numProblemsErrorBefore;
        }

        public void setNumProblemsErrorBefore(int numProblemsErrorBefore) {
            this.numProblemsErrorBefore = numProblemsErrorBefore;
        }

        public int getNumProblemsWarningBefore() {
            return this.numProblemsWarningBefore;
        }

        public void setNumProblemsWarningBefore(int numProblemsWarningBefore) {
            this.numProblemsWarningBefore = numProblemsWarningBefore;
        }

        public int getNumProblemsErrorAfter() {
            return this.numProblemsErrorAfter;
        }

        public void setNumProblemsErrorAfter(int numProblemsErrorAfter) {
            this.numProblemsErrorAfter = numProblemsErrorAfter;
        }

        public int getNumProblemsWarningAfter() {
            return this.numProblemsWarningAfter;
        }

        public void setNumProblemsWarningAfter(int numProblemsWarningAfter) {
            this.numProblemsWarningAfter = numProblemsWarningAfter;
        }
    }

    public static enum Status {
        INIT,
        DRY_RUN_COMPLETED,
        APPLYING,
        APPLIED,
        APPLY_FAILED,
        REVERTED,
        CANCELLED;

    }
}

