/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service;

import com.kms.katalon.migration.model.AppiumConstants;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.TreeVisitingPrinter;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class AstRecipeHelper {
    public static void printTree(J root) {
        System.out.println(TreeVisitingPrinter.printTree((Tree)root));
    }

    public static J findParentContainer(Cursor originalCursor) {
        Cursor cursor = originalCursor;
        while (cursor != null) {
            Object value = cursor.getValue();
            if (value instanceof JRightPadded) {
                value = ((JRightPadded)value).getElement();
            }
            if (value instanceof JLeftPadded) {
                value = ((JLeftPadded)value).getElement();
            }
            if (value instanceof J.Block || value instanceof J.MethodDeclaration || value instanceof J.CompilationUnit) {
                return (J)value;
            }
            cursor = cursor.getParent();
        }
        return null;
    }

    public static List<Statement> buildStatementsFromGroovyCode(String groovyCode, Space indentation) {
        G.CompilationUnit compilationUnit = AstRecipeHelper.buildCompilationUnitFromGroovyCode(groovyCode);
        if (compilationUnit == null) {
            return List.of();
        }
        return compilationUnit.getStatements().stream().map(statement -> (Statement)statement.withPrefix(indentation)).toList();
    }

    public static G.CompilationUnit buildCompilationUnitFromGroovyCode(String groovyCode) {
        List parsedList = GroovyParser.builder().build().parse(new String[]{groovyCode}).filter(sourceFile -> sourceFile instanceof G.CompilationUnit).map(sourceFile -> (G.CompilationUnit)sourceFile).collect(Collectors.toList());
        if (!parsedList.isEmpty()) {
            return (G.CompilationUnit)parsedList.get(0);
        }
        return null;
    }

    public static SourceFile buildSourceFileFromGroovyCode(String groovyCode, String relativePath) {
        return ((SourceFile)GroovyParser.builder().build().parse(new String[]{groovyCode}).findFirst().orElse(null)).withSourcePath(Path.of(relativePath, new String[0]));
    }

    private static J.Import createImport(String fqcn) {
        return new J.Import(UUID.randomUUID(), Space.format((String)"\n"), Markers.EMPTY, new JLeftPadded(Space.SINGLE_SPACE, (Object)false, Markers.EMPTY), (J.FieldAccess)((Expression)TypeTree.build((String)fqcn)).withPrefix(Space.SINGLE_SPACE), null);
    }

    public static J.Literal createStringLiteral(String value) {
        return new J.Literal(UUID.randomUUID(), Space.EMPTY, Markers.EMPTY, (Object)value, "\"" + value + "\"", null, JavaType.Primitive.String);
    }

    public static Expression createEnumFieldAccess(String expression) {
        String[] parts = expression.split("\\.");
        if (parts.length != 2) {
            return AstRecipeHelper.createStringLiteral(expression);
        }
        J.Identifier enumType = new J.Identifier(UUID.randomUUID(), Space.EMPTY, Markers.EMPTY, List.of(), parts[0], null, null);
        J.Identifier enumValue = new J.Identifier(UUID.randomUUID(), Space.EMPTY, Markers.EMPTY, List.of(), parts[1], null, null);
        return new J.FieldAccess(UUID.randomUUID(), Space.EMPTY, Markers.EMPTY, (Expression)enumType, new JLeftPadded(Space.EMPTY, (Object)enumValue, Markers.EMPTY), null);
    }

    public static J.Return createReturnStatement(Expression expression) {
        return new J.Return(UUID.randomUUID(), Space.EMPTY, Markers.EMPTY, expression);
    }

    public static G.CompilationUnit updateImports(G.CompilationUnit cu, Set<String> requiredImports, Set<String> importsToRemove) {
        List<String> existingImports = cu.getImports().stream().map(J.Import::getTypeName).toList();
        List filteredImports = cu.getImports().stream().filter(imp -> {
            String typeName = imp.getTypeName();
            return typeName != null && !importsToRemove.contains(typeName);
        }).collect(Collectors.toCollection(ArrayList::new));
        for (String fqcn : requiredImports) {
            if (existingImports.contains(fqcn) || importsToRemove.contains(fqcn)) continue;
            filteredImports.add(AstRecipeHelper.createImport(fqcn));
        }
        return cu.withImports(filteredImports);
    }

    public static String getVariableName(J.MethodInvocation methodInvocation) {
        if (methodInvocation.getSelect() == null) {
            return null;
        }
        Expression select = methodInvocation.getSelect();
        if (select instanceof J.Identifier) {
            J.Identifier identifier = (J.Identifier)select;
            return identifier.getSimpleName();
        }
        if (select instanceof J.MethodInvocation) {
            J.MethodInvocation methodCall = (J.MethodInvocation)select;
            return AstRecipeHelper.buildMethodChain(methodCall);
        }
        return select.getClass().getSimpleName();
    }

    private static String buildMethodChain(J.MethodInvocation methodInvocation) {
        StringBuilder chain = new StringBuilder();
        if (methodInvocation.getSelect() != null) {
            Expression select = methodInvocation.getSelect();
            if (select instanceof J.Identifier) {
                J.Identifier identifier = (J.Identifier)select;
                chain.append(identifier.getSimpleName());
            } else if (select instanceof J.MethodInvocation) {
                J.MethodInvocation methodCall = (J.MethodInvocation)select;
                chain.append(AstRecipeHelper.buildMethodChain(methodCall));
            } else {
                chain.append(select.getClass().getSimpleName());
            }
        }
        chain.append(".").append(methodInvocation.getSimpleName()).append("()");
        return chain.toString();
    }

    public static String buildStringFromExpression(Expression expr) {
        if (expr instanceof J.Identifier) {
            J.Identifier id = (J.Identifier)expr;
            return id.getSimpleName();
        }
        if (expr instanceof J.MethodInvocation) {
            J.MethodInvocation mi = (J.MethodInvocation)expr;
            StringBuilder sb = new StringBuilder();
            if (mi.getSelect() != null) {
                sb.append(AstRecipeHelper.buildStringFromExpression(mi.getSelect())).append(".");
            }
            sb.append(mi.getSimpleName());
            sb.append("(");
            int i = 0;
            while (i < mi.getArguments().size()) {
                Expression arg;
                if (i > 0) {
                    sb.append(", ");
                }
                if (!((arg = (Expression)mi.getArguments().get(i)) instanceof J.Empty)) {
                    sb.append(AstRecipeHelper.buildStringFromExpression(arg));
                }
                ++i;
            }
            sb.append(")");
            return sb.toString();
        }
        return expr.toString();
    }

    public static void printMethodInvocation(J.MethodInvocation methodInvocation) {
        String variableType = "null";
        String variableShortType = "null";
        String variableName = "null";
        if (methodInvocation.getSelect() != null) {
            Expression select = methodInvocation.getSelect();
            if (select instanceof J.Identifier) {
                J.Identifier identifier = (J.Identifier)select;
                variableName = identifier.getSimpleName();
                if (identifier.getType() != null) {
                    variableType = identifier.getType().toString();
                    JavaType javaType = identifier.getType();
                    if (javaType instanceof JavaType.Class) {
                        JavaType.Class classType = (JavaType.Class)javaType;
                        variableType = classType.getFullyQualifiedName();
                    }
                    variableShortType = variableType.contains(".") ? variableType.substring(variableType.lastIndexOf(46) + 1) : variableType;
                }
            } else if (select.getType() != null) {
                variableType = select.getType().toString();
                JavaType javaType = select.getType();
                if (javaType instanceof JavaType.Class) {
                    JavaType.Class classType = (JavaType.Class)javaType;
                    variableType = classType.getFullyQualifiedName();
                }
                variableShortType = variableType.contains(".") ? variableType.substring(variableType.lastIndexOf(46) + 1) : variableType;
            } else {
                variableType = variableShortType = select.getClass().getSimpleName();
            }
        }
        String methodName = methodInvocation.getSimpleName();
        System.out.println("Method call: " + String.valueOf(methodInvocation));
        System.out.println("---- var name: " + variableName + ", var type: " + variableShortType + ", var full type: " + variableType + ", method name: " + methodName);
    }

    public static void printMethodDeclaration(J.MethodDeclaration method) {
        System.out.println("Method declaration: " + method.getName().getSimpleName());
        if (method.getLeadingAnnotations() != null && !method.getLeadingAnnotations().isEmpty()) {
            System.out.print("  Annotations: ");
            for (J.Annotation ann : method.getLeadingAnnotations()) {
                System.out.print("@" + ann.getAnnotationType().printTrimmed() + " ");
            }
            System.out.println();
        }
    }

    public static boolean doesVariableTypeContain(J.Identifier identifier, String typeName) {
        return identifier.getType() != null && identifier.getType().toString().contains(typeName);
    }

    public static boolean isNewClassEqual(J.NewClass newClass, String typeName) {
        J.ParameterizedType pt;
        NameTree nameTree;
        if (typeName == null || typeName.isEmpty() || newClass == null || newClass.getClazz() == null) {
            return false;
        }
        TypeTree typeTree = newClass.getClazz();
        if (typeTree instanceof J.Identifier) {
            J.Identifier id = (J.Identifier)typeTree;
            return typeName.equals(id.getSimpleName());
        }
        TypeTree typeTree2 = newClass.getClazz();
        if (typeTree2 instanceof J.ParameterizedType && (nameTree = (pt = (J.ParameterizedType)typeTree2).getClazz()) instanceof J.Identifier) {
            J.Identifier id = (J.Identifier)nameTree;
            return typeName.equals(id.getSimpleName());
        }
        return false;
    }

    public static boolean hasNoRealArguments(List<Expression> args) {
        return args.stream().allMatch(arg -> arg instanceof J.Empty);
    }

    public static boolean isMethodSelectAppiumDriver(J.MethodInvocation method) {
        String varType;
        if (method.getSelect() == null) {
            return false;
        }
        String string = varType = method.getSelect().getType() != null ? method.getSelect().getType().toString() : "";
        if (!StringUtils.isEmpty((CharSequence)varType)) {
            return AppiumConstants.APPIUM_DRIVER_CLASS_SIMPLE_NAMES.stream().anyMatch(varType::contains);
        }
        Expression expression = method.getSelect();
        if (expression instanceof J.MethodInvocation) {
            String varType2;
            J.MethodInvocation method2 = (J.MethodInvocation)expression;
            if (method2.getSelect() == null) {
                return false;
            }
            String string2 = varType2 = method2.getSelect().getType() != null ? method2.getSelect().getType().toString() : "";
            if (!StringUtils.isEmpty((CharSequence)varType2)) {
                return "com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory".equals(varType2);
            }
        }
        return false;
    }
}

