/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlainTextRecipeHelper {
    private static String lineSeparator = System.lineSeparator();

    public static String insertImportAfterPackageDeclaration(String code, String importStmt) {
        if (code.contains(importStmt.trim())) {
            return code;
        }
        Pattern pkgDeclarationPattern = Pattern.compile("^(package\\s+[^\\r\\n]+)$", 8);
        Matcher matcher = pkgDeclarationPattern.matcher(code);
        if (matcher.find()) {
            int endOfPkgLine = matcher.end();
            return code.substring(0, endOfPkgLine) + "\n\n" + importStmt + code.substring(endOfPkgLine);
        }
        return importStmt + "\n" + code;
    }

    public static String removeImport(String code, String importPath) {
        String target = importPath.trim();
        if (target.startsWith("import")) {
            target = target.substring("import".length()).trim();
        }
        String regex = "(?m)^\\s*import\\s+" + Pattern.quote(target) + "(?:\\s+as\\s+\\w+)?;?\\s*$";
        return code.replaceAll(regex, "");
    }

    public static String replaceTypeOutsideImports(String code, String fromType, String toType) {
        StringBuilder newCode = new StringBuilder();
        String[] lines = code.split("\\r?\\n", -1);
        boolean replaced = false;
        String typePattern = "\\b" + Pattern.quote(fromType) + "(?:<[^>]+>)?\\b";
        Pattern pattern = Pattern.compile(typePattern);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith("import")) {
                newCode.append(line).append(lineSeparator);
            } else {
                String replacedLine = pattern.matcher(line).replaceAll(toType);
                if (!replaced && !replacedLine.equals(line)) {
                    replaced = true;
                }
                newCode.append(replacedLine).append(lineSeparator);
            }
            ++n2;
        }
        if (!replaced) {
            return code;
        }
        if (newCode.length() > 0 && !code.endsWith(lineSeparator)) {
            newCode.setLength(newCode.length() - lineSeparator.length());
        }
        return newCode.toString();
    }
}

