/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service.recipes.ks8to10;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.text.PlainText;

public class AddBDDTestListener
extends ScanningRecipe<AtomicBoolean> {
    private static final String TEST_LISTENER_FILE_PATH_IF_NON_EXIST = "Test Listeners/BddTestListener.groovy";
    private static final String TEST_LISTENER_FOLDER_PATH = "Test Listeners";

    public String getDisplayName() {
        return "Append Cucumber glue for @BeforeTestCase or create BddTestListener class";
    }

    public String getDescription() {
        return "Appends glue call to @BeforeTestCase methods, or creates a new BddTestListener class if none exist.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(false);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean foundBeforeTestCase) {
        return new GroovyVisitor<ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return AddBDDTestListener.hasCucumberFiles(ctx);
            }

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                boolean isTestListener = cu.getSourcePath().toString().startsWith(AddBDDTestListener.TEST_LISTENER_FOLDER_PATH);
                if (!isTestListener) {
                    return cu;
                }
                return (G.CompilationUnit)super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = (J.MethodDeclaration)super.visitMethodDeclaration(method, (Object)ctx);
                if (this.hasBeforeTestCaseAnnotation(m)) {
                    foundBeforeTestCase.set(true);
                }
                return m;
            }

            private boolean hasBeforeTestCaseAnnotation(J.MethodDeclaration m) {
                if (m.getLeadingAnnotations() == null) {
                    return false;
                }
                for (J.Annotation a : m.getLeadingAnnotations()) {
                    String annText = a.getAnnotationType().printTrimmed(this.getCursor());
                    if (annText == null || !annText.equals("BeforeTestCase") && !annText.endsWith(".BeforeTestCase")) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean foundBeforeTestCase) {
        if (foundBeforeTestCase.get()) {
            return new GroovyVisitor<ExecutionContext>(){
                private final JavaTemplate appendTemplate = JavaTemplate.builder((String)"CucumberGlueGenerator.addDefaultPackages()").build();

                public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                    return AddBDDTestListener.hasCucumberFiles(ctx);
                }

                public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                    J.MethodDeclaration m = (J.MethodDeclaration)super.visitMethodDeclaration(method, (Object)ctx);
                    if (this.hasBeforeTestCaseAnnotation(m)) {
                        if (m.getBody() == null) {
                            return m;
                        }
                        if (this.containsGlueCall(m.getBody().getStatements())) {
                            return m;
                        }
                        this.doAfterVisit((TreeVisitor)new AddImport("com.kms.katalon.core.cucumber.keyword.internal.CucumberGlueGenerator", null, false));
                        this.appendTemplate.apply(this.getCursor(), m.getBody().getCoordinates().lastStatement(), new Object[0]);
                    }
                    return m;
                }

                private boolean hasBeforeTestCaseAnnotation(J.MethodDeclaration m) {
                    if (m.getLeadingAnnotations() == null) {
                        return false;
                    }
                    for (J.Annotation a : m.getLeadingAnnotations()) {
                        String annText = a.getAnnotationType().printTrimmed(this.getCursor());
                        if (annText == null || !annText.equals("BeforeTestCase") && !annText.endsWith(".BeforeTestCase")) continue;
                        return true;
                    }
                    return false;
                }

                private boolean containsGlueCall(List<? extends J> statements) {
                    for (J j : statements) {
                        J.MethodInvocation mi;
                        String sel;
                        if (j instanceof J.MethodInvocation && (sel = String.valueOf((mi = (J.MethodInvocation)j).getSelect())) != null && sel.contains("CucumberGlueGenerator") && mi.getSimpleName().equals("addDefaultPackages")) {
                            return true;
                        }
                        if (!(j instanceof J.Block) || !this.containsGlueCall(((J.Block)j).getStatements())) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return new GroovyVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                return cu;
            }
        };
    }

    public List<? extends SourceFile> generate(AtomicBoolean foundBeforeTestCase, ExecutionContext ctx) {
        if (!AddBDDTestListener.hasCucumberFiles(ctx)) {
            return List.of();
        }
        if (foundBeforeTestCase.get()) {
            return List.of();
        }
        String code = "import com.kms.katalon.core.annotation.BeforeTestCase\nimport com.kms.katalon.core.cucumber.keyword.internal.CucumberGlueGenerator\n\nclass BddTestListener {\n    @BeforeTestCase\n    def setup() {\n        CucumberGlueGenerator.addDefaultPackages()\n    }\n}\n";
        return List.of(PlainText.builder().text(code).sourcePath(Path.of(TEST_LISTENER_FILE_PATH_IF_NON_EXIST, new String[0])).build());
    }

    private static boolean hasCucumberFiles(ExecutionContext ctx) {
        return Boolean.TRUE.equals(ctx.getMessage("PROJECT_HAS_CUCUMBER_FILES"));
    }
}

