/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service.recipes.ks9to10;

import java.util.HashMap;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class RemoveSmartWaitWebDriver
extends Recipe {
    public String getDisplayName() {
        return "Remove SmartWaitWebDriver";
    }

    public String getDescription() {
        return "Replaces SmartWaitWebDriver with standard WebDriver";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){
            private final Map<String, String> smartWaitDriverToStandardDriver = new HashMap<String, String>();

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
                if (vd.getTypeExpression() != null && vd.getTypeExpression().toString().contains("SmartWaitWebDriver") && vd.getVariables().size() == 1) {
                    J.NewClass newClass;
                    J.VariableDeclarations.NamedVariable var = (J.VariableDeclarations.NamedVariable)vd.getVariables().get(0);
                    String smartWaitVarName = var.getSimpleName();
                    Expression expression = var.getInitializer();
                    if (expression instanceof J.NewClass && (newClass = (J.NewClass)expression).getArguments() != null && !newClass.getArguments().isEmpty()) {
                        String standardDriverVarName = ((Expression)newClass.getArguments().get(0)).toString();
                        this.smartWaitDriverToStandardDriver.put(smartWaitVarName, standardDriverVarName);
                    }
                    return null;
                }
                return (J.VariableDeclarations)super.visitVariableDeclarations(vd, (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.Identifier select;
                String smartWaitVarName;
                Expression expression = method.getSelect();
                if (expression instanceof J.Identifier && this.smartWaitDriverToStandardDriver.containsKey(smartWaitVarName = (select = (J.Identifier)expression).getSimpleName())) {
                    return method.withSelect((Expression)select.withSimpleName(this.smartWaitDriverToStandardDriver.get(smartWaitVarName)));
                }
                return (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
            }

            public J.Import visitImport(J.Import import_, ExecutionContext ctx) {
                if (import_.getTypeName().equals("com.kms.katalon.core.webui.driver.SmartWaitWebDriver")) {
                    return null;
                }
                return (J.Import)super.visitImport(import_, (Object)ctx);
            }
        };
    }
}

