/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service.recipes.ks9to10;

import com.kms.katalon.migration.model.AppiumConstants;
import com.kms.katalon.migration.service.AstRecipeHelper;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeTree;

public class ReplaceGenericAppiumDriver
extends Recipe {
    public String getDisplayName() {
        return "Migrate to AppiumDriver";
    }

    public String getDescription() {
        return "Replaces AndroidDriver<?>, iOSDriver<?>, and AppiumDriver<?> with AppiumDriver.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){

            public J visitParameterizedType(J.ParameterizedType parameterizedType, ExecutionContext ctx) {
                J.ParameterizedType paramType;
                J.Identifier noGenericAppiumDriver;
                J p = super.visitParameterizedType(parameterizedType, (Object)ctx);
                if (p instanceof J.ParameterizedType && (noGenericAppiumDriver = this.removeParameterizedTypeOfDriver(paramType = (J.ParameterizedType)p)) != null) {
                    this.doAfterVisit((TreeVisitor)new AddImport("io.appium.java_client.AppiumDriver", null, false));
                    return noGenericAppiumDriver;
                }
                return p;
            }

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                G.CompilationUnit visitedCu = (G.CompilationUnit)super.visitCompilationUnit(cu, (Object)ctx);
                Set<String> importsToRemove = Set.of("io.appium.java_client.MobileDriver");
                return AstRecipeHelper.updateImports(visitedCu, Set.of(), importsToRemove);
            }

            public J visitVariableDeclarations(J.VariableDeclarations multiVar, ExecutionContext ctx) {
                J.Identifier typeId;
                J.VariableDeclarations v = (J.VariableDeclarations)super.visitVariableDeclarations(multiVar, (Object)ctx);
                TypeTree typeTree = v.getTypeExpression();
                if (typeTree instanceof J.Identifier && "MobileDriver".equals((typeId = (J.Identifier)typeTree).getSimpleName())) {
                    J.Identifier newType = typeId.withSimpleName("AppiumDriver");
                    v = v.withTypeExpression((TypeTree)newType);
                    this.doAfterVisit((TreeVisitor)new AddImport("io.appium.java_client.AppiumDriver", null, false));
                    this.doAfterVisit((TreeVisitor)new RemoveImport("io.appium.java_client.MobileDriver"));
                }
                return v;
            }

            public J visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
                J.Identifier typeId;
                J.TypeCast tc = (J.TypeCast)super.visitTypeCast(typeCast, (Object)ctx);
                J.ControlParentheses typeInParens = tc.getClazz();
                TypeTree typeTree = (TypeTree)typeInParens.getTree();
                if (typeTree instanceof J.Identifier && "MobileDriver".equals((typeId = (J.Identifier)typeTree).getSimpleName())) {
                    J.Identifier newType = typeId.withSimpleName("AppiumDriver");
                    tc = tc.withClazz(typeInParens.withTree((J)newType));
                    this.doAfterVisit((TreeVisitor)new AddImport("io.appium.java_client.AppiumDriver", null, false));
                    this.doAfterVisit((TreeVisitor)new RemoveImport("io.appium.java_client.MobileDriver"));
                }
                return tc;
            }

            private J.Identifier removeParameterizedTypeOfDriver(J.ParameterizedType paramType) {
                J.Identifier clazz;
                NameTree nameTree = paramType.getClazz();
                if (nameTree instanceof J.Identifier && AppiumConstants.APPIUM_DRIVER_CLASS_SIMPLE_NAMES.contains((clazz = (J.Identifier)nameTree).getSimpleName())) {
                    return clazz.withSimpleName("AppiumDriver").withPrefix(paramType.getPrefix());
                }
                return null;
            }
        };
    }
}

