/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.helper;

import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.helper.KeywordHelper;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.helper.MobileCommonHelper;
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory;
import com.kms.katalon.core.mobile.keyword.internal.MobileSearchEngine;
import com.kms.katalon.core.mobile.keyword.internal.SelectorBuilderHelper;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testobject.TestObject;
import io.appium.java_client.AppiumBy;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class MobileElementCommonHelper {
    private static final KeywordLogger logger = KeywordLogger.getInstance(MobileElementCommonHelper.class);
    private static final int ANDROID_SEEKBAR_PADDING = 56;
    private static final float MOVE_SEEKBAR_MAX_DIFF_IN_PERCENTAGE = 0.01f;
    private static final int MOVE_SEEKBAR_MAX_RETRY = 2;
    private static final int DEFAULT_DRAG_AND_DROP_DELAY = 2000;
    public static final int DEFAULT_TAP_DURATION = 50;
    private static final String IOS_CHECKED_ATTRIBUTE_IS_CHECKED = "1";
    private static final String IOS_CHECKED_ATTRIBUTE = "value";
    private static final String ANDROID_CHECKED_ATTRIBUTE = "checked";

    public static WebElement findElement(TestObject to, int timeOut) throws Exception {
        Date startTime = new Date();
        long span = 0L;
        WebElement webElement = null;
        Point elementLocation = null;
        AppiumDriver driver = MobileDriverFactory.getDriver();
        MobileSearchEngine searchEngine = new MobileSearchEngine(driver, to);
        Dimension screenSize = driver.manage().window().getSize();
        while (span < (long)timeOut) {
            webElement = searchEngine.findWebElement(false);
            if (webElement != null) {
                elementLocation = webElement.getLocation();
                if (elementLocation.y < screenSize.height) break;
                try {
                    Point start = new Point(screenSize.width / 2, screenSize.height / 2);
                    Point end = new Point(screenSize.width / 2, (int)((double)(screenSize.height / 2) * 0.5));
                    MobileCommonHelper.swipe(driver, start, end);
                }
                catch (Exception e) {
                    logger.logError("Exception while findElement | TestObject = %s | timeOut = %s".formatted(to, timeOut), null, (Throwable)e);
                }
            }
            Date endTime = new Date();
            span = endTime.getTime() - startTime.getTime();
        }
        return webElement;
    }

    public static void tapAndHold(TestObject to, Number duration, int timeout) throws Exception {
        WebElement element = MobileElementCommonHelper.findElementWithCheck(to, timeout);
        Point location = element.getLocation();
        Dimension size = element.getSize();
        Point tapPoint = new Point(location.x + size.width / 2, location.y + size.height / 2);
        MobileCommonHelper.touchAndHold(MobileDriverFactory.getDriver(), tapPoint, Duration.ofSeconds(duration.longValue()));
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_TAP_AND_HOLD_ON_ELEMENT_X_WITH_DURATION_Y, to.getObjectId(), MobileElementCommonHelper.getStringForDuration(duration)));
    }

    public static boolean checkDuration(Number duration) {
        boolean useCustomDuration = true;
        logger.logDebug(StringConstants.COMM_LOG_INFO_CHECKING_DURATION);
        if (MobileElementCommonHelper.isDurationInvalid(duration)) {
            logger.logWarning(MessageFormat.format(StringConstants.COMM_LOG_WARNING_INVALID_DURATION, duration));
            useCustomDuration = false;
        }
        return useCustomDuration;
    }

    private static boolean isDurationInvalid(Number duration) {
        return duration == null || duration.floatValue() <= 0.0f;
    }

    public static void tapAndHold(Number x, Number y, Number duration) throws StepFailedException, Exception {
        MobileCommonHelper.checkXAndY(x, y);
        MobileCommonHelper.touchAndHold(MobileDriverFactory.getDriver(), new Point(x.intValue(), y.intValue()), Duration.ofSeconds(duration.longValue()));
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_TAP_AND_HOLD_AT_X_Y_WITH_DURATION_Z, x, y, MobileElementCommonHelper.getStringForDuration(duration)));
    }

    public static String getStringForDuration(Number duration) {
        return MobileElementCommonHelper.isDurationInvalid(duration) ? "(default)" : duration.toString();
    }

    public static WebElement findElementWithCheck(TestObject to, int timeout) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        timeout = MobileCommonHelper.checkTimeout(timeout);
        WebElement element = MobileElementCommonHelper.findElement(to, timeout);
        if (element == null) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()));
        }
        return element;
    }

    public static void checkElement(TestObject to, int timeout) throws StepFailedException, Exception {
        WebElement element = MobileElementCommonHelper.findElementWithCheck(to, timeout);
        if (!MobileElementCommonHelper.isElementChecked(element)) {
            Point location = element.getLocation();
            Dimension size = element.getSize();
            Point tapPoint = new Point(location.x + size.width / 2, location.y + size.height / 2);
            MobileCommonHelper.tap(MobileDriverFactory.getDriver(), tapPoint);
        }
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_CHECK_ELEMENT, to.getObjectId()));
    }

    public static boolean isElementChecked(WebElement element) {
        if (MobileDriverFactory.getDriver() instanceof AndroidDriver) {
            String checkedAttribute = element.getAttribute(ANDROID_CHECKED_ATTRIBUTE);
            return checkedAttribute != null && Boolean.valueOf(checkedAttribute) != false;
        }
        if (MobileDriverFactory.getDriver() instanceof IOSDriver) {
            String checkedAttribute = element.getAttribute(IOS_CHECKED_ATTRIBUTE);
            return checkedAttribute != null && IOS_CHECKED_ATTRIBUTE_IS_CHECKED.equals(checkedAttribute);
        }
        return false;
    }

    public static void uncheckElement(TestObject to, int timeout) throws StepFailedException, Exception {
        WebElement element = MobileElementCommonHelper.findElementWithCheck(to, timeout);
        if (MobileElementCommonHelper.isElementChecked(element)) {
            Point location = element.getLocation();
            Dimension size = element.getSize();
            Point tapPoint = new Point(location.x + size.width / 2, location.y + size.height / 2);
            MobileCommonHelper.tap(MobileDriverFactory.getDriver(), tapPoint);
        }
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_UNCHECK_ELEMENT, to.getObjectId()));
    }

    public static void selectItemByIndex(TestObject to, int index, int timeout, FailureHandling flowControl) throws Exception {
        MobileElementCommonHelper.findElementWithCheck(to, timeout);
        AppiumDriver driver = MobileDriverFactory.getDriver();
        String xpath = SelectorBuilderHelper.makeXpath(to.getActiveProperties());
        List items = driver.findElements(AppiumBy.xpath((String)(xpath + "/*")));
        if (items.size() < index) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_LOG_FAILED_LIST_ITEM_INDEX_EXCEED, index, items.size()));
        }
        if (driver instanceof IOSDriver) {
            WebElement itemElement = driver.findElement(AppiumBy.xpath((String)(xpath + "/*[" + index + "]")));
            HashMap<String, String> scrollObject = new HashMap<String, String>();
            scrollObject.put("direction", "down");
            scrollObject.put("name", itemElement.getAccessibleName());
            driver.executeScript("mobile: scrollTo", new Object[]{scrollObject});
            MobileCommonHelper.tap(driver, itemElement.getLocation());
        } else if (driver instanceof AndroidDriver) {
            throw new StepFailedException(StringConstants.KW_LOG_FAILED_FEATURE_NOT_AVAILABLE_ON_ANDROID);
        }
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_LIST_ITEM_CLICKED, index, to.getObjectId()));
    }

    public static boolean isElementChecked(TestObject to, int timeout) throws StepFailedException, Exception {
        return MobileElementCommonHelper.isElementChecked(MobileElementCommonHelper.findElementWithCheck(to, timeout));
    }

    public static void dragAndDrop(TestObject fromObj, TestObject toObj, int timeout) throws StepFailedException, Exception {
        WebElement fromElement = MobileElementCommonHelper.findElement(fromObj, timeout);
        WebElement toElement = MobileElementCommonHelper.findElement(toObj, timeout);
        AppiumDriver driver = MobileDriverFactory.getDriver();
        Point fromElementLocation = fromElement.getLocation();
        Dimension fromElementSize = fromElement.getSize();
        Point fromPoint = new Point(fromElementLocation.x + fromElementSize.width / 2, fromElementLocation.y + fromElementSize.height / 2);
        Point toElementLocation = toElement.getLocation();
        Dimension toElementSize = toElement.getSize();
        Point toPoint = new Point(toElementLocation.x + toElementSize.width / 2, toElementLocation.y + toElementSize.height / 2);
        MobileCommonHelper.holdAndSwipe(driver, fromPoint, toPoint, Duration.ofMillis(2000L));
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_DRAG_AND_DROP_ELEMENT_X_TO_ELEMENT_Y, fromObj.getObjectId()));
    }

    public static void selectListItemByLabel(TestObject to, String label, int timeout, FailureHandling flowControl) throws Exception {
        WebElement element = MobileElementCommonHelper.findElementWithCheck(to, timeout);
        if (element == null) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()));
        }
        AppiumDriver driver = MobileDriverFactory.getDriver();
        String xpath = SelectorBuilderHelper.makeXpath(to.getActiveProperties());
        MobileElementCommonHelper.scrollToFindElementWithText(driver, (RemoteWebElement)element, label);
        String itemXpath = driver instanceof IOSDriver ? xpath + "//*[@label='" + label + "' or @value='" + label + "']" : xpath + "//*[@text='" + label + "']";
        List itemElements = driver.findElements(AppiumBy.xpath((String)itemXpath));
        if (itemElements.size() <= 0) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_LOG_FAILED_LABELED_ITEM_NOT_FOUND, label, to.getObjectId()));
        }
        WebElement itemElement = (WebElement)itemElements.get(0);
        Point location = itemElement.getLocation();
        Dimension size = itemElement.getSize();
        Point clickPoint = new Point(location.x + size.width / 2, location.y + size.height / 2);
        MobileCommonHelper.tap(driver, clickPoint);
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_LIST_LABELED_ITEM_CLICKED, label, to.getObjectId()));
    }

    private static void scrollToFindElementWithText(AppiumDriver driver, RemoteWebElement element, String text) {
        try {
            HashMap<String, String> scrollObject = new HashMap<String, String>();
            scrollObject = new HashMap();
            scrollObject.put("direction", "down");
            scrollObject.put("element", element.getId());
            scrollObject.put("text", text);
            driver.executeScript("mobile: scrollTo", new Object[]{scrollObject});
        }
        catch (WebDriverException webDriverException) {}
    }

    public static void moveSlider(TestObject to, Number percent, int timeout) throws StepFailedException, Exception {
        logger.logDebug(StringConstants.COMM_LOG_INFO_CHECKING_PERCENTAGE);
        if (percent == null || percent.floatValue() < 0.0f || percent.floatValue() > 100.0f) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_MSG_FAILED_SET_SLIDER_INVALID_PERCENTAGE_X, percent));
        }
        AppiumDriver driver = MobileDriverFactory.getDriver();
        WebElement element = MobileElementCommonHelper.findElementWithCheck(to, timeout);
        float percentValue = percent.floatValue() / 100.0f;
        if (driver instanceof AndroidDriver) {
            MobileElementCommonHelper.moveAndroidSeekbar(percentValue, 56, element, to, driver, timeout, 2);
        } else if (driver instanceof IOSDriver) {
            MobileElementCommonHelper.moveIosUIASlider(percentValue, element);
        }
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_SET_SLIDER_X_TO_Y, to.getObjectId(), percent));
    }

    private static void moveIosUIASlider(float percentValue, WebElement element) {
        element.sendKeys(new CharSequence[]{String.valueOf(percentValue)});
    }

    private static void moveAndroidSeekbar(float percentValue, int seekbarPadding, WebElement element, TestObject testObject, AppiumDriver driver, int timeout, int numRetry) throws Exception {
        int startX = element.getLocation().getX();
        int width = element.getSize().getWidth() - seekbarPadding * 2;
        int relativeX = Math.round((float)width * percentValue);
        Point location = new Point(startX + seekbarPadding + relativeX, element.getLocation().getY());
        MobileCommonHelper.tap(driver, location);
        if (numRetry <= 0) {
            return;
        }
        element = MobileElementCommonHelper.findElementWithCheck(testObject, timeout);
        String value = element.getAttribute("text");
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        float diffInPercentage = Float.parseFloat(value) - percentValue * 100.0f;
        if (Math.abs(diffInPercentage) < 0.01f) {
            return;
        }
        int correctPadding = seekbarPadding + (int)((float)(width * width) * diffInPercentage / 100.0f / ((float)(2 * relativeX) + (float)(2 * width) * diffInPercentage / 100.0f - (float)width));
        MobileElementCommonHelper.moveAndroidSeekbar(percentValue, correctPadding, element, testObject, driver, timeout, numRetry - 1);
    }

    public static int getElementLeftPosition(TestObject to, int timeout, FailureHandling flowControl) throws Exception {
        WebElement element = MobileElementCommonHelper.findElementWithCheck(to, timeout);
        Point location = element.getLocation();
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_OBJ_HAS_LEFT_POSITION, to.getObjectId(), location.getX()));
        return location.getX();
    }

    public static int getElementTopPosition(TestObject to, int timeout, FailureHandling flowControl) throws Exception {
        WebElement element = MobileElementCommonHelper.findElementWithCheck(to, timeout);
        Point location = element.getLocation();
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_OBJ_HAS_TOP_POSITION, to.getObjectId(), location.getY()));
        return location.getY();
    }

    public static void tapAtPosition(Number x, Number y) {
        MobileCommonHelper.checkXAndY(x, y);
        MobileCommonHelper.tap(MobileDriverFactory.getDriver(), new Point(x.intValue(), y.intValue()));
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_TAPPED_AT_X_Y, x, y));
    }

    public static int getElementWidth(TestObject to, int timeout) throws Exception {
        WebElement element = MobileElementCommonHelper.findElementWithCheck(to, timeout);
        int width = element.getSize().getWidth();
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_OBJ_HAS_WIDTH, to.getObjectId(), width));
        return width;
    }

    public static int getElementHeight(TestObject to, int timeout) throws Exception {
        WebElement element = MobileElementCommonHelper.findElementWithCheck(to, timeout);
        int height = element.getSize().getHeight();
        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_OBJ_HAS_HEIGHT, to.getObjectId(), height));
        return height;
    }
}

