/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.keyword.internal;

import com.kms.katalon.core.annotation.internal.Action;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.keyword.IKeywordManager;
import com.kms.katalon.core.keyword.internal.IKeyword;
import com.kms.katalon.core.keyword.internal.IKeywordLoader;
import com.kms.katalon.core.keyword.internal.KeywordExecutionContext;
import com.kms.katalon.core.keyword.internal.KeywordManager;
import com.kms.katalon.core.util.internal.KeywordLoader;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class KeywordExecutor
implements GroovyObject {
    public static final String PLATFORM_WEB = "web";
    public static final String PLATFORM_MOBILE = "mobile";
    public static final String PLATFORM_WEB_SERVICE = "webservice";
    public static final String PLATFORM_WINDOWS = "windows";
    public static final String PLATFORM_BUILT_IN = "builtin";
    public static final String WEB_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.webui.keyword.builtin";
    public static final String MOBILE_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.mobile.keyword.builtin";
    public static final String WEB_SERVICE_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.webservice.keyword.builtin";
    public static final String WINDOWS_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.windows.keyword.builtin";
    public static final String CORE_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.keyword.builtin";
    private final IKeywordLoader keywordLoader;
    private final IKeywordManager keywordManager;
    private final Map<String, Map<String, List<IKeyword>>> cachePlatforms;
    private static final Map<String, KeywordExecutor> EXECUTORS;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private KeywordExecutor(String keywordPlatform) {
        MetaClass metaClass;
        HashMap<String, Map<String, List<IKeyword>>> hashMap = new HashMap<String, Map<String, List<IKeyword>>>();
        this.cachePlatforms = hashMap;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        KeywordLoader keywordLoader = new KeywordLoader(keywordPlatform);
        this.keywordLoader = keywordLoader;
        KeywordManager keywordManager = new KeywordManager();
        this.keywordManager = keywordManager;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeywordExecutor getInstance(String keywordPlatform) {
        Map<String, KeywordExecutor> map = EXECUTORS;
        synchronized (map) {
            String key = keywordPlatform;
            KeywordExecutor executor = (KeywordExecutor)ScriptBytecodeAdapter.castToType((Object)EXECUTORS.get(key), KeywordExecutor.class);
            if (!(executor == null)) return executor;
            executor = new KeywordExecutor(keywordPlatform);
            EXECUTORS.put(key, executor);
            return executor;
        }
    }

    public IKeywordManager getKeywordManager() {
        return this.keywordManager;
    }

    public void setCurrentKeywordTimeout(long timeoutInMillis) {
        this.keywordManager.setTimeout(timeoutInMillis);
    }

    public long getRemainingKeywordTimeoutInMillis() {
        return this.keywordManager.getRemainingTimeoutInMillis();
    }

    public Object executeKeywordForPlatform(String platform, String keyword, Object ... params) {
        this.keywordManager.setCurrentKeywordContext(platform, keyword);
        Object[] actions = this.getActions(platform, keyword, this.getSuitablePackage(platform));
        if (actions.length < 1) {
            throw (Throwable)new StepFailedException(MessageFormat.format(StringConstants.KEYWORD_X_DOES_NOT_EXIST_ON_PLATFORM_Y, keyword, platform));
        }
        KeywordExecutionContext.saveRunningKeywordAndPlatform(platform, keyword);
        KeywordExecutionContext.markKeywordsUsage(platform);
        KeywordExecutionContext.addExecutedKeyword(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)KeywordExecutor.getPlatformAlias(platform), (CharSequence)"."), (CharSequence)keyword));
        int actionDelayInMillis = RunConfiguration.getActionDelayInMillisForKeyword(platform, keyword);
        if (actionDelayInMillis > 0) {
            try {
                Thread.sleep(actionDelayInMillis);
            }
            catch (Exception e) {
            }
        }
        return ((IKeyword)BytecodeInterface8.objectArrayGet((Object[])actions, (int)0)).execute(params);
    }

    private String[] getSuitablePackage(String platform) {
        String string = platform;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_WEB)) {
            return new String[]{WEB_BUILT_IN_KEYWORD_PACKAGE};
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_MOBILE)) {
            return new String[]{MOBILE_BUILT_IN_KEYWORD_PACKAGE};
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_WEB_SERVICE)) {
            return new String[]{WEB_SERVICE_BUILT_IN_KEYWORD_PACKAGE};
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_WINDOWS)) {
            return new String[]{WINDOWS_BUILT_IN_KEYWORD_PACKAGE};
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_BUILT_IN)) {
            return new String[]{CORE_BUILT_IN_KEYWORD_PACKAGE};
        }
        return new String[0];
    }

    private IKeyword[] getActions(String platform, String keyword, String ... searchPackages) {
        if (this.cachePlatforms.containsKey(platform)) {
            Map<String, List<IKeyword>> cacheActions = this.cachePlatforms.get(platform);
            if (cacheActions.containsKey(keyword)) {
                return (IKeyword[])ScriptBytecodeAdapter.asType(cacheActions.get(keyword), IKeyword[].class);
            }
        }
        if (searchPackages == null || searchPackages.length == 0) {
            return new IKeyword[0];
        }
        ArrayList<IKeyword> actions = new ArrayList<IKeyword>();
        List<Class<?>> classes = this.keywordLoader.loadAllClass(searchPackages);
        List<Class<?>> list = classes;
        Iterator<Class<?>> iterator = list != null ? list.iterator() : null;
        Class cls = null;
        Iterator<Class<?>> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                cls = ShortTypeHandling.castToClass(iterator2.next());
                if (!IKeyword.class.isAssignableFrom(cls)) continue;
                Action act = cls.getAnnotation(Action.class);
                if (act == null || !act.value().equalsIgnoreCase(keyword)) continue;
                try {
                    actions.add((IKeyword)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.newInstance((Class)cls), IKeyword.class));
                }
                catch (Exception ex) {
                    throw (Throwable)new StepFailedException(MessageFormat.format(StringConstants.KEYWORD_EXECUTOR_ERROR_MSG, ex.getMessage()));
                }
            }
        }
        HashMap<String, ArrayList<IKeyword>> cacheActions = this.cachePlatforms.containsKey(platform) ? this.cachePlatforms.get(platform) : new HashMap<String, ArrayList<IKeyword>>();
        cacheActions.put(keyword, actions);
        this.cachePlatforms.put(platform, cacheActions);
        return (IKeyword[])ScriptBytecodeAdapter.asType(actions, IKeyword[].class);
    }

    private static String getPlatformAlias(String platform) {
        String string = platform;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_WEB)) {
            return "WebUI";
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_MOBILE)) {
            return "Mobile";
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_WINDOWS)) {
            return "Windows";
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_WEB_SERVICE)) {
            return "WS";
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_BUILT_IN)) {
            return "BuiltIn";
        }
        return platform;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != KeywordExecutor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        HashMap<String, KeywordExecutor> hashMap = new HashMap<String, KeywordExecutor>();
        EXECUTORS = hashMap;
    }
}

