/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;

public class ResourceUtil {
    public static InputStream getResourceAsInputStream(Class<?> clazz, String filePath) throws IOException {
        String projectPath = clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
        File jarFile = new File(projectPath = URLDecoder.decode(projectPath, "utf-8"));
        if (jarFile.isDirectory()) {
            return new FileInputStream(new File(jarFile, filePath).getAbsolutePath());
        }
        return clazz.getClassLoader().getResourceAsStream(filePath);
    }

    public static File[] getFiles(Class<?> clazz, String filePath, File tempFolder, boolean ignoreExtractIfExisted) throws IOException, URISyntaxException {
        String projectPath = clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
        File bundleJarFile = new File(projectPath = URLDecoder.decode(projectPath, "utf-8"));
        if (bundleJarFile.isDirectory()) {
            FileUtils.copyDirectory((File)new File(bundleJarFile, filePath), (File)tempFolder);
            return tempFolder.listFiles();
        }
        ArrayList<File> classpathFiles = new ArrayList<File>();
        try (JarFile jar = new JarFile(bundleJarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith(filePath + "/") || name.endsWith("/")) continue;
                File tempClasspathEntry = new File(tempFolder, name.replaceFirst(filePath + "/", ""));
                if (!ignoreExtractIfExisted || !tempClasspathEntry.exists()) {
                    ResourceUtil.copySafely(jar.getInputStream(jarEntry), tempClasspathEntry);
                }
                classpathFiles.add(tempClasspathEntry);
            }
            File[] fileArray = classpathFiles.toArray(new File[classpathFiles.size()]);
            return fileArray;
        }
    }

    private static void copySafely(InputStream is, File dest) throws IOException {
        try {
            FileUtils.copyInputStreamToFile((InputStream)is, (File)dest);
        }
        finally {
            if (is != null) {
                ResourceUtil.closeQuietly(is);
            }
        }
    }

    private static void closeQuietly(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {}
    }

    public static String[] getExistedAttachments(String logFolder, String[] attachments) {
        ArrayList<String> existedAttachments = new ArrayList<String>();
        String[] stringArray = attachments;
        int n = attachments.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            if (new File(filePath).exists() || new File(logFolder, filePath).exists()) {
                existedAttachments.add(filePath);
            }
            ++n2;
        }
        return existedAttachments.toArray(new String[0]);
    }
}

