/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject.impl;

import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.UrlEncodedBodyParameter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class HttpUrlEncodedBodyContent
implements HttpBodyContent {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private UrlEncodedFormEntity urlEncodedFormEntity;
    private String charset;

    public HttpUrlEncodedBodyContent(List<UrlEncodedBodyParameter> parameters) throws UnsupportedEncodingException {
        this(parameters, DEFAULT_CHARSET);
    }

    public HttpUrlEncodedBodyContent(List<UrlEncodedBodyParameter> parameters, String charset) throws UnsupportedEncodingException {
        this.charset = charset;
        List<NameValuePair> nameValuePairs = this.toNameValuePairs(parameters);
        this.urlEncodedFormEntity = new UrlEncodedFormEntity(nameValuePairs, charset);
        this.urlEncodedFormEntity.setContentType(DEFAULT_CONTENT_TYPE);
    }

    private List<NameValuePair> toNameValuePairs(List<UrlEncodedBodyParameter> parameters) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        for (UrlEncodedBodyParameter p : parameters) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(p.getName(), p.getValue()));
        }
        return nameValuePairs;
    }

    @Override
    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    @Override
    public long getContentLength() {
        return 0L;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException, UnsupportedOperationException {
        return this.urlEncodedFormEntity.getContent();
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        this.urlEncodedFormEntity.writeTo(outstream);
    }

    public String getCharset() {
        return this.charset;
    }
}

