/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util.internal;

import com.kms.katalon.core.util.internal.DateTimeLanguageBundle;
import java.text.MessageFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class TestOpsTimeFormatter {
    public static final String FORMAT_LAST_YEAR = "MMM dd, yyyy";
    public static final String FORMAT_LAST_MONTH = "MMM dd";
    public static final String FORMAT_OVER_A_DAY = "MMM dd, HH:mm";
    public static final String FORMAT_DATE = "MM/dd/yyyy HH:mm:ss";
    public static final ZoneId DEFAULT_ZONE = ZoneId.of("Z");
    private DateTimeLanguageBundle languageBundle;

    public TestOpsTimeFormatter() {
        this.languageBundle = DateTimeLanguageBundle.DEFAULT;
    }

    public TestOpsTimeFormatter(DateTimeLanguageBundle languageBundle) {
        this.languageBundle = languageBundle == null ? DateTimeLanguageBundle.DEFAULT : languageBundle;
    }

    public String formatDetail(Date dateTime) {
        return this.formatDetail(dateTime, ZoneId.systemDefault());
    }

    public String formatDetail(Date dateTime, ZoneId formatZone) {
        ZoneId zoneId = formatZone == null ? DEFAULT_ZONE : formatZone;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(dateTime.toInstant(), zoneId);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_DATE);
        return formatter.format(zonedDateTime);
    }

    public String formatEvent(Date dateTime, ZoneId formatZone) {
        return this.formatEvent(dateTime, null, formatZone);
    }

    public String formatEvent(Date dateTime) {
        return this.formatEvent(dateTime, null, null);
    }

    public String formatEvent(Date dateTime, Date comparedDate) {
        return this.formatEvent(dateTime, comparedDate, null);
    }

    public String formatEvent(Date dateTime, Date comparedDate, ZoneId zoneId) {
        Objects.requireNonNull(dateTime);
        ZoneId timeZone = zoneId == null ? DEFAULT_ZONE : zoneId;
        ZonedDateTime dateTimeInSystemZone = ZonedDateTime.ofInstant(dateTime.toInstant(), timeZone).withZoneSameInstant(ZoneId.systemDefault());
        ZonedDateTime comparedTimeInSystemZone = comparedDate == null ? ZonedDateTime.now() : ZonedDateTime.ofInstant(comparedDate.toInstant(), timeZone);
        return this.formatEvent(dateTimeInSystemZone, comparedTimeInSystemZone);
    }

    public String formatEvent(ZonedDateTime dateTime, ZonedDateTime comparedDate) {
        if (Math.abs(dateTime.getYear() - comparedDate.getYear()) != 0) {
            return this.formatLastYear(dateTime);
        }
        if (Math.abs(dateTime.getMonthValue() - comparedDate.getMonthValue()) != 0) {
            return this.formatLastMonth(dateTime);
        }
        if (Math.abs(dateTime.getDayOfMonth() - comparedDate.getDayOfMonth()) != 0) {
            return this.formatOverADay(dateTime);
        }
        return this.format(dateTime, comparedDate);
    }

    private String format(ZonedDateTime dateTime, ZonedDateTime now) {
        long timeElapsed = now.toInstant().toEpochMilli() - dateTime.toInstant().toEpochMilli();
        boolean isPast = timeElapsed >= 0L;
        timeElapsed = Math.abs(timeElapsed);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(timeElapsed);
        long minutes = TimeUnit.SECONDS.toMinutes(seconds);
        long hours = TimeUnit.MINUTES.toHours(minutes);
        StringBuilder formatter = new StringBuilder();
        if (isPast) {
            formatter.append(this.languageBundle.getProperty("PROP_PAST_PREFIX"));
        } else {
            formatter.append(this.languageBundle.getProperty("PROP_FUTURE_PREFIX"));
        }
        formatter.append(" ");
        formatter.append(this.formatTime(hours, minutes, seconds, timeElapsed));
        formatter.append(" ");
        if (isPast) {
            formatter.append(this.languageBundle.getProperty("PROP_PAST_SUFFIX"));
        } else {
            formatter.append(this.languageBundle.getProperty("PROP_FUTURE_SUFFIX"));
        }
        return formatter.toString().trim();
    }

    private String formatTime(long hours, long minutes, long seconds, long timeElapsed) {
        if (timeElapsed < 1000L) {
            return this.languageBundle.getProperty("PROP_TINY_TIME");
        }
        if (timeElapsed % 1000L >= 500L) {
            ++seconds;
        }
        if (seconds % 60L >= 30L) {
            ++minutes;
        }
        if (minutes % 60L >= 30L) {
            ++hours;
        }
        if (hours > 0L) {
            String format = hours > 1L ? this.languageBundle.getProperty("PROP_HOURS") : this.languageBundle.getProperty("PROP_HOUR");
            return MessageFormat.format(format, String.valueOf(hours));
        }
        if (minutes > 0L) {
            String format = minutes > 1L ? this.languageBundle.getProperty("PROP_MINUTES") : this.languageBundle.getProperty("PROP_MINUTE");
            return MessageFormat.format(format, String.valueOf(minutes));
        }
        if (seconds > 0L) {
            String format = seconds > 1L ? this.languageBundle.getProperty("PROP_SECONDS") : this.languageBundle.getProperty("PROP_SECOND");
            return MessageFormat.format(format, String.valueOf(seconds));
        }
        throw new UnsupportedOperationException("Unsupported operation for given parameters");
    }

    private String formatLastYear(ZonedDateTime dateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_LAST_YEAR);
        return formatter.format(dateTime);
    }

    private String formatLastMonth(ZonedDateTime dateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_LAST_MONTH);
        return formatter.format(dateTime);
    }

    private String formatOverADay(ZonedDateTime dateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_OVER_A_DAY);
        return formatter.format(dateTime);
    }

    public String formatDuration(long elapsedTime) {
        return this.formatDuration(elapsedTime, false);
    }

    public String formatDuration(long elapsedTime, boolean showZeroValue) {
        boolean isMillisOnly = elapsedTime < 1000L;
        long seconds = elapsedTime / 1000L;
        elapsedTime %= 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        if (!isMillisOnly && elapsedTime >= 500L) {
            ++seconds;
            elapsedTime = 0L;
        }
        if (seconds >= 60L) {
            ++minutes;
            seconds = 0L;
        }
        if (minutes >= 60L) {
            ++hours;
            minutes = 0L;
        }
        if (hours >= 24L) {
            ++days;
            hours = 0L;
        }
        StringBuilder builder = new StringBuilder();
        if (days != 0L || showZeroValue) {
            builder.append(MessageFormat.format(this.languageBundle.getProperty("PROP_DAY_SHORT"), String.valueOf(days)));
        }
        if (hours != 0L || showZeroValue) {
            builder.append(" ");
            builder.append(MessageFormat.format(this.languageBundle.getProperty("PROP_HOUR_SHORT"), String.valueOf(hours)));
        }
        if (minutes != 0L || showZeroValue) {
            builder.append(" ");
            builder.append(MessageFormat.format(this.languageBundle.getProperty("PROP_MINUTE_SHORT"), String.valueOf(minutes)));
        }
        if (hours == 0L && (seconds != 0L || showZeroValue)) {
            builder.append(" ");
            builder.append(MessageFormat.format(this.languageBundle.getProperty("PROP_SECOND_SHORT"), String.valueOf(seconds)));
        }
        if (builder.length() == 0) {
            builder.append(MessageFormat.format(this.languageBundle.getProperty("PROP_MILLI"), String.valueOf(elapsedTime)));
        }
        return builder.toString().trim();
    }
}

