package com.kms.katalon.core.webui.keyword.builtin;

import java.text.MessageFormat

import org.apache.commons.lang3.StringUtils
import org.openqa.selenium.WebDriver

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.util.internal.PathUtil
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain

import groovy.transform.CompileStatic

@Action(value = "navigateToMaskedUrl")
public class NavigateToMaskedUrlKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        String rawUrl = (String) params[0]
        FailureHandling flowControl = (FailureHandling)(params.length > 1 && params[1] instanceof FailureHandling ? params[1] : RunConfiguration.getDefaultFailureHandling())
        navigateToMaskedUrl(rawUrl,flowControl)
    }

    private String getMaskedText(String text) {
        return StringUtils.repeat("*", text.length())
    }

    @CompileStatic
    public void navigateToMaskedUrl(String rawUrl, FailureHandling flowControl) throws StepFailedException {
        WebUIKeywordMain.runKeyword({
            logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_URL)
            if (rawUrl == null || rawUrl.isEmpty()) {
                throw new IllegalArgumentException(StringConstants.KW_EXC_URL_CANNOT_BE_NULL_OR_EMPTY)
            }

            URL url = PathUtil.getUrl(rawUrl, "http")
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_NAVIGATING_TO, getMaskedText(url.toString())))
            WebDriver webDriver = DriverFactory.getWebDriver()
            webDriver.navigate().to(url.toString())
            logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_NAVIGATE_TO, getMaskedText(url.toString())))
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), MessageFormat.format(StringConstants.KW_MSG_CANNOT_NAVIGATE_TO, getMaskedText(rawUrl)))
    }
}
