package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat
import java.util.concurrent.TimeUnit

import org.openqa.selenium.JavascriptExecutor
import org.openqa.selenium.WebDriver
import org.openqa.selenium.WebElement

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain
import com.kms.katalon.core.webui.model.SeleniumActionRetryController.RetryContext

import groovy.transform.CompileStatic

@Action(value = "verifyElementNotChecked")
public class VerifyElementNotCheckedKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        int timeOut = (int) params[1]
        FailureHandling flowControl = (FailureHandling)(params.length > 2 && params[2] instanceof FailureHandling ? params[2] : RunConfiguration.getDefaultFailureHandling())
        return verifyElementNotChecked(to,timeOut,flowControl)
    }

    @CompileStatic
    public boolean verifyElementNotChecked(TestObject to, int timeOut, FailureHandling flowControl)
    throws StepFailedException {
        WebDriver driver = DriverFactory.getWebDriver();
        timeOut = WebUiCommonHelper.checkTimeout(timeOut)
        long timeoutInMillis = TimeUnit.SECONDS.toMillis(timeOut)
        WebUIKeywordMain.runKeywordUntilTimeout({retryContext ->
            boolean isSwitchIntoFrame = false
            try {
                WebUiCommonHelper.checkTestObjectParameter(to)
                isSwitchIntoFrame = WebUiCommonHelper.switchToParentFrame(driver, to, timeOut)
                WebElement webElement = WebUIAbstractKeyword.findWebElement(driver, to, timeoutInMillis)
                logger.logDebug("Checking if element is interactable: " + to.getObjectId());
                if (webElement != null && driver instanceof JavascriptExecutor) {
                    waitElementInteractable((JavascriptExecutor) driver, webElement, timeoutInMillis, (RetryContext) retryContext);
                }
                boolean isChecked = webElement.isSelected()
                if (isChecked) {
                    WebUIKeywordMain.stepFailed(MessageFormat.format(StringConstants.KW_MSG_OBJ_X_IS_CHECKED, to.getObjectId()), flowControl, null, true)
                    return false
                } else {
                    logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_OBJ_X_IS_NOT_CHECKED, to.getObjectId()))
                    return true
                }
            } finally {
                if (isSwitchIntoFrame) {
                    WebUiCommonHelper.switchToDefaultContent(driver)
                }
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), (to != null) ? MessageFormat.format(StringConstants.KW_MSG_CANNOT_VERIFY_OBJ_X_IS_NOT_CHECKED, to.getObjectId())
        : StringConstants.KW_MSG_CANNOT_VERIFY_OBJ_IS_NOT_CHECKED)
    }
}
