package com.kms.katalon.core.keyword;

import com.kms.katalon.core.configuration.RunConfiguration;

public class KeywordContext {

    private String platform;

    private String name;

    long startTime;

    long timeoutInMillis = RunConfiguration.getElementTimeoutForWebInMillis();

    public KeywordContext(String platform, String name, long startTime) {
        super();
        this.platform = platform;
        this.name = name;
        this.startTime = startTime;
    }

    public KeywordContext(String platform, String name) {
        this(platform, name, System.currentTimeMillis());
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getTimeout() {
        return timeoutInMillis;
    }

    public void setTimeout(long timeoutInMillis) {
        this.timeoutInMillis = timeoutInMillis;
    }
}
