package com.kms.katalon.core.mobile.keyword.builtin

import java.text.MessageFormat

import org.apache.commons.io.FileUtils
import org.openqa.selenium.Dimension
import org.openqa.selenium.Point
import org.openqa.selenium.WebElement

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.helper.MobileCommonHelper
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumBy
import io.appium.java_client.AppiumDriver

@Action(value = "tapOnImage")
public class TapOnImageKeyword extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        String imageFilePath = (String) params[0]
        FailureHandling flowControl = (FailureHandling)(params.length > 1 && params[1] instanceof FailureHandling ? params[1] : RunConfiguration.getDefaultFailureHandling())
        tapOnImage(imageFilePath, flowControl)
    }

    @CompileStatic
    public void tapOnImage(String imageFilePath, FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            if (!MobileCommonHelper.canUseImageBasedTesting()) {
                throw new StepFailedException("You are using \"tapOnImage\" keyword which requires a Studio Enterprise license. To unlock advanced features, please upgrade to a Katalon Enterprise license.")
            }
            
            AppiumDriver driver = MobileDriverFactory.getDriver()

            byte[] fileContent = FileUtils.readFileToByteArray(new File(imageFilePath))

            String encodedString = Base64.getEncoder().encodeToString(fileContent)

            List elements = driver.findElements(AppiumBy.image(encodedString))
            logger.logInfo(MessageFormat.format("Found {0} element(s) on screen", elements.size()))
            if (elements.isEmpty()) {
                throw new StepFailedException("No image element found")
            }

            WebElement element = elements.get(0)
            Point location = element.getLocation()
            Dimension size = element.getSize();
            Point tapPoint = new Point((int)(location.x + size.width / 2), (int)(location.y + size.height / 2));

            logger.logInfo(MessageFormat.format("Tap on image at location ({0}, {1})", tapPoint.x, tapPoint.y))
            MobileCommonHelper.tap(driver, tapPoint)

            logger.logPassed(MessageFormat.format("Tap on image ''{0}'' at location ({1}, {2}) successfully", imageFilePath, tapPoint.x, tapPoint.y))
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), "Failed to tap on image")
    }
}
