package com.kms.katalon.core.mobile.keyword.builtin;

import org.apache.commons.lang3.StringUtils

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.CoreMobileMessageConstants
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumDriver
import io.appium.java_client.android.AndroidDriver
import io.appium.java_client.remote.SupportsContextSwitching

@Action(value = "useFingerprint")
public class UseFingerprintKeyword extends MobileAbstractKeyword {
    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        int fingerprintId = (int) params[0]
        FailureHandling flowControl = (FailureHandling)(params.length > 1 && params[1] instanceof FailureHandling ? params[1] : RunConfiguration.getDefaultFailureHandling())
        useFingerprint(fingerprintId, flowControl)
    }

    @CompileStatic
    public void useFingerprint(int fingerprintId, FailureHandling flowControl) throws IllegalArgumentException, StepFailedException {
        MobileKeywordMain.runKeyword({
            AppiumDriver driver = getAnyAppiumDriver()
            if (driver instanceof AndroidDriver) {
                if (fingerprintId < 1 || fingerprintId > 10) {
                    throw new IllegalArgumentException(CoreMobileMessageConstants.KW_MSG_INVALID_FINGERPRINT_VALUE)
                }

                String deviceId = MobileDriverFactory.getDeviceId();
                if (!StringUtils.containsIgnoreCase(deviceId, "emulator")) {
                    logger.logWarning(CoreMobileMessageConstants.KW_MSG_FINGERPRINT_NOT_AVAILABLE_ON_PHYSICAL_MOBILE_DEVICES)
                    return
                }

                AndroidDriver androidDriver = (AndroidDriver) driver

                androidDriver.fingerPrint(fingerprintId)

                logger.logPassed(CoreMobileMessageConstants.KW_MSG_PASSED_USE_FINGERPRINT)
            } else {
                MobileKeywordMain.stepFailed(CoreMobileMessageConstants.KW_MSG_FINGERPRINT_SUPPORTS_ANDROID_APP_ONLY, flowControl, null, true)
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), CoreMobileMessageConstants.KW_MSG_FAILED_USE_FINGERPRINT)
    }
}
