/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.preferences;

import com.kms.katalon.composer.components.dialogs.FieldEditorPreferencePageWithHelp;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.components.util.MessageComponentBuilder;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.webui.recorder.constants.ComposerWebuiRecorderMessageConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetaFeaturePreferencesPage
extends FieldEditorPreferencePageWithHelp {
    private static final Logger LOGGER = LoggerFactory.getLogger(BetaFeaturePreferencesPage.class);
    private final String BADGE_COLOR = "#F3BF4A";
    private final int BADGE_WIDTH = 30;
    private final int BADGE_HEIGHT = 20;
    private final int BADGE_RADIUS = 4;
    private Composite mainComposite;
    private ScopedPreferenceStore betaFeaturePreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.betaFeature");
    private Button btnKatalonWebRecorder;
    private Button btnSmartMobileRecorder;

    protected Control createContents(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 4;
        this.mainComposite.setLayout((Layout)layout);
        this.mainComposite.setLayoutData((Object)new GridData(768));
        MessageComponentBuilder.create().parent(this.mainComposite).message(ComposerWebuiRecorderMessageConstants.PREF_MSG_INFO_BETA_FEATURE).fillHorizontal(true).infoStyle().build();
        Label lblNewBetaFeature = new Label(this.mainComposite, 0);
        lblNewBetaFeature.setText(ComposerWebuiRecorderMessageConstants.PREF_LBL_ENABLE_NEW_BETA_FEATURE);
        GridData lblNewBetaFeatureGridData = new GridData(16384, 0x1000000, false, false);
        lblNewBetaFeatureGridData.verticalIndent = 6;
        lblNewBetaFeature.setLayoutData((Object)lblNewBetaFeatureGridData);
        Composite recorderPlusCheckboxComposite = new Composite(this.mainComposite, 0);
        GridLayout recorderCompositeLayout = new GridLayout(3, false);
        recorderCompositeLayout.marginWidth = 0;
        recorderPlusCheckboxComposite.setLayout((Layout)recorderCompositeLayout);
        this.btnKatalonWebRecorder = new Button(recorderPlusCheckboxComposite, 32);
        this.btnKatalonWebRecorder.setText(ComposerWebuiRecorderMessageConstants.PREF_BTN_KATALON_WEB_RECORDER);
        Canvas plusBadge = new Canvas(recorderPlusCheckboxComposite, 0);
        GridData badgeGridData = new GridData(16384, 0x1000000, false, false);
        badgeGridData.widthHint = 30;
        badgeGridData.heightHint = 20;
        plusBadge.setLayoutData((Object)badgeGridData);
        plusBadge.addPaintListener(e -> {
            int width = 30;
            int height = 20;
            int radius = 4;
            GC gc = e.gc;
            gc.setBackground(ColorUtil.getColor((String)"#F3BF4A"));
            gc.fillRoundRectangle(0, 0, width, height, radius, radius);
            gc.setFont(FontUtil.BOLD);
            gc.setForeground(ColorUtil.BLACK_COLOR);
            String text = ComposerWebuiRecorderMessageConstants.PREF_BADGE_PLUS;
            Point textExtent = gc.textExtent(text);
            int textX = (width - textExtent.x) / 2;
            int textY = (height - textExtent.y) / 2;
            gc.drawText(text, textX, textY, true);
        });
        Label lblHelp = new Label(recorderPlusCheckboxComposite, 0);
        lblHelp.setImage(ImageManager.getImage((String)"help_16.png"));
        GridData lblHelpData = new GridData(16384, 0x1000000, false, false);
        lblHelpData.horizontalIndent = 5;
        lblHelp.setLayoutData((Object)lblHelpData);
        lblHelp.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                Program.launch((String)DocumentationMessageConstants.RECORDER_PLUS_DOCUMENT);
            }
        });
        this.btnSmartMobileRecorder = new Button(recorderPlusCheckboxComposite, 32);
        this.btnSmartMobileRecorder.setText(ComposerWebuiRecorderMessageConstants.PREF_BTN_SMART_MOBILE_RECORDER);
        Label mobileLblHelp = new Label(recorderPlusCheckboxComposite, 0);
        mobileLblHelp.setImage(ImageManager.getImage((String)"help_16.png"));
        GridData mobileLblHelpData = new GridData(16384, 0x1000000, false, false);
        mobileLblHelpData.horizontalIndent = 5;
        mobileLblHelp.setLayoutData((Object)mobileLblHelpData);
        mobileLblHelp.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                Program.launch((String)DocumentationMessageConstants.SMART_MOBILE_RECORDER_DOCUMENT);
            }
        });
        this.initialize();
        return this.mainComposite;
    }

    protected void initialize() {
        super.initialize();
        String recorderPlusOption = this.betaFeaturePreferenceStore.getString("betaFeature.recorderPlusOption");
        boolean isKatalonRecorderChecked = StringUtils.equals((CharSequence)Boolean.TRUE.toString(), (CharSequence)recorderPlusOption);
        this.btnKatalonWebRecorder.setSelection(isKatalonRecorderChecked);
        String smartMobileRecorder = this.betaFeaturePreferenceStore.getString("betaFeature.smartMobileRecorder");
        boolean isSmartMobileRecorderChecked = StringUtils.equals((CharSequence)Boolean.TRUE.toString(), (CharSequence)smartMobileRecorder);
        this.btnSmartMobileRecorder.setSelection(isSmartMobileRecorderChecked);
    }

    protected void performDefaults() {
        super.performDefaults();
        boolean isKatalonRecorderChecked = true;
        this.btnKatalonWebRecorder.setSelection(isKatalonRecorderChecked);
        boolean isSmartMobileRecorderChecked = true;
        this.btnSmartMobileRecorder.setSelection(isSmartMobileRecorderChecked);
    }

    public boolean performOk() {
        if (this.mainComposite == null || this.mainComposite.isDisposed()) {
            return true;
        }
        if (this.btnKatalonWebRecorder.getSelection()) {
            this.betaFeaturePreferenceStore.setValue("betaFeature.recorderPlusOption", Boolean.TRUE.toString());
        } else {
            this.betaFeaturePreferenceStore.setValue("betaFeature.recorderPlusOption", "");
        }
        if (this.btnSmartMobileRecorder.getSelection()) {
            this.betaFeaturePreferenceStore.setValue("betaFeature.smartMobileRecorder", Boolean.TRUE.toString());
        } else {
            this.betaFeaturePreferenceStore.setValue("betaFeature.smartMobileRecorder", "");
        }
        try {
            this.betaFeaturePreferenceStore.save();
            Trackings.trackingBetaFeaturesConfiguration();
        }
        catch (IOException e) {
            LOGGER.error("IOException while performOk", (Throwable)e);
        }
        return super.performOk();
    }

    protected void createFieldEditors() {
    }
}

