/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.composer.dialog;

import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.session.composer.constants.SessionComposerConstansts;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Singleton;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Creatable
@Singleton
public class ProductFeatureDialog
implements IProductFeatureDialog {
    private static IProductFeatureDialog instance;

    public static IProductFeatureDialog getInstance() {
        if (Objects.isNull(instance)) {
            BundleContext bundleContext = FrameworkUtil.getBundle(ProductFeatureDialog.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            instance = (IProductFeatureDialog)ContextInjectionFactory.make(ProductFeatureDialog.class, (IEclipseContext)context);
        }
        return instance;
    }

    public void showNotAvailableFeature(ProductFeature feature) {
        this.showNotAvailableFeature(feature, true);
    }

    public void showNotAvailableFeature(ProductFeature feature, boolean shouldTrack) {
        this.showNotAvailableFeature(feature, "", "", shouldTrack);
    }

    public void showNotAvailableFeature(ProductFeature feature, String dialogTitle, String dialogMessage) {
        this.showNotAvailableFeature(feature, dialogTitle, dialogMessage, true);
    }

    public void showNotAvailableFeature(ProductFeature feature, String dialogTitle, String dialogMessage, boolean shouldTrack) {
        if (shouldTrack) {
            Trackings.trackUnauthorizedAccessOfKSEFeatures((ProductFeature)feature);
        }
        Shell mainShell = Display.getCurrent().getActiveShell();
        ImplDialog trialExpiredDialog = new ImplDialog(mainShell);
        if (StringUtils.isNotBlank((CharSequence)dialogTitle)) {
            trialExpiredDialog.setDialogTitle(dialogTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)dialogMessage)) {
            trialExpiredDialog.setDialogMessage(dialogMessage);
        }
        trialExpiredDialog.create();
        trialExpiredDialog.open();
    }

    private static class ImplDialog
    extends Dialog {
        private final int CONTAINER_MARGIN = 15;
        private String title = SessionComposerConstansts.DIA_KSE_FEATURE_TITLE;
        private String message = SessionComposerConstansts.MSG_KSE_TRIAL_EXPIRED;

        public ImplDialog(Shell parentShell) {
            super(parentShell);
        }

        public String getDialogTitle() {
            return this.title;
        }

        public void setDialogTitle(String title) {
            this.title = title;
        }

        public void setDialogMessage(String message) {
            this.message = message;
        }

        protected Control createDialogArea(Composite parent) {
            Composite body = (Composite)ComponentBuilder.gridContainer((Composite)parent).margin(15).fill().build();
            ComponentBuilder.label((Composite)body).text(this.message).fillHorizontal().build();
            body.pack();
            return body;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1, GlobalMessageConstants.DIA_CLOSE, false);
            this.createButton(parent, 0, SessionComposerConstansts.BTN_SUBSCRIBE, true);
            ComponentUtil.gridFillHorizontal((Control)parent);
            ComponentBuilder.from((Widget)this.getButton(1)).fillHorizontal().left();
            ComponentBuilder.from((Widget)this.getButton(0)).fillHorizontal().right();
        }

        protected void okPressed() {
            ComponentUtil.triggerLink((String)SessionComposerConstansts.URL_PRICING_PAGE);
            super.okPressed();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.getDialogTitle());
        }
    }
}

