/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.controller;

import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.migration.controller.IMigrationController;
import com.kms.katalon.migration.model.MigrationAttempt;
import com.kms.katalon.migration.model.MigrationPlan;
import com.kms.katalon.migration.model.ProgressUpdate;
import com.kms.katalon.migration.service.MigrationPlanManager;
import com.kms.katalon.migration.service.MigrationService;
import java.util.List;
import java.util.function.Consumer;

public class MigrationController
implements IMigrationController {
    MigrationService migrationService = new MigrationService();

    @Override
    public MigrationPlan fetchMigrationPlan(String fromVersion, String toVersion) {
        return new MigrationPlanManager().resolve(fromVersion, toVersion);
    }

    @Override
    public MigrationAttempt initializeMigrationAttempt(ProjectEntity projectEntity, MigrationPlan migrationPlan) {
        MigrationAttempt attempt = new MigrationAttempt(projectEntity, migrationPlan);
        attempt.safelySaveToJsonFile();
        return attempt;
    }

    @Override
    public void dryRun(MigrationAttempt attempt, Consumer<ProgressUpdate> progressCallback) {
        this.migrationService.dryRun(attempt, progressCallback);
    }

    @Override
    public void apply(MigrationAttempt attempt, Consumer<ProgressUpdate> progressCallback) {
        this.migrationService.apply(attempt, progressCallback);
    }

    @Override
    public void revert(MigrationAttempt attempt, Consumer<ProgressUpdate> progressCallback) {
        this.migrationService.revert(attempt, progressCallback);
    }

    @Override
    public void cancel(MigrationAttempt attempt, Consumer<ProgressUpdate> progressCallback) {
        this.migrationService.cancel(attempt, progressCallback);
    }

    @Override
    public List<MigrationAttempt> loadAttemptsHistory(ProjectEntity projectEntity) {
        return MigrationAttempt.loadMigrationAttempts(projectEntity);
    }
}

