/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.dialog;

import com.kms.katalon.migration.model.MigrationAttempt;
import com.kms.katalon.migration.model.MigrationEntry;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.openrewrite.SourceFile;

public class PatchViewer
extends Composite {
    private CompareViewerPane comparePane;
    private TextMergeViewer mergeViewer;
    private org.eclipse.swt.widgets.List migrationEntrySwtList;
    private List<MigrationEntry> entriesWithDiff;

    public PatchViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createCompareUI(this);
    }

    private void createCompareUI(Composite parent) {
        ScrolledComposite scrolledLeft = new ScrolledComposite((Composite)this, 768);
        scrolledLeft.setLayoutData((Object)new GridData(4, 4, false, true));
        int parentWidth = 1200;
        scrolledLeft.setMinWidth(parentWidth / 4);
        Composite leftComposite = new Composite((Composite)scrolledLeft, 0);
        leftComposite.setLayout((Layout)new GridLayout(1, false));
        Label listHeader = new Label(leftComposite, 0);
        listHeader.setText("Changed files");
        listHeader.setLayoutData((Object)new GridData(4, 128, true, false));
        this.migrationEntrySwtList = new org.eclipse.swt.widgets.List(leftComposite, 2816);
        this.migrationEntrySwtList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.migrationEntrySwtList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int idx = PatchViewer.this.migrationEntrySwtList.getSelectionIndex();
                if (idx >= 0 && idx < PatchViewer.this.entriesWithDiff.size()) {
                    PatchViewer.this.display(PatchViewer.this.entriesWithDiff.get(idx));
                }
            }
        });
        scrolledLeft.setContent((Control)leftComposite);
        scrolledLeft.setExpandHorizontal(true);
        scrolledLeft.setExpandVertical(true);
        leftComposite.setSize(leftComposite.computeSize(-1, -1));
        this.comparePane = new CompareViewerPane((Composite)this, 0x800800);
        this.mergeViewer = new TextMergeViewer((Composite)this.comparePane, 0, new CompareConfiguration());
        this.mergeViewer.getControl().setFont(JFaceResources.getTextFont());
        this.comparePane.setContent(this.mergeViewer.getControl());
        this.comparePane.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public void setMigrationAttempt(MigrationAttempt migrationAttempt) {
        this.migrationEntrySwtList.removeAll();
        this.entriesWithDiff = migrationAttempt.getEntries().stream().filter(entry -> entry.getDiffContent() != null && !entry.getDiffContent().isEmpty()).toList();
        Path projectDir = Path.of(migrationAttempt.getProjectRootPath(), new String[0]);
        for (MigrationEntry entry2 : this.entriesWithDiff) {
            this.migrationEntrySwtList.add(projectDir.relativize(entry2.getFilePath()).toString());
        }
        if (!this.entriesWithDiff.isEmpty()) {
            this.migrationEntrySwtList.select(0);
            this.display(this.entriesWithDiff.get(0));
        }
    }

    private void display(MigrationEntry migrationEntry) {
        SourceFile before = migrationEntry.getRawResult().getBefore();
        SourceFile after = migrationEntry.getRawResult().getAfter();
        DiffNode diffNode = new DiffNode((ITypedElement)new StringElement("Left", before == null ? "" : before.printAll()), (ITypedElement)new StringElement("Right", after == null ? "" : after.printAll()));
        this.mergeViewer.setInput((Object)diffNode);
    }

    public void dispose() {
        if (this.mergeViewer != null && this.mergeViewer.getControl() != null) {
            this.mergeViewer.getControl().dispose();
            this.mergeViewer = null;
        }
        super.dispose();
    }

    static class StringElement
    implements ITypedElement,
    IStreamContentAccessor {
        private final String name;
        private final String content;

        public StringElement(String name, String content) {
            this.name = name;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return "txt";
        }

        public Image getImage() {
            return null;
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8));
        }
    }
}

