/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.handler;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.migration.controller.MigrationController;
import com.kms.katalon.migration.dialog.MigrationHistoryDialog;
import com.kms.katalon.migration.model.MigrationAttempt;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;

public class RevertHandler {
    @CanExecute
    public boolean canExecute() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        return currentProject != null && MigrationAttempt.hasAtLeastOneRevertableAttempt(currentProject);
    }

    @Execute
    public void execute(Shell shell) {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"No project is open to migrate.");
            return;
        }
        MigrationController controller = new MigrationController();
        List<MigrationAttempt> attempts = controller.loadAttemptsHistory(project);
        MigrationHistoryDialog historyDialog = new MigrationHistoryDialog(shell, attempts);
        historyDialog.setRevertHandler(selectedAttempt -> {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
            try {
                progressDialog.run(true, false, monitor -> {
                    monitor.beginTask("Reverting migration...", -1);
                    controller.revert((MigrationAttempt)selectedAttempt, update -> {});
                    monitor.done();
                });
                if (selectedAttempt.getStatus() != MigrationAttempt.Status.REVERTED) {
                    MessageDialog.openError((Shell)shell, (String)"Revert Failed", (String)"The migration revert process did not complete successfully. Please check the logs for more details.");
                    return;
                }
                MessageDialog afterRevertDialog = new MessageDialog(shell, "Revert Successful", null, "Your project has been restored to its pre-migration state. You can now continue working with the original setup.", 2, new String[]{"Acknowledge"}, 0);
                afterRevertDialog.open();
            }
            catch (Exception exception) {}
        });
        historyDialog.open();
    }
}

