/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.parts;

import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.migration.dialog.BetaBadge;
import com.kms.katalon.migration.model.MigrationPlan;
import com.kms.katalon.migration.model.ProgressUpdate;
import jakarta.annotation.PostConstruct;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;

public class MigrationProgressPart {
    private Composite headerComposite;
    private Label headerLabel;
    private StyledText migrationLogText;
    private Label modifiedFilesHeader;
    private StyledText modifiedFilesText;
    private Label progressPercentLabel;
    private Label progressNumberOfFilesLabel;
    private Composite progressGroupComposite;
    private ProgressBar progressBar;
    private Composite buttonsGroupComposite;
    private Runnable stopHandler;
    private Runnable viewChangeLogHandler;
    private Runnable revertHandler;
    private Runnable openDocumentationHandler;
    private int nFilesModified = 0;

    @PostConstruct
    public void createControls(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (boolean)false).background(ColorUtil.getWhiteBackgroundColor()).margin(12, 16).build();
        this.headerComposite = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2, (boolean)false).build();
        this.headerComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite leftHeaderGroup = (Composite)ComponentBuilder.gridContainer((Composite)this.headerComposite, (int)2, (boolean)false).build();
        leftHeaderGroup.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.headerLabel = (Label)ComponentBuilder.label((Composite)leftHeaderGroup).font(JFaceResources.getHeaderFont()).left().fillHorizontal().build();
        new BetaBadge(leftHeaderGroup);
        Link docLink = new Link(this.headerComposite, 0);
        docLink.setText("<a>View migration documentation</a>");
        GridData docLinkLayoutData = new GridData(131072, 0x1000000, false, false);
        docLink.setLayoutData((Object)docLinkLayoutData);
        docLink.addListener(13, e -> {
            if (this.openDocumentationHandler != null) {
                this.openDocumentationHandler.run();
            }
        });
        Composite progressComposite = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)3, (boolean)false).build();
        progressComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.progressPercentLabel = new Label(progressComposite, 0);
        this.progressPercentLabel.setText("Progress: 0%    ");
        this.progressPercentLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.progressGroupComposite = (Composite)ComponentBuilder.gridContainer((Composite)progressComposite, (int)2, (boolean)false).build();
        this.progressGroupComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.progressBar = new ProgressBar(this.progressGroupComposite, 256);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        ComponentBuilder.iconButton((Composite)this.progressGroupComposite, (String)"stop_16.png", (int)24).onClick(e -> {
            if (this.stopHandler != null) {
                this.stopHandler.run();
            }
        }).build();
        this.buttonsGroupComposite = (Composite)ComponentBuilder.gridContainer((Composite)progressComposite, (int)2, (boolean)false).build();
        this.buttonsGroupComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ComponentBuilder.button((Composite)this.buttonsGroupComposite, (int)8).text("Revert").right().secondaryButton().onClick(e -> {
            if (this.revertHandler != null) {
                this.revertHandler.run();
            }
        }).build();
        ComponentBuilder.button((Composite)this.buttonsGroupComposite, (int)8).text("View Change Log").right().primaryButton().onClick(e -> {
            if (this.viewChangeLogHandler != null) {
                this.viewChangeLogHandler.run();
            }
        }).build();
        this.progressNumberOfFilesLabel = (Label)ComponentBuilder.label((Composite)container).text("").left().fillHorizontal().build();
        Composite mainComposite = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2, (boolean)false).build();
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite leftComposite = (Composite)ComponentBuilder.gridContainer((Composite)mainComposite, (int)1, (boolean)false).margin(8).build();
        GridData filesCompositeData = new GridData(4, 4, false, true);
        filesCompositeData.widthHint = 300;
        leftComposite.setLayoutData((Object)filesCompositeData);
        this.modifiedFilesHeader = (Label)ComponentBuilder.label((Composite)leftComposite).text("Files to be modified").font(JFaceResources.getBannerFont()).build();
        this.modifiedFilesHeader.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite filesTextPadding = (Composite)ComponentBuilder.gridContainer((Composite)leftComposite, (int)1, (boolean)false).fill().build();
        this.modifiedFilesText = (StyledText)ComponentBuilder.styledText((Composite)filesTextPadding, (int)2826).font(JFaceResources.getTextFont()).fill().build();
        this.modifiedFilesText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.modifiedFilesText.setMargins(8, 8, 8, 8);
        Composite rightComposite = (Composite)ComponentBuilder.gridContainer((Composite)mainComposite, (int)1, (boolean)false).fill().margin(8).build();
        Label logHeader = (Label)ComponentBuilder.label((Composite)rightComposite, (int)0).text("Migration Log").font(JFaceResources.getBannerFont()).build();
        logHeader.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite logPadding = (Composite)ComponentBuilder.gridContainer((Composite)rightComposite, (int)1, (boolean)false).fill().build();
        this.migrationLogText = (StyledText)ComponentBuilder.styledText((Composite)logPadding, (int)2890).font(JFaceResources.getTextFont()).fill().build();
        this.migrationLogText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.migrationLogText.setMargins(8, 8, 8, 8);
    }

    public void onProgressUpdate(ProgressUpdate update) {
        switch (update.getType()) {
            case PERCENT_CHANGED: {
                update.getProgressInfo().ifPresent(progressInfo -> this.updateProgressInfo((ProgressUpdate.ProgressInfo)progressInfo));
                break;
            }
            case LOG_APPENDED: {
                update.getLogMessage().ifPresent(message -> UISynchronizeService.asyncExec(() -> {
                    this.migrationLogText.append((this.migrationLogText.getText().isEmpty() ? "" : "\n") + message);
                    this.migrationLogText.setTopIndex(this.migrationLogText.getLineCount() - 1);
                }));
                break;
            }
            case MODIFIED_FILE_APPENDED: {
                update.getModifiedFile().ifPresent(fileName -> UISynchronizeService.asyncExec(() -> {
                    ++this.nFilesModified;
                    this.modifiedFilesText.append((this.modifiedFilesText.getText().isEmpty() ? "" : "\n") + fileName);
                    this.modifiedFilesText.setTopIndex(this.modifiedFilesText.getLineCount() - 1);
                    this.modifiedFilesHeader.setText(String.format("Files to be modified (%s)", this.formatNumberOfFilesWithPlural(this.nFilesModified)));
                }));
                break;
            }
            case MIGRATION_STATUS_CHANGED: {
                update.getMigrationStatus().ifPresent(newMigrationStatus -> UISynchronizeService.asyncExec(() -> {
                    switch (newMigrationStatus) {
                        case APPLIED: {
                            this.progressPercentLabel.setText("\u2705 Migration Completed");
                            this.modifiedFilesHeader.setText(String.format("Modified files (%s)", this.formatNumberOfFilesWithPlural(this.nFilesModified)));
                            this.showPostMigrationButtonsGroup();
                            break;
                        }
                        case APPLY_FAILED: {
                            this.progressPercentLabel.setText("\u274c Migration Failed");
                            this.modifiedFilesHeader.setText(String.format("Modified files (%s)", this.formatNumberOfFilesWithPlural(this.nFilesModified)));
                            this.showPostMigrationButtonsGroup();
                            break;
                        }
                        case CANCELLED: {
                            this.progressPercentLabel.setText("Migration stopped");
                            this.showPostMigrationButtonsGroup();
                            break;
                        }
                    }
                }));
                break;
            }
        }
    }

    public void prepareToRunWithPlan(MigrationPlan plan) {
        UISynchronizeService.asyncExec(() -> {
            this.nFilesModified = 0;
            this.headerLabel.setText("Migrating from Studio " + plan.getFromVersion() + " to " + plan.getToVersion());
            this.headerComposite.layout(true, true);
            this.migrationLogText.setText("");
            this.modifiedFilesHeader.setText(String.format("Files to be modified (%s)", this.formatNumberOfFilesWithPlural(this.nFilesModified)));
            this.modifiedFilesText.setText("");
            this.showProgressGroup();
            this.progressBar.setSelection(0);
            this.progressBar.setVisible(true);
            this.progressPercentLabel.setText("Progress: 0%    ");
            this.buttonsGroupComposite.setVisible(false);
            this.buttonsGroupComposite.getParent().layout(true, true);
        });
    }

    private String formatNumberOfFilesWithPlural(int nFiles) {
        return nFiles + " file" + (nFiles == 1 ? "" : "s");
    }

    private void updateProgressInfo(ProgressUpdate.ProgressInfo progressInfo) {
        UISynchronizeService.asyncExec(() -> {
            int displayedPercent = (int)Math.round(progressInfo.getPercent() * 100.0);
            this.progressBar.setSelection(displayedPercent);
            this.progressPercentLabel.setText("Progress: " + displayedPercent + "%");
            this.progressNumberOfFilesLabel.setText(progressInfo.getnFilesProcessed() + " / " + progressInfo.getnTotalFiles() + " total file(s)");
        });
    }

    private void showProgressGroup() {
        UISynchronizeService.asyncExec(() -> {
            this.progressGroupComposite.setVisible(true);
            this.buttonsGroupComposite.setVisible(false);
            Composite parent = this.progressGroupComposite.getParent();
            if (parent != null) {
                parent.layout(true, true);
            }
        });
    }

    private void showPostMigrationButtonsGroup() {
        UISynchronizeService.asyncExec(() -> {
            this.progressGroupComposite.setVisible(false);
            this.buttonsGroupComposite.setVisible(true);
            Composite parent = this.buttonsGroupComposite.getParent();
            if (parent != null) {
                parent.layout(true, true);
            }
        });
    }

    public void setViewChangeLogHandler(Runnable handler) {
        this.viewChangeLogHandler = handler;
    }

    public void setRevertHandler(Runnable handler) {
        this.revertHandler = handler;
    }

    public void setOpenDocumentationHandler(Runnable handler) {
        this.openDocumentationHandler = handler;
    }

    public void setStopHandler(Runnable handler) {
        this.stopHandler = handler;
    }
}

