/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.ParseWarning;
import org.openrewrite.SourceFile;
import org.openrewrite.marker.Marker;

public class GroovyErrorAnalyzer {
    private static final Pattern ERROR_CURSOR_POS_PATTERN = Pattern.compile("at cursor position (\\d+)");
    private static final Pattern STRING_INDEX_OUT_OF_BOUNDS_PATTERN = Pattern.compile("begin (\\d+), end (\\d+), length (\\d+)");

    public static ParseErrorDetails extractErrorInfo(SourceFile sourceFile) {
        if (sourceFile == null) {
            return null;
        }
        for (Marker marker : sourceFile.getMarkers().getMarkers()) {
            if (marker instanceof ParseExceptionResult) {
                ParseExceptionResult parseExceptionResult = (ParseExceptionResult)marker;
                if ("CompilationFailedException".equals(parseExceptionResult.getExceptionType())) {
                    return new ParseErrorDetails(ParseErrorType.COMPILE_FAILED, GroovyErrorAnalyzer.analyzeGroovyCompilationError(parseExceptionResult, sourceFile), null, null, null);
                }
                String message = parseExceptionResult.getMessage();
                if (message != null && message.contains("is not print idempotent.")) {
                    return new ParseErrorDetails(ParseErrorType.NOT_PRINT_IDEMPOTENT, message, null, null, null);
                }
                ParseErrorDetails details = GroovyErrorAnalyzer.extractErrorLineNumber(parseExceptionResult, sourceFile);
                if (details == null) continue;
                return details;
            }
            if (!(marker instanceof ParseWarning)) continue;
            ParseWarning parseWarning = (ParseWarning)marker;
        }
        return null;
    }

    private static ParseErrorDetails extractErrorLineNumber(ParseExceptionResult parseException, SourceFile sourceFile) {
        Matcher stringIndexMatcher;
        Integer offsetToUse = null;
        Matcher cursorPosMatcher = ERROR_CURSOR_POS_PATTERN.matcher(parseException.getMessage());
        if (cursorPosMatcher.find()) {
            offsetToUse = Integer.parseInt(cursorPosMatcher.group(1));
        }
        if ((stringIndexMatcher = STRING_INDEX_OUT_OF_BOUNDS_PATTERN.matcher(parseException.getMessage())).find()) {
            int beginOffset = Integer.parseInt(stringIndexMatcher.group(1));
            if (offsetToUse == null) {
                offsetToUse = beginOffset;
            }
        }
        if (offsetToUse != null) {
            try {
                String fileContent = sourceFile.printAll();
                LineInfo lineInfo = GroovyErrorAnalyzer.getLineInfoFromOffset(fileContent, offsetToUse);
                if (lineInfo != null) {
                    return new ParseErrorDetails(ParseErrorType.PARSE_FAIL_AT_SPECIFIC_CURSOR, parseException.getMessage(), offsetToUse, lineInfo.lineNumber(), lineInfo.lineContent());
                }
                return new ParseErrorDetails(ParseErrorType.PARSE_FAIL_AT_SPECIFIC_CURSOR, parseException.getMessage(), offsetToUse, null, null);
            }
            catch (Exception e) {
                return new ParseErrorDetails(ParseErrorType.PARSE_FAIL_AT_SPECIFIC_CURSOR, "Error reading source file content to find error line: " + e.getMessage(), offsetToUse, null, null);
            }
        }
        return new ParseErrorDetails(ParseErrorType.UNKNOWN_ERROR, parseException.getMessage(), null, null, null);
    }

    private static LineInfo getLineInfoFromOffset(String sourceCode, int offset) {
        if (sourceCode == null || offset < 0 || offset >= sourceCode.length()) {
            return null;
        }
        int lineNumber = 1;
        int lineStart = 0;
        int i = 0;
        while (i < offset) {
            if (sourceCode.charAt(i) == '\n') {
                ++lineNumber;
                lineStart = i + 1;
            } else if (sourceCode.charAt(i) == '\r' && i + 1 < sourceCode.length() && sourceCode.charAt(i + 1) == '\n') {
                ++lineNumber;
                lineStart = i + 2;
                ++i;
            } else if (sourceCode.charAt(i) == '\r') {
                ++lineNumber;
                lineStart = i + 1;
            }
            ++i;
        }
        int lineEnd = lineStart;
        while (lineEnd < sourceCode.length() && sourceCode.charAt(lineEnd) != '\n' && sourceCode.charAt(lineEnd) != '\r') {
            ++lineEnd;
        }
        String lineContent = sourceCode.substring(lineStart, lineEnd);
        return new LineInfo(lineNumber, lineContent);
    }

    private static String analyzeGroovyCompilationError(ParseExceptionResult parseExceptionResult, SourceFile sourceFile) {
        String sourceCode = sourceFile.printAll();
        try {
            CompilerConfiguration config = new CompilerConfiguration();
            SourceUnit sourceUnit = new SourceUnit(sourceFile.getSourcePath().toString(), sourceCode, config, null, new ErrorCollector(config));
            sourceUnit.parse();
            sourceUnit.completePhase();
            sourceUnit.convert();
        }
        catch (CompilationFailedException cfe) {
            return cfe.getMessage();
        }
        catch (Exception e) {
            return "Groovy compilation failed: " + e.getMessage();
        }
        return parseExceptionResult.getMessage();
    }

    public record LineInfo(int lineNumber, String lineContent) {
    }

    public static class ParseErrorDetails {
        private ParseErrorType errorType;
        private String errorMessage;
        private Integer cursorPosition;
        private Integer lineNumber;
        private String lineContent;

        public ParseErrorDetails(ParseErrorType errorType, String errorMessage, Integer cursorPosition, Integer lineNumber, String lineContent) {
            this.errorType = errorType;
            this.errorMessage = errorMessage;
            this.cursorPosition = cursorPosition;
            this.lineNumber = lineNumber;
            this.lineContent = lineContent;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.errorType).append("\n");
            if (this.errorMessage != null) {
                sb.append("Error Message: ").append(this.errorMessage).append("\n");
            }
            if (this.cursorPosition != null) {
                sb.append("Cursor Position: ").append(this.cursorPosition).append("\n");
            }
            if (this.lineNumber != null) {
                sb.append("Line Number: ").append(this.lineNumber).append("\n");
            }
            if (this.lineContent != null) {
                sb.append("Line Content: ").append(this.lineContent).append("\n");
            }
            return sb.toString();
        }

        public ParseErrorType getErrorType() {
            return this.errorType;
        }

        public Integer getLineNumber() {
            return this.lineNumber;
        }

        public String getLineContent() {
            return this.lineContent;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Integer getCursorPosition() {
            return this.cursorPosition;
        }

        public void setCursorPosition(Integer cursorPosition) {
            this.cursorPosition = cursorPosition;
        }
    }

    public static enum ParseErrorType {
        COMPILE_FAILED,
        PARSE_FAIL_AT_SPECIFIC_CURSOR,
        NOT_PRINT_IDEMPOTENT,
        UNKNOWN_ERROR;

    }
}

