/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service.recipes.ks9to10;

import com.kms.katalon.migration.service.AstRecipeHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;

public class FindElementBy
extends Recipe {
    public String getDisplayName() {
        return "Replace deprecated findElement* methods with findElement(By.*) and findElements(By.*)";
    }

    public String getDescription() {
        return "Replace deprecated findElement* methods with findElement(By.*) and findElements(By.*)";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){
            private final Map<String, JavaTemplate> templates = new HashMap<String, JavaTemplate>();
            {
                this.templates.put("findElementByXPath", JavaTemplate.builder((String)"#{any()}.findElement(By.xpath(#{any()}))").build());
                this.templates.put("findElementById", JavaTemplate.builder((String)"#{any()}.findElement(By.id(#{any()}))").build());
                this.templates.put("findElementByClassName", JavaTemplate.builder((String)"#{any()}.findElement(By.className(#{any()}))").build());
                this.templates.put("findElementByCssSelector", JavaTemplate.builder((String)"#{any()}.findElement(By.cssSelector(#{any()}))").build());
                this.templates.put("findElementByLinkText", JavaTemplate.builder((String)"#{any()}.findElement(By.linkText(#{any()}))").build());
                this.templates.put("findElementByName", JavaTemplate.builder((String)"#{any()}.findElement(By.name(#{any()}))").build());
                this.templates.put("findElementByPartialLinkText", JavaTemplate.builder((String)"#{any()}.findElement(By.partialLinkText(#{any()}))").build());
                this.templates.put("findElementByTagName", JavaTemplate.builder((String)"#{any()}.findElement(By.tagName(#{any()}))").build());
                this.templates.put("findElementsByXPath", JavaTemplate.builder((String)"#{any()}.findElements(By.xpath(#{any()}))").build());
                this.templates.put("findElementsById", JavaTemplate.builder((String)"#{any()}.findElements(By.id(#{any()}))").build());
                this.templates.put("findElementsByClassName", JavaTemplate.builder((String)"#{any()}.findElements(By.className(#{any()}))").build());
                this.templates.put("findElementsByCssSelector", JavaTemplate.builder((String)"#{any()}.findElements(By.cssSelector(#{any()}))").build());
                this.templates.put("findElementsByLinkText", JavaTemplate.builder((String)"#{any()}.findElements(By.linkText(#{any()}))").build());
                this.templates.put("findElementsByName", JavaTemplate.builder((String)"#{any()}.findElements(By.name(#{any()}))").build());
                this.templates.put("findElementsByPartialLinkText", JavaTemplate.builder((String)"#{any()}.findElements(By.partialLinkText(#{any()}))").build());
                this.templates.put("findElementsByTagName", JavaTemplate.builder((String)"#{any()}.findElements(By.tagName(#{any()}))").build());
                this.templates.put("findElementByAccessibilityId", JavaTemplate.builder((String)"#{any()}.findElement(AppiumBy.accessibilityId(#{any()}))").build());
                this.templates.put("findElementByAndroidUIAutomator", JavaTemplate.builder((String)"#{any()}.findElement(AppiumBy.androidUIAutomator(#{any()}))").build());
                this.templates.put("findElementByAndroidViewTag", JavaTemplate.builder((String)"#{any()}.findElement(AppiumBy.androidViewTag(#{any()}))").build());
                this.templates.put("findElementByIosClassChain", JavaTemplate.builder((String)"#{any()}.findElement(AppiumBy.iOSClassChain(#{any()}))").build());
                this.templates.put("findElementByIosNsPredicate", JavaTemplate.builder((String)"#{any()}.findElement(AppiumBy.iOSNsPredicateString(#{any()}))").build());
                this.templates.put("findElementsByAccessibilityId", JavaTemplate.builder((String)"#{any()}.findElements(AppiumBy.accessibilityId(#{any()}))").build());
                this.templates.put("findElementsByAndroidUIAutomator", JavaTemplate.builder((String)"#{any()}.findElements(AppiumBy.androidUIAutomator(#{any()}))").build());
                this.templates.put("findElementsByAndroidViewTag", JavaTemplate.builder((String)"#{any()}.findElements(AppiumBy.androidViewTag(#{any()}))").build());
                this.templates.put("findElementsByIosClassChain", JavaTemplate.builder((String)"#{any()}.findElements(AppiumBy.iOSClassChain(#{any()}))").build());
                this.templates.put("findElementsByIosNsPredicate", JavaTemplate.builder((String)"#{any()}.findElements(AppiumBy.iOSNsPredicateString(#{any()}))").build());
                this.templates.put("findElementByImage", JavaTemplate.builder((String)"#{any()}.findElement(AppiumBy.image(#{any()}))").build());
                this.templates.put("findElementsByImage", JavaTemplate.builder((String)"#{any()}.findElements(AppiumBy.image(#{any()}))").build());
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation methodCall = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                JavaTemplate template = this.templates.get(methodCall.getSimpleName());
                if (template != null && methodCall.getArguments().size() == 1 && AstRecipeHelper.isMethodSelectAppiumDriver(methodCall)) {
                    J.MethodInvocation newMethodCall = (J.MethodInvocation)template.apply(this.getCursor(), methodCall.getCoordinates().replace(), new Object[]{methodCall.getSelect(), methodCall.getArguments().get(0)});
                    if (template.getCode().contains("AppiumBy.")) {
                        this.doAfterVisit((TreeVisitor)new AddImport("io.appium.java_client.AppiumBy", null, false));
                    } else {
                        this.doAfterVisit((TreeVisitor)new AddImport("org.openqa.selenium.By", null, false));
                    }
                    return newMethodCall;
                }
                return methodCall;
            }

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                G.CompilationUnit visitedCu = (G.CompilationUnit)super.visitCompilationUnit(cu, (Object)ctx);
                Set<String> importsToRemove = Set.of("io.appium.java_client.MobileElement", "io.appium.java_client.android.AndroidElement", "io.appium.java_client.ios.IOSElement");
                return AstRecipeHelper.updateImports(visitedCu, Set.of(), importsToRemove);
            }
        };
    }
}

