/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service.recipes.ks9to10;

import com.kms.katalon.migration.service.PlainTextRecipeHelper;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public class FindElementByPlainText
extends Recipe {
    public String getDisplayName() {
        return "Plain text: Replace deprecated findElement* methods with findElement(By.*) and findElements(By.*)";
    }

    public String getDescription() {
        return "Plain text fallback: Replace deprecated findElement* methods with findElement(By.*) and findElements(By.*), and migrate MobileElement to WebElement.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PlainTextVisitor<ExecutionContext>(){

            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                String code;
                String originalCode = code = text.getText();
                if ((code = PlainTextRecipeHelper.replaceTypeOutsideImports(code, "MobileElement", "WebElement")).contains("WebElement")) {
                    code = PlainTextRecipeHelper.insertImportAfterPackageDeclaration(code, "import org.openqa.selenium.WebElement");
                }
                List<String> importsToRemove = List.of("io.appium.java_client.MobileElement", "io.appium.java_client.android.AndroidElement", "io.appium.java_client.ios.IOSElement", "org.openqa.selenium.remote.server.handler.FindElements");
                for (String importToRemove : importsToRemove) {
                    code = PlainTextRecipeHelper.removeImport(code, importToRemove);
                }
                code = code.replaceAll("(\\w+)\\.findElementByXPath\\s*\\(([^()]*)\\)", "$1.findElement(By.xpath($2))");
                code = code.replaceAll("(\\w+)\\.findElementById\\s*\\(([^()]*)\\)", "$1.findElement(By.id($2))");
                code = code.replaceAll("(\\w+)\\.findElementByClassName\\s*\\(([^()]*)\\)", "$1.findElement(By.className($2))");
                code = code.replaceAll("(\\w+)\\.findElementByCssSelector\\s*\\(([^()]*)\\)", "$1.findElement(By.cssSelector($2))");
                code = code.replaceAll("(\\w+)\\.findElementByLinkText\\s*\\(([^()]*)\\)", "$1.findElement(By.linkText($2))");
                code = code.replaceAll("(\\w+)\\.findElementByName\\s*\\(([^()]*)\\)", "$1.findElement(By.name($2))");
                code = code.replaceAll("(\\w+)\\.findElementByPartialLinkText\\s*\\(([^()]*)\\)", "$1.findElement(By.partialLinkText($2))");
                code = code.replaceAll("(\\w+)\\.findElementByTagName\\s*\\(([^()]*)\\)", "$1.findElement(By.tagName($2))");
                code = code.replaceAll("(\\w+)\\.findElementsByXPath\\s*\\(([^()]*)\\)", "$1.findElements(By.xpath($2))");
                code = code.replaceAll("(\\w+)\\.findElementsById\\s*\\(([^()]*)\\)", "$1.findElements(By.id($2))");
                code = code.replaceAll("(\\w+)\\.findElementsByClassName\\s*\\(([^()]*)\\)", "$1.findElements(By.className($2))");
                code = code.replaceAll("(\\w+)\\.findElementsByCssSelector\\s*\\(([^()]*)\\)", "$1.findElements(By.cssSelector($2))");
                code = code.replaceAll("(\\w+)\\.findElementsByLinkText\\s*\\(([^()]*)\\)", "$1.findElements(By.linkText($2))");
                code = code.replaceAll("(\\w+)\\.findElementsByName\\s*\\(([^()]*)\\)", "$1.findElements(By.name($2))");
                code = code.replaceAll("(\\w+)\\.findElementsByPartialLinkText\\s*\\(([^()]*)\\)", "$1.findElements(By.partialLinkText($2))");
                code = code.replaceAll("(\\w+)\\.findElementsByTagName\\s*\\(([^()]*)\\)", "$1.findElements(By.tagName($2))");
                code = code.replaceAll("(\\w+)\\.findElementByAccessibilityId\\s*\\(([^()]*)\\)", "$1.findElement(AppiumBy.accessibilityId($2))");
                code = code.replaceAll("(\\w+)\\.findElementByAndroidUIAutomator\\s*\\(([^()]*)\\)", "$1.findElement(AppiumBy.androidUIAutomator($2))");
                code = code.replaceAll("(\\w+)\\.findElementByAndroidViewTag\\s*\\(([^()]*)\\)", "$1.findElement(AppiumBy.androidViewTag($2))");
                code = code.replaceAll("(\\w+)\\.findElementByIosClassChain\\s*\\(([^()]*)\\)", "$1.findElement(AppiumBy.iOSClassChain($2))");
                code = code.replaceAll("(\\w+)\\.findElementByIosNsPredicate\\s*\\(([^()]*)\\)", "$1.findElement(AppiumBy.iOSNsPredicateString($2))");
                code = code.replaceAll("(\\w+)\\.findElementByImage\\s*\\(([^()]*)\\)", "$1.findElement(AppiumBy.image($2))");
                code = code.replaceAll("(\\w+)\\.findElementsByAccessibilityId\\s*\\(([^()]*)\\)", "$1.findElements(AppiumBy.accessibilityId($2))");
                code = code.replaceAll("(\\w+)\\.findElementsByAndroidUIAutomator\\s*\\(([^()]*)\\)", "$1.findElements(AppiumBy.androidUIAutomator($2))");
                code = code.replaceAll("(\\w+)\\.findElementsByAndroidViewTag\\s*\\(([^()]*)\\)", "$1.findElements(AppiumBy.androidViewTag($2))");
                code = code.replaceAll("(\\w+)\\.findElementsByIosClassChain\\s*\\(([^()]*)\\)", "$1.findElements(AppiumBy.iOSClassChain($2))");
                code = code.replaceAll("(\\w+)\\.findElementsByIosNsPredicate\\s*\\(([^()]*)\\)", "$1.findElements(AppiumBy.iOSNsPredicateString($2))");
                if ((code = code.replaceAll("(\\w+)\\.findElementsByImage\\s*\\(([^()]*)\\)", "$1.findElements(AppiumBy.image($2))")).contains("AppiumBy.")) {
                    code = PlainTextRecipeHelper.insertImportAfterPackageDeclaration(code, "import io.appium.java_client.AppiumBy");
                } else if (code.contains("By.")) {
                    code = PlainTextRecipeHelper.insertImportAfterPackageDeclaration(code, "import org.openqa.selenium.By");
                }
                if (code.equals(originalCode)) {
                    return text;
                }
                return text.withText(code);
            }
        };
    }
}

