/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service.recipes.ks9to10.touchaction;

import com.kms.katalon.migration.service.AstRecipeHelper;
import com.kms.katalon.migration.service.recipes.ks9to10.touchaction.TouchActionHelper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class MultiTouchActionToPointerInput
extends Recipe {
    public String getDisplayName() {
        return "Migrate MultiTouchAction to PointerInput sequences";
    }

    public String getDescription() {
        return "Find multi-touch perform chains and convert them into WebDriver.perform(Arrays.asList(Sequence...)).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){
            boolean changed = false;
            int counter = 0;

            public J visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = (J.Block)super.visitBlock(block, (Object)ctx);
                List<Statement> replaced = this.migrateMultiTouchInStatements(b.getStatements(), (J)b, ctx);
                return b.withStatements(replaced);
            }

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                G.CompilationUnit visited = (G.CompilationUnit)super.visitCompilationUnit(cu, (Object)ctx);
                List<Statement> replaced = this.migrateMultiTouchInStatements(visited.getStatements(), (J)visited, ctx);
                if (!this.changed) {
                    return visited;
                }
                return TouchActionHelper.adjustImports(visited.withStatements(replaced));
            }

            private List<Statement> migrateMultiTouchInStatements(List<Statement> statements, J container, ExecutionContext ctx) {
                ArrayList<String> multiTouchVarsToRemove = new ArrayList<String>();
                ArrayList<String> actionVarsToRemove = new ArrayList<String>();
                ArrayList<Object> newStatementsPhase1 = new ArrayList<Object>();
                for (Statement statement : statements) {
                    J.Return jResturn;
                    Expression expression;
                    J.MethodInvocation perform = null;
                    if (statement instanceof J.Return && (expression = (jResturn = (J.Return)statement).getExpression()) instanceof Statement) {
                        Statement returnStatement = (Statement)expression;
                        perform = this.findMultiTouchPerform(returnStatement, container, ctx);
                    } else {
                        perform = this.findMultiTouchPerform(statement, container, ctx);
                    }
                    if (perform == null) {
                        newStatementsPhase1.add(statement);
                        continue;
                    }
                    MultiTouchParseResult multi = this.parseMultiTouch(perform, container, ctx);
                    if (!multi.valid() || multi.actionVars.isEmpty() || multi.driverVar == null) {
                        newStatementsPhase1.add(statement);
                        continue;
                    }
                    Expression sel = perform.getSelect();
                    while (sel instanceof J.MethodInvocation) {
                        J.MethodInvocation mi = (J.MethodInvocation)sel;
                        sel = mi.getSelect();
                    }
                    if (sel instanceof J.Identifier) {
                        J.Identifier id = (J.Identifier)sel;
                        multiTouchVarsToRemove.add(id.getSimpleName());
                    }
                    actionVarsToRemove.addAll(multi.actionVars);
                    ArrayList<CallSite> sequenceVarNames = new ArrayList<CallSite>();
                    ArrayList<Statement> setup = new ArrayList<Statement>();
                    for (String actionVar : multi.actionVars) {
                        TouchActionHelper.ChainParseResult chain = TouchActionHelper.parseActionChainFromActionVar(actionVar, container, ctx);
                        if (!chain.valid || chain.actionSteps.isEmpty()) {
                            setup.clear();
                            sequenceVarNames.clear();
                            break;
                        }
                        String base = actionVar + this.counter++;
                        String finger = "fingerOf" + StringUtils.capitalize((String)base);
                        String seq = "sequenceOf" + StringUtils.capitalize((String)base);
                        sequenceVarNames.add((CallSite)((Object)seq));
                        String code = TouchActionHelper.buildSequenceStatement(finger, seq, chain.actionSteps);
                        setup.addAll(AstRecipeHelper.buildStatementsFromGroovyCode(code.toString(), statement.getPrefix()));
                    }
                    if (sequenceVarNames.isEmpty() && !setup.isEmpty()) {
                        newStatementsPhase1.add(statement);
                        continue;
                    }
                    String joined = String.join((CharSequence)", ", sequenceVarNames);
                    String finalCall = multi.driverVar + ".perform(Arrays.asList(" + joined + "));";
                    List<Statement> finalStmts = AstRecipeHelper.buildStatementsFromGroovyCode(finalCall, statement.getPrefix());
                    newStatementsPhase1.addAll(setup);
                    newStatementsPhase1.addAll(finalStmts);
                    this.changed = true;
                }
                ArrayList<Statement> newStatementsPhase2 = new ArrayList<Statement>();
                for (Statement statement : newStatementsPhase1) {
                    J.VariableDeclarations vd;
                    J.VariableDeclarations vd2;
                    if (statement instanceof J.VariableDeclarations && (vd2 = (J.VariableDeclarations)statement).getVariables().size() == 1 && multiTouchVarsToRemove.contains(((J.VariableDeclarations.NamedVariable)vd2.getVariables().get(0)).getSimpleName()) || statement instanceof J.VariableDeclarations && (vd = (J.VariableDeclarations)statement).getVariables().size() == 1 && actionVarsToRemove.contains(((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getSimpleName())) continue;
                    if (statement instanceof J.MethodInvocation) {
                        J.Identifier id;
                        J.MethodInvocation mi = (J.MethodInvocation)statement;
                        Expression select = mi.getSelect();
                        while (select instanceof J.MethodInvocation) {
                            J.MethodInvocation chained = (J.MethodInvocation)select;
                            select = chained.getSelect();
                        }
                        if (select instanceof J.Identifier && actionVarsToRemove.contains((id = (J.Identifier)select).getSimpleName())) continue;
                    }
                    newStatementsPhase2.add(statement);
                }
                return newStatementsPhase2;
            }

            private MultiTouchParseResult parseMultiTouch(J.MethodInvocation perform, J container, ExecutionContext ctx) {
                J.NewClass nc;
                Expression expression;
                J.VariableDeclarations.NamedVariable decl;
                J.Identifier id;
                String driverVar = null;
                ArrayList<String> actionVars = new ArrayList<String>();
                Expression sel = perform.getSelect();
                while (sel instanceof J.MethodInvocation) {
                    J.MethodInvocation mi = (J.MethodInvocation)sel;
                    if ("add".equals(mi.getSimpleName()) && mi.getArguments().size() == 1) {
                        Expression arg = (Expression)mi.getArguments().get(0);
                        if (arg instanceof J.Identifier) {
                            id = (J.Identifier)arg;
                            actionVars.add(id.getSimpleName());
                        }
                        sel = mi.getSelect();
                        continue;
                    }
                    sel = mi.getSelect();
                }
                if (sel instanceof J.NewClass) {
                    J.NewClass nc2 = (J.NewClass)sel;
                    if (AstRecipeHelper.isNewClassEqual(nc2, "MultiTouchAction") && nc2.getArguments().size() == 1) {
                        driverVar = AstRecipeHelper.buildStringFromExpression((Expression)nc2.getArguments().get(0));
                    }
                } else if (sel instanceof J.Identifier && (decl = this.findVariableDeclarationOfType((id = (J.Identifier)sel).getSimpleName(), "MultiTouchAction", container, ctx)) != null && (expression = decl.getInitializer()) instanceof J.NewClass && AstRecipeHelper.isNewClassEqual(nc = (J.NewClass)expression, "MultiTouchAction") && nc.getArguments().size() == 1) {
                    driverVar = AstRecipeHelper.buildStringFromExpression((Expression)nc.getArguments().get(0));
                }
                Collections.reverse(actionVars);
                return new MultiTouchParseResult(driverVar != null && !actionVars.isEmpty(), driverVar, actionVars);
            }

            private J.VariableDeclarations.NamedVariable findVariableDeclarationOfType(final String varName, final String typeContains, J scope, ExecutionContext ctx) {
                final J.VariableDeclarations.NamedVariable[] found = new J.VariableDeclarations.NamedVariable[1];
                new GroovyVisitor<ExecutionContext>(){

                    public J visitVariable(J.VariableDeclarations.NamedVariable nv, ExecutionContext ec) {
                        if (varName.equals(nv.getSimpleName()) && nv.getVariableType() != null && nv.getVariableType().toString().contains(typeContains)) {
                            found[0] = nv;
                            return nv;
                        }
                        return super.visitVariable(nv, (Object)ec);
                    }
                }.visit((Tree)scope, (Object)ctx);
                return found[0];
            }

            private J.MethodInvocation findMultiTouchPerform(Statement s, final J container, final ExecutionContext ctx) {
                Expression expression;
                J.VariableDeclarations vd;
                J.MethodInvocation mi;
                if (s instanceof J.MethodInvocation && "perform".equals((mi = (J.MethodInvocation)s).getSimpleName()) && AstRecipeHelper.hasNoRealArguments(mi.getArguments()) && this.chainLooksLikeMultiTouch(mi, container, ctx)) {
                    return mi;
                }
                if (s instanceof J.VariableDeclarations && (vd = (J.VariableDeclarations)s).getVariables().size() == 1 && (expression = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer()) instanceof J.MethodInvocation) {
                    J.MethodInvocation init = (J.MethodInvocation)expression;
                    final J.MethodInvocation[] found = new J.MethodInvocation[1];
                    new GroovyVisitor<ExecutionContext>(){

                        public J visitMethodInvocation(J.MethodInvocation m, ExecutionContext ec) {
                            if ("perform".equals(m.getSimpleName()) && AstRecipeHelper.hasNoRealArguments(m.getArguments()) && this.chainLooksLikeMultiTouch(m, container, ctx)) {
                                found[0] = m;
                                return m;
                            }
                            return super.visitMethodInvocation(m, (Object)ec);
                        }
                    }.visit((Tree)init, (Object)ctx);
                    return found[0];
                }
                return null;
            }

            private boolean chainLooksLikeMultiTouch(J.MethodInvocation perform, J container, ExecutionContext ctx) {
                boolean hasAdd = false;
                Expression sel = perform.getSelect();
                while (sel instanceof J.MethodInvocation) {
                    J.MethodInvocation mi = (J.MethodInvocation)sel;
                    if ("add".equals(mi.getSimpleName())) {
                        hasAdd = true;
                    }
                    sel = mi.getSelect();
                }
                if (!hasAdd) {
                    return false;
                }
                if (sel instanceof J.NewClass) {
                    J.NewClass nc = (J.NewClass)sel;
                    return AstRecipeHelper.isNewClassEqual(nc, "MultiTouchAction");
                }
                if (sel instanceof J.Identifier) {
                    J.Identifier id = (J.Identifier)sel;
                    J.VariableDeclarations.NamedVariable decl = this.findVariableDeclarationOfType(id.getSimpleName(), "MultiTouchAction", container, ctx);
                    return decl != null;
                }
                return false;
            }
        };
    }

    private static class MultiTouchParseResult {
        final boolean valid;
        final String driverVar;
        final List<String> actionVars;

        MultiTouchParseResult(boolean valid, String driverVar, List<String> actionVars) {
            this.valid = valid;
            this.driverVar = driverVar;
            this.actionVars = actionVars;
        }

        boolean valid() {
            return this.valid;
        }
    }
}

