/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service.recipes.ks9to10.touchaction;

import com.kms.katalon.migration.service.AstRecipeHelper;
import com.kms.katalon.migration.service.recipes.ks9to10.touchaction.TouchActionHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class TouchActionToPointerInput
extends Recipe {
    public String getDisplayName() {
        return "Migrate TouchAction chains to PointerInput sequences";
    }

    public String getDescription() {
        return "Migrate TouchAction chains to PointerInput sequences";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){
            boolean hasChanges = false;
            int actionVarCounter = 0;

            public J visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block visitedBlock = (J.Block)super.visitBlock(block, (Object)ctx);
                List<Statement> newStatements = this.migrateStatements(visitedBlock.getStatements(), (J)visitedBlock, ctx);
                return visitedBlock.withStatements(newStatements);
            }

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                G.CompilationUnit visitedCu = (G.CompilationUnit)super.visitCompilationUnit(cu, (Object)ctx);
                List<Statement> newStatements = this.migrateStatements(visitedCu.getStatements(), (J)visitedCu, ctx);
                if (this.hasChanges) {
                    return TouchActionHelper.adjustImports(visitedCu.withStatements(newStatements));
                }
                return visitedCu;
            }

            private List<Statement> migrateStatements(List<Statement> statements, J container, ExecutionContext ctx) {
                ArrayList<Statement> newStatementsPhase1 = new ArrayList<Statement>();
                HashSet<String> touchActionVarsToRemove = new HashSet<String>();
                for (Statement statement : statements) {
                    J.Return jResturn;
                    Expression expression;
                    J.MethodInvocation performCall = null;
                    if (statement instanceof J.Return && (expression = (jResturn = (J.Return)statement).getExpression()) instanceof Statement) {
                        Statement returnStatement = (Statement)expression;
                        performCall = this.findPerformCall(returnStatement, ctx);
                    } else {
                        performCall = this.findPerformCall(statement, ctx);
                    }
                    if (performCall == null) {
                        newStatementsPhase1.add(statement);
                        continue;
                    }
                    TouchActionHelper.ChainParseResult chain = TouchActionHelper.parseActionChainFromPerformCall(performCall, container, ctx);
                    if (!chain.valid || chain.driverVar == null || chain.actionSteps.isEmpty()) {
                        newStatementsPhase1.add(statement);
                        continue;
                    }
                    String actionVarName = this.extractActionVariableName(statement, performCall);
                    if (!actionVarName.isEmpty()) {
                        touchActionVarsToRemove.add(actionVarName);
                    }
                    List<Statement> performStatements = this.buildNewStatements(chain.driverVar, chain.actionSteps, statement, performCall);
                    newStatementsPhase1.addAll(performStatements);
                    this.hasChanges = true;
                }
                ArrayList<Statement> newStatementsPhase2 = new ArrayList<Statement>();
                for (Statement st : newStatementsPhase1) {
                    J.VariableDeclarations vd;
                    if (st instanceof J.VariableDeclarations && (vd = (J.VariableDeclarations)st).getVariables().size() == 1 && touchActionVarsToRemove.contains(((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getSimpleName())) continue;
                    if (st instanceof J.MethodInvocation) {
                        J.Identifier id;
                        J.MethodInvocation mi = (J.MethodInvocation)st;
                        Expression select = mi.getSelect();
                        while (select instanceof J.MethodInvocation) {
                            J.MethodInvocation chained = (J.MethodInvocation)select;
                            select = chained.getSelect();
                        }
                        if (select instanceof J.Identifier && touchActionVarsToRemove.contains((id = (J.Identifier)select).getSimpleName())) continue;
                    }
                    newStatementsPhase2.add(st);
                }
                return newStatementsPhase2;
            }

            private J.MethodInvocation findPerformCall(Statement s, ExecutionContext ctx) {
                Expression expression;
                J.VariableDeclarations varDecl;
                J.MethodInvocation mi;
                if (s instanceof J.MethodInvocation && "perform".equals((mi = (J.MethodInvocation)s).getSimpleName()) && AstRecipeHelper.hasNoRealArguments(mi.getArguments())) {
                    return mi;
                }
                if (s instanceof J.VariableDeclarations && (varDecl = (J.VariableDeclarations)s).getVariables().size() == 1 && (expression = ((J.VariableDeclarations.NamedVariable)varDecl.getVariables().get(0)).getInitializer()) instanceof J.MethodInvocation) {
                    J.MethodInvocation initializerEnd = (J.MethodInvocation)expression;
                    final J.MethodInvocation[] foundPerform = new J.MethodInvocation[1];
                    new GroovyVisitor<ExecutionContext>(){

                        public J visitMethodInvocation(J.MethodInvocation m, ExecutionContext ec) {
                            if ("perform".equals(m.getSimpleName()) && AstRecipeHelper.hasNoRealArguments(m.getArguments())) {
                                foundPerform[0] = m;
                                return m;
                            }
                            return super.visitMethodInvocation(m, (Object)ec);
                        }
                    }.visit((Tree)initializerEnd, (Object)ctx);
                    return foundPerform[0];
                }
                return null;
            }

            private String extractActionVariableName(Statement originalStatement, J.MethodInvocation methodCall) {
                J.VariableDeclarations varDecl;
                if (originalStatement instanceof J.VariableDeclarations && !(varDecl = (J.VariableDeclarations)originalStatement).getVariables().isEmpty()) {
                    return ((J.VariableDeclarations.NamedVariable)varDecl.getVariables().get(0)).getSimpleName();
                }
                Expression currentSelect = methodCall.getSelect();
                while (currentSelect != null) {
                    if (currentSelect instanceof J.Identifier) {
                        J.Identifier identifier = (J.Identifier)currentSelect;
                        return identifier.getSimpleName();
                    }
                    if (!(currentSelect instanceof J.MethodInvocation)) break;
                    J.MethodInvocation mi = (J.MethodInvocation)currentSelect;
                    currentSelect = mi.getSelect();
                }
                return "";
            }

            private List<Statement> buildNewStatements(String driverVariableName, List<TouchActionHelper.ActionStep> actionSteps, Statement originalStatement, J.MethodInvocation performCall) {
                Object actionVarName = this.extractActionVariableName(originalStatement, performCall);
                if (((String)actionVarName).isEmpty()) {
                    actionVarName = "action";
                }
                if (((String)(actionVarName = (String)actionVarName + this.actionVarCounter++)).isEmpty()) {
                    actionVarName = "action";
                }
                String fingerVarName = "fingerOf" + StringUtils.capitalize((String)actionVarName);
                String sequenceVarName = "sequenceOf" + StringUtils.capitalize((String)actionVarName);
                String setup = TouchActionHelper.buildSequenceStatement(fingerVarName, sequenceVarName, actionSteps);
                String finalPerformCallString = driverVariableName + ".perform(Collections.singletonList(" + sequenceVarName + "));";
                String finalCode = setup + finalPerformCallString;
                return AstRecipeHelper.buildStatementsFromGroovyCode(finalCode, originalStatement.getPrefix());
            }
        };
    }
}

