/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.report;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.entity.ReportFolder;
import com.kms.katalon.integration.analytics.AnalyticsComponent;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.report.AnalyticsReportHelper;
import com.kms.katalon.integration.analytics.report.AnalyticsReportIntegration;
import com.kms.katalon.integration.analytics.util.ExecutionReportScanner;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsTestRun;
import com.kms.katalon.testops.core.model.AnalyticsTracking;
import com.kms.katalon.testops.core.model.ExecutionReportScanResult;
import com.kms.katalon.testops.core.model.exception.AnalyticsApiException;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.testops.services.TestOpsController;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class AnalyticsReportService
implements AnalyticsComponent {
    private ITestOpsController testOpsController = TestOpsController.getInstance();
    public static final String LOG_FILE_NAME = "execution0.log";
    public static final String REPORT_COLLECTION_FILE_EXTENSION = ".rp";

    public boolean isIntegrationEnabled() {
        boolean isIntegrationEnabled = false;
        try {
            isIntegrationEnabled = this.testOpsController.isIntegrated();
        }
        catch (Exception exception) {}
        return isIntegrationEnabled;
    }

    public boolean isAutoUploadAllTestReports() {
        boolean isAutoUploadAllTestReports = false;
        try {
            isAutoUploadAllTestReports = this.testOpsController.isAutoUploadReportEnabled();
        }
        catch (Exception exception) {}
        return isAutoUploadAllTestReports;
    }

    public void upload(ReportFolder reportFolder) throws AnalyticsApiException {
        LogUtil.printOutputLine((String)("isIntegrationEnabled: " + this.isIntegrationEnabled()));
        LogUtil.printOutputLine((String)("isAutoUploadAllTestReports: " + this.isAutoUploadAllTestReports()));
        LogUtil.printOutputLine((String)("isTestopsIntegrationEnabled: " + AnalyticsReportHelper.getInstance().isTestopsIntegrationEnabled()));
        if (this.isIntegrationEnabled() && this.isAutoUploadAllTestReports() && AnalyticsReportHelper.getInstance().isTestopsIntegrationEnabled()) {
            this.uploadReports(reportFolder, false);
        } else {
            LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_INTEGRATE_WITH_KA);
        }
    }

    public void uploadManually(ReportFolder reportFolder) throws AnalyticsApiException {
        this.uploadReports(reportFolder, true);
    }

    public void uploadReports(ReportFolder reportFolder, boolean isManually) throws AnalyticsApiException {
        LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_SEND_TEST_RESULT_START);
        try {
            this.renameTestRunNameBeforeUploadToTestOps(reportFolder, (String)AnalyticsReportIntegration.TESTOPS_TEST_RUN_NAME_CONSOLE_OPTION.getValue());
            this.perform(reportFolder, isManually);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)IntegrationAnalyticsMessages.MSG_SEND_ERROR);
            LogUtil.logError((String)IntegrationAnalyticsMessages.MSG_SEND_ERROR);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            LogUtil.logError((String)sw.toString());
            throw AnalyticsApiException.wrap((Exception)e);
        }
        LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_SEND_TEST_RESULT_END);
    }

    private void renameTestRunNameBeforeUploadToTestOps(ReportFolder reportFolder, String newTestRunName) {
        try {
            if (StringUtils.isBlank((CharSequence)newTestRunName)) {
                return;
            }
            try {
                EntityService.getInstance().validateName((String)newTestRunName);
            }
            catch (Exception exception) {
                String testRunType = "Test Suite Collection";
                if (reportFolder.isRunTestSuite()) {
                    testRunType = "Test Suite";
                }
                LogUtil.logError((String)MessageFormat.format(IntegrationAnalyticsMessages.MSG_INVALID_TESTRUN_NAME, "testOps.testRunName", testRunType));
                return;
            }
            newTestRunName = GlobalStringConstants.ROOT_FOLDER_NAME_TEST_SUITE + "/" + (String)newTestRunName;
            List<Path> files = new ExecutionReportScanner().scan(reportFolder);
            if (files.isEmpty()) {
                return;
            }
            Path executionLogFile = null;
            executionLogFile = reportFolder.isRunTestSuite() ? (Path)files.stream().filter(file -> file.getFileName().toString().contains(LOG_FILE_NAME)).findFirst().orElse(null) : (Path)files.stream().filter(file -> file.getFileName().toString().endsWith(REPORT_COLLECTION_FILE_EXTENSION)).findFirst().orElse(null);
            if (executionLogFile == null) {
                return;
            }
            if (reportFolder.isRunTestSuite()) {
                this.renameTestRunNameOfTestSuite(executionLogFile, (String)newTestRunName);
            } else {
                this.renameTestRunNameOfTestSuiteCollection(executionLogFile, (String)newTestRunName);
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)IntegrationAnalyticsMessages.MSG_RENAME_TESTRUN_NAME_ERROR);
        }
    }

    private void renameTestRunNameOfTestSuite(Path executionLogFilePath, String newTestRunName) throws IOException {
        String content = new String(Files.readAllBytes(executionLogFilePath), StandardCharsets.UTF_8);
        Pattern recordPattern = Pattern.compile("(<record>.*?</record>)", 32);
        Matcher recordMatcher = recordPattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        boolean found = false;
        while (recordMatcher.find()) {
            String recordBlock = recordMatcher.group(1);
            if (recordBlock.contains("startSuite")) {
                String updatedRecord = recordBlock.replaceAll("(<property name=\"id\">)(.*?)(</property>)", "$1" + newTestRunName + "$3");
                recordMatcher.appendReplacement(sb, Matcher.quoteReplacement(updatedRecord));
                found = true;
                continue;
            }
            recordMatcher.appendReplacement(sb, Matcher.quoteReplacement(recordBlock));
        }
        recordMatcher.appendTail(sb);
        if (found) {
            Files.write(executionLogFilePath, sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public void renameTestRunNameOfTestSuiteCollection(Path executionLogFilePath, String newTestRunName) throws IOException {
        String content = new String(Files.readAllBytes(executionLogFilePath), StandardCharsets.UTF_8);
        content = content.replaceAll("(<testSuiteCollectionId>)(.*?)(</testSuiteCollectionId>)", "$1" + newTestRunName + "$3");
        Files.write(executionLogFilePath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void perform(ReportFolder reportFolder, boolean isManually) throws Exception {
        if (reportFolder.isRunTestSuite()) {
            LogUtil.printOutputLine((String)"Uploading log files of test suite");
        } else {
            LogUtil.printOutputLine((String)"Uploading log files of test suite collection");
        }
        AnalyticsSettingStore settingStore = AnalyticsSettingStore.getStore((String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        Long projectId = null;
        if (ApplicationInfo.isPlatformStudio()) {
            projectId = this.getSettingStore().getProject().getId();
        } else {
            projectId = (Long)AnalyticsReportIntegration.TESTOPS_PROJECT_ID_CONSOLE_OPTION.getValue();
            if (projectId == null) {
                AnalyticsProject analyticsProject = isManually ? settingStore.getManualProject() : settingStore.getProject();
                projectId = analyticsProject.getId();
            } else {
                LogUtil.logInfo((String)("TestOps project is overridden to " + String.valueOf(projectId)));
            }
        }
        long batchId = System.currentTimeMillis();
        Path reportLocation = Paths.get(FolderController.getInstance().getReportRoot(project).getLocation(), new String[0]);
        List executions = null;
        if ("s3".equalsIgnoreCase("s3")) {
            ExecutionReportScanResult reportScanResult = new ExecutionReportScanner().lazyScan(reportFolder);
            LogUtil.printOutputLine((String)"TestOps uploadExecutionReports");
            executions = this.testOpsController.uploadExecutionReports(reportScanResult, reportLocation, projectId, Long.valueOf(batchId));
        } else {
            List<Path> files = new ExecutionReportScanner().scan(reportFolder);
            int i = 0;
            while (i < files.size()) {
                Path filePath = files.get(i);
                String folderPath = reportLocation.relativize(filePath.getParent()).toString();
                boolean isEnd = i == files.size() - 1;
                LogUtil.printOutputLine((String)("Sending file: " + String.valueOf(filePath.toAbsolutePath())));
                executions = this.testOpsController.sendLog(projectId, Long.valueOf(batchId), folderPath, filePath.toFile(), isEnd);
                ++i;
            }
        }
        if (executions != null && !executions.isEmpty()) {
            executions.stream().filter(execution -> execution != null).forEach(execution -> LogUtil.printOutputLine((String)MessageFormat.format(IntegrationAnalyticsMessages.MSG_EXECUTION_URL, execution.getWebUrl())));
        }
    }

    public void updateExecutionProccess(AnalyticsTestRun testRun) throws AnalyticsApiException {
        Long projectId = null;
        if (ApplicationInfo.isPlatformStudio()) {
            projectId = this.getSettingStore().getProject().getId();
        } else {
            projectId = (Long)AnalyticsReportIntegration.TESTOPS_PROJECT_ID_CONSOLE_OPTION.getValue();
            if (projectId == null) {
                projectId = this.getSettingStore().getProject().getId();
            }
        }
        Long finalProjectId = projectId;
        Executors.newCachedThreadPool().submit(() -> {
            try {
                this.testOpsController.updateTestRunResult(finalProjectId, testRun);
            }
            catch (AnalyticsApiException e) {
                LogUtil.logError((Throwable)e, (String)IntegrationAnalyticsMessages.MSG_SEND_ERROR);
            }
        });
    }

    public void sendTrackingActivity(AnalyticsTracking trackingInfo) {
        try {
            this.testOpsController.sendTrackingActivity(trackingInfo);
        }
        catch (AnalyticsApiException e) {
            LogUtil.logError((Throwable)e, (String)IntegrationAnalyticsMessages.MSG_SEND_ERROR);
        }
    }
}

