/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.dialog;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.providers.TypeCheckStyleCellTableLabelProvider;
import com.kms.katalon.composer.project.constants.ImageConstants;
import com.kms.katalon.core.util.internal.PathUtil;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ProjectChoosingDialog
extends AbstractDialog {
    private CTableViewer tableViewer;
    private List<File> projectFiles;
    private File rootFolder;
    private File selectedProjectFile;

    public ProjectChoosingDialog(Shell parentShell, File rootFolder, List<File> projectFiles) {
        super(parentShell);
        this.projectFiles = projectFiles;
        this.rootFolder = rootFolder;
    }

    protected void registerControlModifyListeners() {
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectChoosingDialog.this.selectedProjectFile = (File)ProjectChoosingDialog.this.tableViewer.getStructuredSelection().getFirstElement();
            }
        });
    }

    protected void setInput() {
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setInput(this.projectFiles);
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.projectFiles.get(0)));
        this.selectedProjectFile = this.projectFiles.get(0);
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Label lblNotification = new Label(container, 64);
        lblNotification.setLayoutData((Object)new GridData(4, 128, true, false));
        lblNotification.setText("There are some nested Katalon Studio projects under your selection. Please choose one project to open.");
        this.tableViewer = new CTableViewer(container, 0);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        TableViewerColumn tbvcName = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn tblclmnId = tbvcName.getColumn();
        tblclmnId.setWidth(150);
        tbvcName.setLabelProvider((CellLabelProvider)new ProjectFileLableProvider(0));
        tblclmnId.setText("Name");
        TableViewerColumn tbvcPath = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn tblclmnPath = tbvcPath.getColumn();
        tblclmnPath.setWidth(200);
        tbvcPath.setLabelProvider((CellLabelProvider)new ProjectFileLableProvider(1));
        tblclmnPath.setText("Path");
        return container;
    }

    public String getDialogTitle() {
        return "Project Choosing Dialog";
    }

    public File getSelectedProjectFile() {
        return this.selectedProjectFile;
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    private class ProjectFileLableProvider
    extends TypeCheckStyleCellTableLabelProvider<File> {
        public static final int CLMN_NAME_IDX = 0;
        public static final int CLMN_PATH_IDX = 1;

        public ProjectFileLableProvider(int columnIndex) {
            super(columnIndex);
        }

        protected Class<File> getElementType() {
            return File.class;
        }

        protected Image getImage(File element) {
            switch (this.columnIndex) {
                case 0: {
                    return ImageConstants.IMG_PROJECT_16;
                }
            }
            return null;
        }

        protected String getText(File element) {
            switch (this.columnIndex) {
                case 0: {
                    return FilenameUtils.getBaseName((String)element.getName());
                }
                case 1: {
                    return PathUtil.absoluteToRelativePath((String)element.getAbsolutePath(), (String)ProjectChoosingDialog.this.rootFolder.getAbsolutePath());
                }
            }
            return "";
        }
    }
}

