/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.dialog.ProjectTrustDialog;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.project.ProjectEntity;
import org.eclipse.swt.widgets.Shell;

public class ProjectTrustHandler {
    private static ProjectController projectController = ProjectController.getInstance();

    public static boolean checkProjectTrust(String projectPk, Shell shell) throws ControllerException {
        ProjectEntity project = projectController.getProject(projectPk);
        if (projectController.isProjectTrusted(project)) {
            return true;
        }
        ProjectTrustDialog projectTrustDialog = new ProjectTrustDialog(shell, project.getFolderLocation());
        int result = projectTrustDialog.open();
        if (result == 1) {
            try {
                boolean trustParentFolder = projectTrustDialog.isTrustParentFolder();
                if (trustParentFolder) {
                    projectController.trustWorkspace(project.getParentFolderPath());
                } else {
                    projectController.trustProject(project);
                }
                return true;
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e, (String)("Failed to trust project: " + project.getFolderLocation()));
                return false;
            }
        }
        return false;
    }
}

