/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.preference;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.execution.constants.PluginOptions;
import com.kms.katalon.execution.setting.PluginSettingStore;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PluginPreferencePage
extends PreferencePage {
    private PluginSettingStore pluginSettingStore = new PluginSettingStore(ProjectController.getInstance().getCurrentProject());
    private Map<PluginOptions, Button> reloadOptionButtons = new HashMap<PluginOptions, Button>();

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 128, true, true));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        Group grpReloadPluginOptions = new Group(container, 0);
        grpReloadPluginOptions.setText(StringConstants.PAGE_GRP_PLUGIN_REPOSITORY);
        grpReloadPluginOptions.setLayout((Layout)new GridLayout(1, false));
        grpReloadPluginOptions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Button rbtnOnlineAndOfflineOpt = new Button((Composite)grpReloadPluginOptions, 16);
        rbtnOnlineAndOfflineOpt.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        rbtnOnlineAndOfflineOpt.setText(StringConstants.PAGE_OPTION_RELOAD_ONLINE_AND_OFFLINE);
        this.reloadOptionButtons.put(PluginOptions.ONLINE_AND_OFFLINE, rbtnOnlineAndOfflineOpt);
        Button rbtnOnlineOpt = new Button((Composite)grpReloadPluginOptions, 16);
        rbtnOnlineOpt.setText(StringConstants.PAGE_OPTION_RELOAD_ONLINE);
        this.reloadOptionButtons.put(PluginOptions.ONLINE, rbtnOnlineOpt);
        Button rbtnOfflineOpt = new Button((Composite)grpReloadPluginOptions, 16);
        rbtnOfflineOpt.setText(StringConstants.PAGE_OPTION_RELOAD_OFFLINE);
        this.reloadOptionButtons.put(PluginOptions.OFFLINE, rbtnOfflineOpt);
        PluginOptions reloadOption = this.getReloadOption();
        if (reloadOption != null) {
            this.reloadOptionButtons.get(reloadOption).setSelection(true);
        }
        return composite;
    }

    public boolean performOk() {
        if (!this.isControlCreated()) {
            return super.performOk();
        }
        boolean performOk = super.performOk();
        if (performOk) {
            PluginOptions selectedReloadOption = (PluginOptions)this.reloadOptionButtons.entrySet().stream().filter(entry -> ((Button)entry.getValue()).getSelection()).findFirst().get().getKey();
            this.setReloadOption(selectedReloadOption);
        }
        return performOk;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.getPreferenceStore().setToDefault("plugin.reloadOption");
        PluginOptions reloadOption = this.getReloadOption();
        if (reloadOption != null) {
            this.reloadOptionButtons.get(reloadOption).setSelection(true);
        }
    }

    public ScopedPreferenceStore getPreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
    }

    private PluginOptions getReloadOption() {
        try {
            return this.pluginSettingStore.getReloadOption();
        }
        catch (IOException e) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
            return null;
        }
    }

    private void setReloadOption(PluginOptions option) {
        try {
            this.pluginSettingStore.setReloadOption(option);
        }
        catch (IOException e) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
        }
    }
}

