/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.sample;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.kms.katalon.composer.project.sample.SampleProjectType;
import com.kms.katalon.composer.project.sample.SampleRemoteProject;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.apache.commons.lang3.math.NumberUtils;

public class SampleRemoteProjectDeserializer
implements JsonDeserializer<SampleRemoteProject> {
    public SampleRemoteProject deserialize(JsonElement jsElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        SampleRemoteProject sampleRemoteProject = new SampleRemoteProject();
        JsonObject jsObject = jsElement.getAsJsonObject();
        sampleRemoteProject.setName(jsObject.get("name").getAsString());
        sampleRemoteProject.setSourceUrl(jsObject.get("source_url").getAsString());
        sampleRemoteProject.setDefaultBranch(jsObject.get("default_branch").getAsString());
        sampleRemoteProject.setType(SampleProjectType.fromString(jsObject.get("type").getAsString()));
        JsonObject thumbnailsJson = jsObject.get("thumbnails").getAsJsonObject();
        HashMap<Integer, String> thumbnails = new HashMap<Integer, String>();
        thumbnailsJson.entrySet().forEach(e -> {
            String sizeAsString = (String)e.getKey();
            int size = Math.round(NumberUtils.toFloat((String)sizeAsString.replaceAll("x", "")) * 100.0f);
            thumbnails.put(size, ((JsonElement)e.getValue()).getAsString());
        });
        sampleRemoteProject.setThumbnails(thumbnails);
        return sampleRemoteProject;
    }
}

