/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.ast;

import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObject;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;

public class GroovyParser {
    private static final String DEFAULT_INDENT_INCREASEMENT = "    ";
    public static final String[] GROOVY_IMPORTED_PACKAGES = new String[]{"java.io", "java.lang", "java.net", "java.util", "groovy.lang", "groovy.util"};
    public static final String[] GROOVY_IMPORTED_CLASSES = new String[]{"java.math.BigDecimal", "java.math.BigInteger"};
    private List<ClassNode> importedTypes = new ArrayList<ClassNode>();
    private Stack<String> classNameStack = new Stack();
    private String currentIndent = "";
    private boolean readyToIndent = false;
    private StringBuilder stringBuilder;

    public GroovyParser(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }

    public String getValue() {
        if (this.stringBuilder != null) {
            return this.stringBuilder.toString();
        }
        return "";
    }

    public void parse(Object object) {
        if (object instanceof Expression) {
            this.parse((Expression)object);
        } else if (object instanceof Statement) {
            this.parse((Statement)object);
        }
    }

    public void parse(List<? extends Expression> expressions) {
        boolean first = true;
        Iterator<? extends Expression> iterator = expressions.iterator();
        while (iterator.hasNext()) {
            Expression object;
            Expression expression = object = iterator.next();
            if (!first) {
                this.print(", ");
            }
            first = false;
            this.parse(expression);
        }
    }

    public void parse(ArgumentListExpression argumentListExpression, boolean showTypes) {
        this.print("(");
        int count = argumentListExpression.getExpressions().size();
        for (Expression expression : argumentListExpression.getExpressions()) {
            if (showTypes) {
                this.parseType(expression.getType());
                this.print(" ");
            }
            if (expression instanceof VariableExpression) {
                this.parse((VariableExpression)expression, false);
            } else if (expression instanceof ConstantExpression) {
                this.parse((ConstantExpression)expression, false);
            } else {
                this.parse(expression);
            }
            if (--count <= 0) continue;
            this.print(", ");
        }
        this.print(")");
    }

    public void parse(ArrayExpression arrayExpression) {
        this.print("new ");
        this.parseType(arrayExpression.getElementType());
        this.print("[");
        this.parse(arrayExpression.getExpressions());
        this.print("]");
    }

    public void parse(BooleanExpression booleanExpression) {
        if (booleanExpression instanceof NotExpression) {
            this.print("!(");
            this.parse(booleanExpression.getExpression());
            this.print(")");
        } else {
            this.parse(booleanExpression.getExpression());
        }
    }

    public void parse(BinaryExpression binaryExpression) {
        this.parse(binaryExpression.getLeftExpression());
        this.print(" " + binaryExpression.getOperation().getText() + " ");
        this.parse(binaryExpression.getRightExpression());
        if (binaryExpression.getOperation().getText().equals("[")) {
            this.print("]");
        }
    }

    public void parse(BitwiseNegationExpression bitwiseNegationExpression) {
        this.print("~(");
        this.parse(bitwiseNegationExpression.getExpression());
        this.print(") ");
    }

    public void parse(CastExpression castExpression) {
        this.print("((");
        this.parse(castExpression.getExpression());
        this.print(") as ");
        this.parseType(castExpression.getType());
        this.print(")");
    }

    public void parse(ClassExpression classExpression) {
        this.parseType(classExpression.getType());
    }

    public void parse(ClosureExpression closureExpression) {
        this.print("{ ");
        if (closureExpression.getParameters() != null) {
            this.parse(closureExpression.getParameters());
            this.print(" ->");
        }
        this.print("\n");
        this.parse(closureExpression.getCode());
        this.print("}");
    }

    public void parse(ConstantExpression constantExpression, boolean unwrapQuotes) {
        if (constantExpression.getValue() instanceof String && !unwrapQuotes) {
            this.print("'" + StringEscapeUtils.escapeJava((String)((String)constantExpression.getValue())).replace("'", "\\'") + "'");
        } else if (constantExpression.getValue() instanceof Character) {
            this.print("'" + String.valueOf(constantExpression.getValue()) + "'");
        } else {
            this.print(constantExpression.getText());
        }
    }

    public void parse(ConstructorCallExpression constructorCallExpression) {
        if (constructorCallExpression.isSuperCall()) {
            this.print("super");
        } else if (constructorCallExpression.isThisCall()) {
            this.print("this ");
        } else {
            this.print("new ");
            this.parseType(constructorCallExpression.getType());
        }
        this.parse(constructorCallExpression.getArguments());
    }

    public void parse(ClosureListExpression closureListExpression) {
        boolean first = true;
        for (Expression expression : closureListExpression.getExpressions()) {
            if (!first) {
                this.print("; ");
            }
            first = false;
            this.parse(expression);
        }
    }

    public void parse(DeclarationExpression declarationExpression) {
        if (declarationExpression.getRightExpression() instanceof EmptyExpression) {
            ConstantExpression constantExpression = new ConstantExpression(null);
            declarationExpression.setRightExpression((Expression)constantExpression);
        }
        if (declarationExpression.getLeftExpression() instanceof ArgumentListExpression) {
            this.print("def ");
            this.parse((ArgumentListExpression)declarationExpression.getLeftExpression(), true);
            this.print(declarationExpression.getOperation().getText());
            this.parse(declarationExpression.getRightExpression());
            if (declarationExpression.getOperation().getText().equals("[")) {
                this.print("]");
            }
        } else {
            if (declarationExpression.getLeftExpression() instanceof VariableExpression) {
                VariableExpression variableExpression = (VariableExpression)declarationExpression.getLeftExpression();
                this.parseType(variableExpression.getOriginType());
                this.print(" " + variableExpression.getName());
            } else {
                this.parse(declarationExpression.getLeftExpression());
            }
            this.print(" " + declarationExpression.getOperation().getText() + " ");
            this.parse(declarationExpression.getRightExpression());
            if (declarationExpression.getOperation().getText().equals("[")) {
                this.print("]");
            }
        }
    }

    public void parse(FieldExpression fieldExpression) {
        if (fieldExpression.getField() != null) {
            this.print(fieldExpression.getField().getName());
        }
    }

    public void parse(GStringExpression gStringExpression) {
        this.print(gStringExpression.getText());
    }

    public void parse(MapExpression mapExpression) {
        this.print("[");
        if (mapExpression.getMapEntryExpressions().size() == 0) {
            this.print(":");
        } else {
            this.parse(mapExpression.getMapEntryExpressions());
        }
        this.print("]");
    }

    public void parse(MapEntryExpression mapEntryExpression) {
        if (mapEntryExpression.getKeyExpression() instanceof SpreadMapExpression) {
            this.print("*");
        } else if (mapEntryExpression.getKeyExpression() instanceof PropertyExpression || mapEntryExpression.getKeyExpression() instanceof VariableExpression || mapEntryExpression.getKeyExpression() instanceof MethodCallExpression) {
            this.print("(");
            this.parse(mapEntryExpression.getKeyExpression());
            this.print(")");
        } else {
            this.parse(mapEntryExpression.getKeyExpression());
        }
        this.print(" : ");
        this.parse(mapEntryExpression.getValueExpression());
    }

    public void parse(MethodCallExpression methodCallExpression) {
        Expression method;
        Expression objectExp = methodCallExpression.getObjectExpression();
        boolean isCustomKeywordMethod = false;
        if (objectExp instanceof VariableExpression) {
            String methodName;
            if (((VariableExpression)objectExp).getName().equals("CustomKeywords") && methodCallExpression.getMethod() instanceof ConstantExpression && !(methodName = methodCallExpression.getMethod().getText()).startsWith("'")) {
                isCustomKeywordMethod = true;
            }
            if (!((VariableExpression)objectExp).getName().equals("this")) {
                this.parse((VariableExpression)objectExp, false);
            }
        } else {
            this.parse(objectExp);
        }
        if (methodCallExpression.isSpreadSafe()) {
            this.print("*");
        }
        if (methodCallExpression.isSafe()) {
            this.print("?");
        }
        if (!(objectExp instanceof VariableExpression) || !((VariableExpression)objectExp).getName().equals("this")) {
            this.print(".");
        }
        if ((method = methodCallExpression.getMethod()) instanceof ConstantExpression) {
            if (isCustomKeywordMethod) {
                this.print("'");
            }
            this.parse((ConstantExpression)method, true);
            if (isCustomKeywordMethod) {
                this.print("'");
            }
        } else {
            this.parse(method);
        }
        this.parse(methodCallExpression.getArguments());
    }

    public void parse(MethodPointerExpression methodPointerExpression) {
        this.parse(methodPointerExpression.getExpression());
        this.print(".&");
        this.parse(methodPointerExpression.getMethodName());
    }

    public void parse(PostfixExpression postfixExpression) {
        if (postfixExpression.getExpression() instanceof VariableExpression) {
            this.parse(postfixExpression.getExpression());
            this.print(postfixExpression.getOperation().getText());
        } else {
            this.print("(");
            this.parse(postfixExpression.getExpression());
            this.print(")");
            this.print(postfixExpression.getOperation().getText());
        }
    }

    public void parse(PrefixExpression prefixExpression) {
        if (prefixExpression.getExpression() instanceof VariableExpression) {
            this.print(prefixExpression.getOperation().getText());
            this.parse(prefixExpression.getExpression());
        } else {
            this.print(prefixExpression.getOperation().getText());
            this.print("(");
            this.parse(prefixExpression.getExpression());
            this.print(")");
        }
    }

    public void parse(PropertyExpression propertyExpression) {
        this.parse(propertyExpression.getObjectExpression());
        if (propertyExpression.isSpreadSafe()) {
            this.print("*");
        }
        if (propertyExpression.isSpreadSafe()) {
            this.print("*");
        } else if (propertyExpression.isSafe()) {
            this.print("?");
        }
        this.print(".");
        if (propertyExpression.getProperty() instanceof ConstantExpression) {
            this.parse((ConstantExpression)propertyExpression.getProperty(), true);
        } else {
            this.parse(propertyExpression.getProperty());
        }
    }

    public void parse(RangeExpression rangeExpression) {
        this.print("(");
        this.parse(rangeExpression.getFrom());
        this.print("..");
        this.parse(rangeExpression.getTo());
        this.print(")");
    }

    public void parse(ListExpression listExpression) {
        this.print("[");
        this.parse(listExpression.getExpressions());
        this.print("]");
    }

    public void parse(SpreadExpression spreadExpression) {
        this.print("*");
        this.parse(spreadExpression.getExpression());
    }

    public void parse(SpreadMapExpression spreadMapExpression) {
        this.print("*:");
        this.parse(spreadMapExpression.getExpression());
    }

    public void parse(StaticMethodCallExpression staticMethodCallExpression) {
        this.print(staticMethodCallExpression.getOwnerType().getName() + "." + staticMethodCallExpression.getMethod());
        if (staticMethodCallExpression.getArguments() instanceof VariableExpression || staticMethodCallExpression.getArguments() instanceof MethodCallExpression) {
            this.print("(");
            this.parse(staticMethodCallExpression.getArguments());
            this.print(")");
        } else {
            this.parse(staticMethodCallExpression.getArguments());
        }
    }

    public void parse(TernaryExpression ternaryExpression) {
        this.parse(ternaryExpression.getBooleanExpression());
        this.print(" ? ");
        this.parse(ternaryExpression.getTrueExpression());
        this.print(" : ");
        this.parse(ternaryExpression.getFalseExpression());
    }

    public void parse(TupleExpression tupleExpression) {
        this.print("(");
        this.parse(tupleExpression.getExpressions());
        this.print(")");
    }

    public void parse(UnaryMinusExpression unaryMinusExpression) {
        this.print("-(");
        this.parse(unaryMinusExpression.getExpression());
        this.print(")");
    }

    public void parse(UnaryPlusExpression unaryPlusExpression) {
        this.print("+(");
        this.parse(unaryPlusExpression.getExpression());
        this.print(")");
    }

    public void parse(VariableExpression variableExpression, boolean spacePad) {
        if (spacePad) {
            this.print(" " + variableExpression.getName() + " ");
        } else {
            this.print(variableExpression.getName());
        }
    }

    public void parse(Expression expression) {
        if (expression instanceof ArgumentListExpression) {
            this.parse((ArgumentListExpression)expression, false);
        } else if (expression instanceof ArrayExpression) {
            this.parse((ArrayExpression)expression);
        } else if (expression instanceof BooleanExpression) {
            this.parse((BooleanExpression)expression);
        } else if (expression instanceof BitwiseNegationExpression) {
            this.parse((BitwiseNegationExpression)expression);
        } else if (expression instanceof CastExpression) {
            this.parse((CastExpression)expression);
        } else if (expression instanceof ClosureExpression) {
            this.parse((ClosureExpression)expression);
        } else if (expression instanceof ConstructorCallExpression) {
            this.parse((ConstructorCallExpression)expression);
        } else if (expression instanceof DeclarationExpression) {
            this.parse((DeclarationExpression)expression);
        } else if (expression instanceof BinaryExpression) {
            this.parse((BinaryExpression)expression);
        } else if (expression instanceof FieldExpression) {
            this.parse((FieldExpression)expression);
        } else if (expression instanceof VariableExpression) {
            this.parse((VariableExpression)expression, false);
        } else if (expression instanceof GStringExpression) {
            this.parse((GStringExpression)expression);
        } else if (expression instanceof MapExpression) {
            this.parse((MapExpression)expression);
        } else if (expression instanceof MapEntryExpression) {
            this.parse((MapEntryExpression)expression);
        } else if (expression instanceof MethodCallExpression) {
            this.parse((MethodCallExpression)expression);
        } else if (expression instanceof MethodPointerExpression) {
            this.parse((MethodPointerExpression)expression);
        } else if (expression instanceof ConstantExpression) {
            this.parse((ConstantExpression)expression, false);
        } else if (expression instanceof PostfixExpression) {
            this.parse((PostfixExpression)expression);
        } else if (expression instanceof PrefixExpression) {
            this.parse((PrefixExpression)expression);
        } else if (expression instanceof RangeExpression) {
            this.parse((RangeExpression)expression);
        } else if (expression instanceof PropertyExpression) {
            this.parse((PropertyExpression)expression);
        } else if (expression instanceof ClassExpression) {
            this.parse((ClassExpression)expression);
        } else if (expression instanceof ClosureListExpression) {
            this.parse((ClosureListExpression)expression);
        } else if (expression instanceof ListExpression) {
            this.parse((ListExpression)expression);
        } else if (expression instanceof SpreadExpression) {
            this.parse((SpreadExpression)expression);
        } else if (expression instanceof SpreadMapExpression) {
            this.parse((SpreadMapExpression)expression);
        } else if (expression instanceof StaticMethodCallExpression) {
            this.parse((StaticMethodCallExpression)expression);
        } else if (expression instanceof TernaryExpression) {
            this.parse((TernaryExpression)expression);
        } else if (expression instanceof TupleExpression) {
            this.parse((TupleExpression)expression);
        } else if (expression instanceof UnaryMinusExpression) {
            this.parse((UnaryMinusExpression)expression);
        } else if (expression instanceof UnaryPlusExpression) {
            this.parse((UnaryPlusExpression)expression);
        } else if (expression instanceof EmptyExpression) {
            this.parse(expression);
        }
    }

    public void parse(Statement statement) {
        if (statement instanceof BlockStatement) {
            this.parse((BlockStatement)statement);
        } else if (statement instanceof ExpressionStatement) {
            this.parse((ExpressionStatement)statement);
        } else if (statement instanceof ReturnStatement) {
            this.parse((ReturnStatement)statement);
        } else if (statement instanceof AssertStatement) {
            this.parse((AssertStatement)statement);
        } else if (statement instanceof BreakStatement) {
            this.parse((BreakStatement)statement);
        } else if (statement instanceof SwitchStatement) {
            this.parse((SwitchStatement)statement);
        } else if (statement instanceof ThrowStatement) {
            this.parse((ThrowStatement)statement);
        } else if (statement instanceof TryCatchStatement) {
            this.parse((TryCatchStatement)statement);
        } else if (statement instanceof IfStatement) {
            this.parse((IfStatement)statement);
        } else if (statement instanceof ForStatement) {
            this.parse((ForStatement)statement);
        } else if (statement instanceof WhileStatement) {
            this.parse((WhileStatement)statement);
        } else if (statement instanceof DoWhileStatement) {
            this.parse((DoWhileStatement)statement);
        } else if (statement instanceof SynchronizedStatement) {
            this.parse((SynchronizedStatement)statement);
        } else if (statement instanceof CaseStatement) {
            this.parse((CaseStatement)statement);
        } else if (statement instanceof CatchStatement) {
            this.parse((CatchStatement)statement);
        } else if (statement instanceof ContinueStatement) {
            this.parse((ContinueStatement)statement);
        }
    }

    public void parse(BlockStatement blockStatement) {
        for (Statement statement : blockStatement.getStatements()) {
            this.parse(statement);
            this.printLineBreak();
        }
    }

    public void parse(ExpressionStatement expressionStatement) {
        this.parse(expressionStatement.getExpression());
    }

    public void parse(ReturnStatement returnStatement) {
        this.printLineBreak();
        this.print("return ");
        this.parse(returnStatement.getExpression());
        this.printLineBreak();
    }

    public void parse(AssertStatement assertStatement) {
        this.print("assert ");
        this.parse(assertStatement.getBooleanExpression());
        if (assertStatement.getMessageExpression() instanceof ConstantExpression && ((ConstantExpression)assertStatement.getMessageExpression()).getValue() != null) {
            this.print(" : ");
            this.parse(assertStatement.getMessageExpression());
        }
    }

    public void parse(BreakStatement breakStatement) {
        this.print("break");
        this.printLineBreak();
    }

    public void parse(ContinueStatement continueStatement) {
        this.print("continue");
        this.printLineBreak();
    }

    public void parse(SwitchStatement switchStatement) {
        this.print("switch (");
        this.parse(switchStatement.getExpression());
        this.print(") {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        for (CaseStatement caseStatement : switchStatement.getCaseStatements()) {
            this.parse(caseStatement);
            this.printLineBreak();
        }
        if (switchStatement.getDefaultStatement() != null && !(switchStatement.getDefaultStatement() instanceof EmptyStatement)) {
            this.print("default:");
            this.printLineBreak();
            String lastInnerIndent = this.increaseIndent();
            this.parse(switchStatement.getDefaultStatement());
            this.resetIndent(lastInnerIndent);
        }
        this.resetIndent(lastIndent);
        this.print("}");
        this.printLineBreak();
    }

    public void parse(CaseStatement caseStatement) {
        this.print("case ");
        this.parse(caseStatement.getExpression());
        this.print(":");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parse(caseStatement.getCode());
        this.resetIndent(lastIndent);
    }

    public void parse(ThrowStatement throwStatement) {
        this.print("throw ");
        this.parse(throwStatement.getExpression());
        this.printLineBreak();
    }

    public void parse(TryCatchStatement tryCatchStatement) {
        this.print("try {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parse(tryCatchStatement.getTryStatement());
        this.resetIndent(lastIndent);
        this.printLineBreak();
        this.print("}");
        this.printLineBreak();
        for (CatchStatement catchStatement : tryCatchStatement.getCatchStatements()) {
            this.parse(catchStatement);
        }
        if (tryCatchStatement.getFinallyStatement() != null && !(tryCatchStatement.getFinallyStatement() instanceof EmptyStatement)) {
            this.print("finally { ");
            this.printLineBreak();
            lastIndent = this.increaseIndent();
            this.parse(tryCatchStatement.getFinallyStatement());
            this.resetIndent(lastIndent);
            this.print("}");
        }
        this.printLineBreak();
    }

    public void parse(CatchStatement catchStatement) {
        this.print("catch (");
        this.parse(new Parameter[]{catchStatement.getVariable()});
        this.print(") {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parse(catchStatement.getCode());
        this.resetIndent(lastIndent);
        this.print("} ");
        this.printLineBreak();
    }

    public void parse(IfStatement ifStatement) {
        this.print("if (");
        this.parse(ifStatement.getBooleanExpression());
        this.print(") {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parse(ifStatement.getIfBlock());
        this.resetIndent(lastIndent);
        this.printLineBreak();
        if (ifStatement.getElseBlock() != null && !(ifStatement.getElseBlock() instanceof EmptyStatement)) {
            if (ifStatement.getElseBlock() instanceof IfStatement) {
                this.print("} else ");
                this.parse((IfStatement)ifStatement.getElseBlock());
            } else {
                this.print("} else {");
                this.printLineBreak();
                lastIndent = this.increaseIndent();
                this.parse(ifStatement.getElseBlock());
                this.resetIndent(lastIndent);
                this.printLineBreak();
                this.print("}");
            }
        } else {
            this.print("}");
        }
        this.printLineBreak();
    }

    public void parse(ForStatement forStatement) {
        this.print("for (");
        if (!(forStatement.getCollectionExpression() instanceof ClosureListExpression) && forStatement.getVariable() != ForStatement.FOR_LOOP_DUMMY) {
            this.parse(new Parameter[]{forStatement.getVariable()});
            this.print(" : ");
        }
        this.parse(forStatement.getCollectionExpression());
        this.print(") {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parse(forStatement.getLoopBlock());
        this.resetIndent(lastIndent);
        this.print("}");
        this.printLineBreak();
    }

    public void parse(WhileStatement whileStatement) {
        this.print("while (");
        this.parse(whileStatement.getBooleanExpression());
        this.print(") {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parse(whileStatement.getLoopBlock());
        this.resetIndent(lastIndent);
        this.printLineBreak();
        this.print("}");
        this.printLineBreak();
    }

    public void parse(DoWhileStatement doWhileStatement) {
        this.print("do {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parse(doWhileStatement.getLoopBlock());
        this.resetIndent(lastIndent);
        this.print("} while (");
        this.printLineBreak();
        this.parse(doWhileStatement.getBooleanExpression());
        this.print(")");
        this.printLineBreak();
    }

    public void parse(SynchronizedStatement synchronizedStatement) {
        this.print("synchronized (");
        this.parse(synchronizedStatement.getExpression());
        this.print(") {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parse(synchronizedStatement.getExpression());
        this.resetIndent(lastIndent);
        this.print("}");
    }

    public void parse(Parameter[] parameters) {
        boolean first = true;
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            if (!first) {
                this.print(", ");
            }
            first = false;
            for (AnnotationNode annotation : parameter.getAnnotations()) {
                this.parse(annotation);
                this.print(" ");
            }
            this.parseModifiers(parameter.getModifiers());
            this.parseType(parameter.getType());
            this.print(" " + parameter.getName());
            if (parameter.getInitialExpression() != null && !(parameter.getInitialExpression() instanceof EmptyExpression)) {
                this.print(" = ");
                this.parse(parameter.getInitialExpression());
            }
            ++n2;
        }
    }

    public void parseModifiers(int modifiers) {
        if (Modifier.isAbstract(modifiers)) {
            this.print("abstract ");
        }
        if (Modifier.isFinal(modifiers)) {
            this.print("final ");
        }
        if (Modifier.isInterface(modifiers)) {
            this.print("interface ");
        }
        if (Modifier.isNative(modifiers)) {
            this.print("native ");
        }
        if (Modifier.isPrivate(modifiers)) {
            this.print("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            this.print("protected ");
        }
        Modifier.isPublic(modifiers);
        if (Modifier.isStatic(modifiers)) {
            this.print("static ");
        }
        if (Modifier.isSynchronized(modifiers)) {
            this.print("synchronized ");
        }
        if (Modifier.isTransient(modifiers)) {
            this.print("transient ");
        }
        if (Modifier.isVolatile(modifiers)) {
            this.print("volatile ");
        }
    }

    public void parse(AnnotationNode annotationNode) {
        this.print("@" + annotationNode.getClassNode().getName());
        if (annotationNode.getMembers() != null && !annotationNode.getMembers().isEmpty()) {
            this.print("(");
            boolean first = true;
            for (Map.Entry pairs : annotationNode.getMembers().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    this.print(", ");
                }
                this.print((String)pairs.getKey() + " = ");
                this.parse((Expression)pairs.getValue());
            }
            this.print(")");
        }
    }

    public void parseType(ClassNode classNode) {
        String name = classNode.getName();
        if (name.startsWith("[")) {
            this.print(classNode.toString());
        } else if (classNode.getName().equals(Object.class.getName())) {
            this.print("def");
        } else if (this.importedTypes.contains(classNode)) {
            this.print(classNode.getNameWithoutPackage());
        } else {
            boolean isImported = false;
            String[] stringArray = GROOVY_IMPORTED_CLASSES;
            int n = GROOVY_IMPORTED_CLASSES.length;
            int n2 = 0;
            while (n2 < n) {
                String groovyImportedClass = stringArray[n2];
                if (name.equals(groovyImportedClass)) {
                    isImported = true;
                    break;
                }
                ++n2;
            }
            stringArray = GROOVY_IMPORTED_PACKAGES;
            n = GROOVY_IMPORTED_PACKAGES.length;
            n2 = 0;
            while (n2 < n) {
                String groovyImportedPackage = stringArray[n2];
                if (name.startsWith(groovyImportedPackage)) {
                    isImported = true;
                    break;
                }
                ++n2;
            }
            if (isImported) {
                this.print(classNode.getNameWithoutPackage());
            } else {
                this.print(name);
            }
        }
        this.parse(classNode.getGenericsTypes());
    }

    public void parse(GenericsType[] generics) {
        if (generics != null && generics.length > 0) {
            this.print("<");
            boolean first = true;
            GenericsType[] genericsTypeArray = generics;
            int n = generics.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType generic = genericsTypeArray[n2];
                if (!first) {
                    this.print(", ");
                }
                first = false;
                this.print(generic.getName());
                if (generic.getUpperBounds() != null && generic.getUpperBounds().length > 0) {
                    this.print(" extends ");
                    boolean innerFirst = true;
                    ClassNode[] classNodeArray = generic.getUpperBounds();
                    int n3 = classNodeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ClassNode upperBound = classNodeArray[n4];
                        if (!innerFirst) {
                            this.print(" & ");
                        }
                        innerFirst = false;
                        this.parseType(upperBound);
                        ++n4;
                    }
                }
                if (generic.getLowerBound() != null) {
                    this.print(" super ");
                    this.parseType(generic.getLowerBound());
                }
                ++n2;
            }
            this.print(">");
        }
    }

    public void parseClass(ClassNode classNode) {
        this.classNameStack.push(classNode.getName());
        for (AnnotationNode annotationNode : classNode.getAnnotations()) {
            this.parse(annotationNode);
            this.printLineBreak();
        }
        this.parseModifiers(classNode.getModifiers());
        this.print("class " + classNode.getNameWithoutPackage());
        this.parse(classNode.getGenericsTypes());
        if (classNode.getInterfaces().length != 1 || !classNode.getInterfaces()[0].getName().equals(GroovyObject.class.getName())) {
            boolean first = true;
            ClassNode[] classNodeArray = classNode.getInterfaces();
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode interfaceNode = classNodeArray[n2];
                if (!interfaceNode.getName().equals(GroovyObject.class.getName())) {
                    if (!first) {
                        this.print(", ");
                    } else {
                        this.print(" implements ");
                    }
                    first = false;
                    this.parseType(interfaceNode);
                }
                ++n2;
            }
        }
        if (!classNode.getSuperClass().getName().equals(Object.class.getName())) {
            this.print(" extends ");
            this.parseType(classNode.getSuperClass());
        }
        this.print(" { ");
        this.printDoubleLineBreak();
        String lastIndent = this.increaseIndent();
        for (FieldNode fieldNode : classNode.getFields()) {
            this.parseField(fieldNode);
        }
        this.printDoubleLineBreak();
        for (ConstructorNode constructorNode : classNode.getDeclaredConstructors()) {
            this.parseMethod((MethodNode)constructorNode);
        }
        this.printLineBreak();
        for (MethodNode methodNode : classNode.getMethods()) {
            this.parseMethod(methodNode);
        }
        this.resetIndent(lastIndent);
        this.print("}");
        this.printLineBreak();
        this.classNameStack.pop();
    }

    public void parseMethod(MethodNode methodNode) {
        if (methodNode.getLineNumber() > 0) {
            if (methodNode.getCode() instanceof ReturnStatement && ((ReturnStatement)methodNode.getCode()).getExpression() instanceof ConstantExpression && ((ConstantExpression)((ReturnStatement)methodNode.getCode()).getExpression()).getValue() == null) {
                methodNode.setCode((Statement)new BlockStatement());
            } else {
                for (AnnotationNode annotationNode : methodNode.getAnnotations()) {
                    this.parse(annotationNode);
                    this.printLineBreak();
                }
                this.parseModifiers(methodNode.getModifiers());
                if (methodNode.getName().equals("<init>")) {
                    this.print(this.classNameStack.peek() + "(");
                    this.parse(methodNode.getParameters());
                    this.print(") {");
                    this.printLineBreak();
                } else if (methodNode.getName().equals("<clinit>")) {
                    this.print("{ ");
                    this.printLineBreak();
                } else {
                    this.parseType(methodNode.getReturnType());
                    this.print(" " + methodNode.getName() + "(");
                    this.parse(methodNode.getParameters());
                    this.print(")");
                    if (methodNode.getExceptions() != null && methodNode.getExceptions().length > 0) {
                        boolean first = true;
                        this.print(" throws ");
                        ClassNode[] classNodeArray = methodNode.getExceptions();
                        int n = classNodeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ClassNode exceptionClassNode = classNodeArray[n2];
                            if (!first) {
                                this.print(", ");
                            }
                            first = false;
                            this.parseType(exceptionClassNode);
                            ++n2;
                        }
                    }
                    this.print(" {");
                    this.printLineBreak();
                }
                String lastIndent = this.increaseIndent();
                this.parse(methodNode.getCode());
                this.resetIndent(lastIndent);
                this.printLineBreak();
                this.print("}");
                this.printDoubleLineBreak();
            }
        }
    }

    public void parseField(FieldNode fieldNode) {
        if (fieldNode.getLineNumber() > 0) {
            for (AnnotationNode annotationNode : fieldNode.getAnnotations()) {
                this.parse(annotationNode);
                this.printLineBreak();
            }
            this.parseModifiers(fieldNode.getModifiers());
            this.parseType(fieldNode.getType());
            this.print(" " + fieldNode.getName() + " ");
            if (fieldNode.getInitialValueExpression() != null) {
                Expression initialValueExpression = fieldNode.getInitialValueExpression();
                if (initialValueExpression instanceof ConstantExpression) {
                    initialValueExpression = Verifier.transformToPrimitiveConstantIfPossible((ConstantExpression)((ConstantExpression)initialValueExpression));
                }
                ClassNode type = initialValueExpression.getType();
                if (Modifier.isStatic(fieldNode.getModifiers()) && Modifier.isFinal(fieldNode.getModifiers()) && initialValueExpression instanceof ConstantExpression && type == fieldNode.getType() && ClassHelper.isStaticConstantInitializerType((ClassNode)type)) {
                    this.print(" = ");
                    if (ClassHelper.STRING_TYPE == type) {
                        this.print("'" + initialValueExpression.getText().replaceAll("'", "\\\\'") + "'");
                    } else if (ClassHelper.char_TYPE == type) {
                        this.print("'" + initialValueExpression.getText() + "'");
                    } else {
                        this.print(initialValueExpression.getText());
                    }
                }
            }
            this.printLineBreak();
        }
    }

    public String increaseIndent() {
        String lastIndent = this.currentIndent;
        this.currentIndent = String.valueOf(this.currentIndent) + DEFAULT_INDENT_INCREASEMENT;
        return lastIndent;
    }

    public void resetIndent(String lastIndent) {
        this.currentIndent = lastIndent;
    }

    public void parse(ImportNode importNode) {
        if (importNode != null) {
            this.importedTypes.add(importNode.getType());
            for (AnnotationNode annotationNode : importNode.getAnnotations()) {
                this.parse(annotationNode);
                this.printLineBreak();
            }
            this.print(importNode.getText());
            this.printLineBreak();
        }
    }

    public void parse(PackageNode packageNode) {
        if (packageNode != null) {
            for (AnnotationNode annotationNode : packageNode.getAnnotations()) {
                this.parse(annotationNode);
                this.printLineBreak();
            }
            if (packageNode.getText().endsWith(".")) {
                this.print(packageNode.getText().substring(0, packageNode.getText().length() - 1));
            } else {
                this.print(packageNode.getText());
            }
            this.printDoubleLineBreak();
        }
    }

    public static List<ASTNode> parseGroovyScriptIntoAstNodes(String scriptContent) throws Exception {
        if (scriptContent != null && !(scriptContent = scriptContent.trim()).isEmpty()) {
            return new AstBuilder().buildFromString(CompilePhase.CONVERSION, false, scriptContent);
        }
        return Collections.emptyList();
    }

    public static ASTNode parseGroovyScriptAndGetFirstItem(String scriptContent) throws Exception {
        List<ASTNode> astNodes = GroovyParser.parseGroovyScriptIntoAstNodes(scriptContent);
        for (ASTNode astNode : astNodes) {
            if (!(astNode instanceof ClassNode) || !((ClassNode)astNode).isScript()) continue;
            ClassNode mainClassNode = (ClassNode)astNode;
            for (MethodNode methodNode : mainClassNode.getMethods()) {
                BlockStatement blockStatement;
                if (!methodNode.getName().equals("run") || !(methodNode.getCode() instanceof BlockStatement) || (blockStatement = (BlockStatement)methodNode.getCode()).getStatements().size() <= 0) continue;
                return (ASTNode)blockStatement.getStatements().get(0);
            }
        }
        return null;
    }

    private void parsePackageAndImport(List<? extends ASTNode> astNodes) {
        Comparator<ImportNode> importNodeComparator = new Comparator<ImportNode>(){

            @Override
            public int compare(ImportNode n1, ImportNode n2) {
                if (n1 == n2) {
                    return 0;
                }
                if (n1 == null) {
                    return -1;
                }
                if (n2 == null) {
                    return 1;
                }
                return n1.getClassName().compareTo(n2.getClassName());
            }
        };
        for (ASTNode aSTNode : astNodes) {
            ArrayList imports;
            if (!(aSTNode instanceof ClassNode)) continue;
            ModuleNode moduleNode = ((ClassNode)aSTNode).getModule();
            this.parse(moduleNode.getPackage());
            Map staticImports = moduleNode.getStaticImports();
            if (staticImports.size() > 0) {
                ArrayList staticImportNodes = new ArrayList(staticImports.values());
                Collections.sort(staticImportNodes, importNodeComparator);
                for (ImportNode importNode : staticImportNodes) {
                    this.parse(importNode);
                }
            }
            if ((imports = new ArrayList(moduleNode.getImports())).size() <= 0) continue;
            Collections.sort(imports, importNodeComparator);
            for (ImportNode importNode : imports) {
                this.parse(importNode);
            }
            this.printDoubleLineBreak();
        }
    }

    private void print(String string) {
        if (this.readyToIndent) {
            this.stringBuilder.append(this.currentIndent);
            this.readyToIndent = false;
            this.stringBuilder.trimToSize();
        }
        this.stringBuilder.append(string);
    }

    private void printLineBreak() {
        if (!this.stringBuilder.toString().endsWith("\n")) {
            this.print("\n");
        }
        this.readyToIndent = true;
    }

    private void printDoubleLineBreak() {
        String output = this.stringBuilder.toString();
        if (!output.endsWith("\n\n")) {
            if (output.endsWith("\n")) {
                this.print("\n");
            } else {
                this.print("\n\n");
            }
        }
        this.readyToIndent = true;
    }

    public void parseGroovyAstIntoScript(List<? extends ASTNode> astNodes) {
        this.importedTypes.clear();
        this.parsePackageAndImport(astNodes);
        for (ASTNode aSTNode : astNodes) {
            if (aSTNode instanceof BlockStatement) {
                this.parse((BlockStatement)aSTNode);
                this.printLineBreak();
                continue;
            }
            if (aSTNode instanceof ClassNode) {
                if (((ClassNode)aSTNode).isScriptBody()) {
                    for (MethodNode methodNode : ((ClassNode)aSTNode).getMethods()) {
                        if (methodNode.getName() == "run") continue;
                        this.parseMethod(methodNode);
                    }
                    continue;
                }
                this.parseClass((ClassNode)aSTNode);
                this.printLineBreak();
                continue;
            }
            if (!(aSTNode instanceof MethodNode)) continue;
            this.parseMethod((MethodNode)aSTNode);
        }
    }

    public void parseGroovyAstIntoClass(List<ASTNode> astNodes) throws Exception {
        this.importedTypes.clear();
        this.parsePackageAndImport(astNodes);
        for (ASTNode astNode : astNodes) {
            if (!(astNode instanceof ClassNode)) continue;
            this.parseClass((ClassNode)astNode);
        }
    }

    public static List<ASTNode> generateNewScript() {
        String scriptClassName = "script" + System.currentTimeMillis();
        GroovyCodeSource codeSource = new GroovyCodeSource("", scriptClassName + ".groovy", "/groovy/script");
        CompilationUnit cu = new CompilationUnit();
        cu.addSource(codeSource.getName(), "");
        cu.compile(CompilePhase.CONVERSION.getPhaseNumber());
        cu.getAST().getModules();
        ArrayList<ASTNode> astNodes = new ArrayList<ASTNode>();
        for (ModuleNode module : cu.getAST().getModules()) {
            if (module.getStatementBlock() != null) {
                astNodes.add((ASTNode)module.getStatementBlock());
            }
            for (ClassNode classNode : module.getClasses()) {
                astNodes.add((ASTNode)classNode);
            }
        }
        return astNodes;
    }

    public static Statement cloneStatement(Statement statement) {
        if (statement instanceof ExpressionStatement) {
            return GroovyParser.cloneExpressionStatement((ExpressionStatement)statement);
        }
        if (statement instanceof AssertStatement) {
            return GroovyParser.cloneAssertStatement((AssertStatement)statement);
        }
        if (statement instanceof BlockStatement) {
            return GroovyParser.cloneBlockStatement((BlockStatement)statement);
        }
        if (statement instanceof BreakStatement) {
            return GroovyParser.cloneBreakStatement((BreakStatement)statement);
        }
        if (statement instanceof CaseStatement) {
            return GroovyParser.cloneCaseStatement((CaseStatement)statement);
        }
        if (statement instanceof CatchStatement) {
            return GroovyParser.cloneCatchStatement((CatchStatement)statement);
        }
        if (statement instanceof ContinueStatement) {
            return GroovyParser.cloneContinueStatement((ContinueStatement)statement);
        }
        if (statement instanceof DoWhileStatement) {
            return GroovyParser.cloneDoWhileStatement((DoWhileStatement)statement);
        }
        if (statement instanceof ForStatement) {
            return GroovyParser.cloneForStatement((ForStatement)statement);
        }
        if (statement instanceof IfStatement) {
            return GroovyParser.cloneIfStatement((IfStatement)statement);
        }
        if (statement instanceof EmptyStatement) {
            return GroovyParser.cloneEmptyStatement((EmptyStatement)statement);
        }
        if (statement instanceof ReturnStatement) {
            return GroovyParser.cloneReturnStatement((ReturnStatement)statement);
        }
        if (statement instanceof SwitchStatement) {
            return GroovyParser.cloneSwitchStatement((SwitchStatement)statement);
        }
        if (statement instanceof SynchronizedStatement) {
            return GroovyParser.cloneSynchronizedStatement((SynchronizedStatement)statement);
        }
        if (statement instanceof ThrowStatement) {
            return GroovyParser.cloneThrowStatement((ThrowStatement)statement);
        }
        if (statement instanceof TryCatchStatement) {
            return GroovyParser.cloneTryCatchStatement((TryCatchStatement)statement);
        }
        if (statement instanceof WhileStatement) {
            return GroovyParser.cloneWhileStatement((WhileStatement)statement);
        }
        return null;
    }

    public static WhileStatement cloneWhileStatement(WhileStatement whileStatement) {
        return new WhileStatement(GroovyParser.cloneBooleanExpression(whileStatement.getBooleanExpression()), GroovyParser.cloneStatement(whileStatement.getLoopBlock()));
    }

    public static TryCatchStatement cloneTryCatchStatement(TryCatchStatement tryCatchStatement) {
        TryCatchStatement clonedTryCatchStatement = new TryCatchStatement(GroovyParser.cloneStatement(tryCatchStatement.getTryStatement()), GroovyParser.cloneStatement(tryCatchStatement.getFinallyStatement()));
        for (CatchStatement statement : tryCatchStatement.getCatchStatements()) {
            clonedTryCatchStatement.addCatch(GroovyParser.cloneCatchStatement(statement));
        }
        return clonedTryCatchStatement;
    }

    public static ThrowStatement cloneThrowStatement(ThrowStatement throwStatement) {
        return new ThrowStatement(GroovyParser.cloneExpression(throwStatement.getExpression()));
    }

    public static SynchronizedStatement cloneSynchronizedStatement(SynchronizedStatement synchronizedStatement) {
        return new SynchronizedStatement(GroovyParser.cloneExpression(synchronizedStatement.getExpression()), GroovyParser.cloneStatement(synchronizedStatement.getCode()));
    }

    public static SwitchStatement cloneSwitchStatement(SwitchStatement switchStatement) {
        ArrayList<CaseStatement> statementList = new ArrayList<CaseStatement>();
        for (CaseStatement statement : switchStatement.getCaseStatements()) {
            statementList.add(GroovyParser.cloneCaseStatement(statement));
        }
        return new SwitchStatement(GroovyParser.cloneExpression(switchStatement.getExpression()), statementList, GroovyParser.cloneStatement(switchStatement.getDefaultStatement()));
    }

    public static ReturnStatement cloneReturnStatement(ReturnStatement returnStatement) {
        return new ReturnStatement(GroovyParser.cloneExpression(returnStatement.getExpression()));
    }

    public static EmptyStatement cloneEmptyStatement(EmptyStatement emptyStatement) {
        return new EmptyStatement();
    }

    public static Statement cloneIfStatement(IfStatement ifStatement) {
        return new IfStatement(GroovyParser.cloneBooleanExpression(ifStatement.getBooleanExpression()), GroovyParser.cloneStatement(ifStatement.getIfBlock()), GroovyParser.cloneStatement(ifStatement.getElseBlock()));
    }

    public static ForStatement cloneForStatement(ForStatement forStatement) {
        return new ForStatement(forStatement.getVariable(), GroovyParser.cloneExpression(forStatement.getCollectionExpression()), GroovyParser.cloneStatement(forStatement.getLoopBlock()));
    }

    public static DoWhileStatement cloneDoWhileStatement(DoWhileStatement doWhileStatement) {
        return new DoWhileStatement(GroovyParser.cloneBooleanExpression(doWhileStatement.getBooleanExpression()), GroovyParser.cloneStatement(doWhileStatement.getLoopBlock()));
    }

    public static ContinueStatement cloneContinueStatement(ContinueStatement continueStatement) {
        return new ContinueStatement(continueStatement.getLabel());
    }

    public static CatchStatement cloneCatchStatement(CatchStatement catchStatement) {
        return new CatchStatement(catchStatement.getVariable(), GroovyParser.cloneStatement(catchStatement.getCode()));
    }

    public static CaseStatement cloneCaseStatement(CaseStatement caseStatement) {
        return new CaseStatement(GroovyParser.cloneExpression(caseStatement.getExpression()), GroovyParser.cloneStatement(caseStatement.getCode()));
    }

    public static BreakStatement cloneBreakStatement(BreakStatement breakStatement) {
        return new BreakStatement(breakStatement.getLabel());
    }

    public static BlockStatement cloneBlockStatement(BlockStatement blockStatement) {
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        for (Statement statement : blockStatement.getStatements()) {
            statementList.add(GroovyParser.cloneStatement(statement));
        }
        return new BlockStatement(statementList, blockStatement.getVariableScope());
    }

    public static AssertStatement cloneAssertStatement(AssertStatement assertStatement) {
        return new AssertStatement(GroovyParser.cloneBooleanExpression(assertStatement.getBooleanExpression()), GroovyParser.cloneExpression(assertStatement.getMessageExpression()));
    }

    public static ExpressionStatement cloneExpressionStatement(ExpressionStatement expressionStatement) {
        return new ExpressionStatement(GroovyParser.cloneExpression(expressionStatement.getExpression()));
    }

    public static Expression cloneExpression(Expression expression) {
        if (expression instanceof ArrayExpression) {
            return GroovyParser.cloneArrayExpression((ArrayExpression)expression);
        }
        if (expression instanceof MethodCallExpression) {
            return GroovyParser.cloneMethodCallExpression((MethodCallExpression)expression);
        }
        if (expression instanceof StaticMethodCallExpression) {
            return GroovyParser.cloneStaticMethodCallExpression((StaticMethodCallExpression)expression);
        }
        if (expression instanceof VariableExpression) {
            return GroovyParser.cloneVariableExpression((VariableExpression)expression);
        }
        if (expression instanceof ClassExpression) {
            return GroovyParser.cloneClassExpression((ClassExpression)expression);
        }
        if (expression instanceof ClosureExpression) {
            return GroovyParser.cloneClosureExpression((ClosureExpression)expression);
        }
        if (expression instanceof CastExpression) {
            return GroovyParser.cloneCastExpression((CastExpression)expression);
        }
        if (expression instanceof FieldExpression) {
            return GroovyParser.cloneFieldExpression((FieldExpression)expression);
        }
        if (expression instanceof PropertyExpression) {
            return GroovyParser.clonePropertyExpression((PropertyExpression)expression);
        }
        if (expression instanceof ConstantExpression) {
            return GroovyParser.cloneConstantExpression((ConstantExpression)expression);
        }
        if (expression instanceof ArgumentListExpression) {
            return GroovyParser.cloneArgumentListExpression((ArgumentListExpression)expression);
        }
        if (expression instanceof ClosureListExpression) {
            return GroovyParser.cloneClosureListExpression((ClosureListExpression)expression);
        }
        if (expression instanceof ListExpression) {
            return GroovyParser.cloneListExpression((ListExpression)expression);
        }
        if (expression instanceof MapExpression) {
            return GroovyParser.cloneMapExpression((MapExpression)expression);
        }
        if (expression instanceof MapEntryExpression) {
            return GroovyParser.cloneMapEntryExpression((MapEntryExpression)expression);
        }
        if (expression instanceof BooleanExpression) {
            return GroovyParser.cloneBooleanExpression((BooleanExpression)expression);
        }
        if (expression instanceof BinaryExpression) {
            return GroovyParser.cloneBinaryExpression((BinaryExpression)expression);
        }
        if (expression instanceof RangeExpression) {
            return GroovyParser.cloneRangeExpression((RangeExpression)expression);
        }
        if (expression instanceof PostfixExpression) {
            return GroovyParser.clonePostfixExpression((PostfixExpression)expression);
        }
        if (expression instanceof PrefixExpression) {
            return GroovyParser.clonePrefixExpression((PrefixExpression)expression);
        }
        if (expression instanceof SpreadExpression) {
            return GroovyParser.cloneSpreadExpression((SpreadExpression)expression);
        }
        if (expression instanceof SpreadMapExpression) {
            return GroovyParser.cloneSpreadMapExpression((SpreadMapExpression)expression);
        }
        if (expression instanceof TernaryExpression) {
            return GroovyParser.cloneTernaryExpression((TernaryExpression)expression);
        }
        if (expression instanceof TupleExpression) {
            return GroovyParser.cloneTupleExpression((TupleExpression)expression);
        }
        if (expression instanceof ConstructorCallExpression) {
            return GroovyParser.cloneConstructorCallExpression((ConstructorCallExpression)expression);
        }
        return null;
    }

    public static VariableExpression cloneVariableExpression(VariableExpression variableExpression) {
        return new VariableExpression(variableExpression.getText());
    }

    public static ClassExpression cloneClassExpression(ClassExpression classExpression) {
        return new ClassExpression(classExpression.getType());
    }

    public static ClosureExpression cloneClosureExpression(ClosureExpression closureExpression) {
        return new ClosureExpression(closureExpression.getParameters(), GroovyParser.cloneStatement(closureExpression.getCode()));
    }

    public static PropertyExpression clonePropertyExpression(PropertyExpression propertyExpression) {
        return new PropertyExpression(GroovyParser.cloneExpression(propertyExpression.getObjectExpression()), GroovyParser.cloneExpression(propertyExpression.getProperty()));
    }

    public static FieldExpression cloneFieldExpression(FieldExpression fieldExpression) {
        return new FieldExpression(fieldExpression.getField());
    }

    public static ConstantExpression cloneConstantExpression(ConstantExpression constantExpression) {
        return new ConstantExpression(constantExpression.getValue());
    }

    public static BooleanExpression cloneBooleanExpression(BooleanExpression booleanExpression) {
        if (booleanExpression instanceof NotExpression) {
            return new NotExpression(GroovyParser.cloneExpression(booleanExpression.getExpression()));
        }
        return new BooleanExpression(GroovyParser.cloneExpression(booleanExpression.getExpression()));
    }

    public static BinaryExpression cloneBinaryExpression(BinaryExpression binaryExpression) {
        return new BinaryExpression(GroovyParser.cloneExpression(binaryExpression.getLeftExpression()), binaryExpression.getOperation(), GroovyParser.cloneExpression(binaryExpression.getRightExpression()));
    }

    public static CastExpression cloneCastExpression(CastExpression castExpression) {
        return new CastExpression(castExpression.getType(), GroovyParser.cloneExpression(castExpression.getExpression()));
    }

    public static ArrayExpression cloneArrayExpression(ArrayExpression arrayExpression) {
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        for (Expression expression : arrayExpression.getExpressions()) {
            expressionList.add(GroovyParser.cloneExpression(expression));
        }
        ArrayList<Expression> sizeExpressionList = new ArrayList<Expression>();
        for (Expression expression : arrayExpression.getSizeExpression()) {
            sizeExpressionList.add(GroovyParser.cloneExpression(expression));
        }
        return new ArrayExpression(arrayExpression.getType(), expressionList, sizeExpressionList);
    }

    public static ListExpression cloneListExpression(ListExpression listExpression) {
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        for (Expression expression : listExpression.getExpressions()) {
            expressionList.add(GroovyParser.cloneExpression(expression));
        }
        return new ListExpression(expressionList);
    }

    public static ArgumentListExpression cloneArgumentListExpression(ArgumentListExpression argumentListExpression) {
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        for (Expression expression : argumentListExpression.getExpressions()) {
            expressionList.add(GroovyParser.cloneExpression(expression));
        }
        return new ArgumentListExpression(expressionList);
    }

    public static BitwiseNegationExpression cloneBitwiseNegationExpression(BitwiseNegationExpression bitwiseNegationExpression) {
        return new BitwiseNegationExpression(GroovyParser.cloneExpression(bitwiseNegationExpression.getExpression()));
    }

    public static MethodCallExpression cloneMethodCallExpression(MethodCallExpression methodCallExpression) {
        return new MethodCallExpression(GroovyParser.cloneExpression(methodCallExpression.getObjectExpression()), GroovyParser.cloneExpression(methodCallExpression.getMethod()), GroovyParser.cloneExpression(methodCallExpression.getArguments()));
    }

    public static StaticMethodCallExpression cloneStaticMethodCallExpression(StaticMethodCallExpression staticMethodCallExpression) {
        return new StaticMethodCallExpression(staticMethodCallExpression.getType(), staticMethodCallExpression.getMethod(), GroovyParser.cloneExpression(staticMethodCallExpression.getArguments()));
    }

    public static MethodPointerExpression cloneMethodPointerExpression(MethodPointerExpression methodPointerExpression) {
        return new MethodPointerExpression(GroovyParser.cloneExpression(methodPointerExpression.getExpression()), GroovyParser.cloneExpression(methodPointerExpression.getMethodName()));
    }

    public static ConstructorCallExpression cloneConstructorCallExpression(ConstructorCallExpression constructorCallExpression) {
        return new ConstructorCallExpression(constructorCallExpression.getType(), GroovyParser.cloneExpression(constructorCallExpression.getArguments()));
    }

    public static RangeExpression cloneRangeExpression(RangeExpression rangeExpression) {
        return new RangeExpression(GroovyParser.cloneExpression(rangeExpression.getFrom()), GroovyParser.cloneExpression(rangeExpression.getTo()), rangeExpression.isInclusive());
    }

    public static MapEntryExpression cloneMapEntryExpression(MapEntryExpression mapEntryExpression) {
        return new MapEntryExpression(GroovyParser.cloneExpression(mapEntryExpression.getKeyExpression()), GroovyParser.cloneExpression(mapEntryExpression.getValueExpression()));
    }

    public static MapExpression cloneMapExpression(MapExpression mapExpression) {
        ArrayList<MapEntryExpression> expressionList = new ArrayList<MapEntryExpression>();
        for (MapEntryExpression expression : mapExpression.getMapEntryExpressions()) {
            expressionList.add(GroovyParser.cloneMapEntryExpression(expression));
        }
        return new MapExpression(expressionList);
    }

    public static ClosureListExpression cloneClosureListExpression(ClosureListExpression closureListExpression) {
        LinkedList<Expression> expressionList = new LinkedList<Expression>();
        for (Expression expression : closureListExpression.getExpressions()) {
            expressionList.add(GroovyParser.cloneExpression(expression));
        }
        return new ClosureListExpression(expressionList);
    }

    public static PostfixExpression clonePostfixExpression(PostfixExpression postfixExpression) {
        return new PostfixExpression(GroovyParser.cloneExpression(postfixExpression.getExpression()), postfixExpression.getOperation());
    }

    public static PrefixExpression clonePrefixExpression(PrefixExpression prefixExpression) {
        return new PrefixExpression(prefixExpression.getOperation(), GroovyParser.cloneExpression(prefixExpression.getExpression()));
    }

    public static SpreadExpression cloneSpreadExpression(SpreadExpression spreadExpression) {
        return new SpreadExpression(GroovyParser.cloneExpression(spreadExpression.getExpression()));
    }

    public static SpreadMapExpression cloneSpreadMapExpression(SpreadMapExpression spreadMapExpression) {
        return new SpreadMapExpression(GroovyParser.cloneExpression(spreadMapExpression.getExpression()));
    }

    public static TernaryExpression cloneTernaryExpression(TernaryExpression ternaryExpression) {
        return new TernaryExpression(GroovyParser.cloneBooleanExpression(ternaryExpression.getBooleanExpression()), GroovyParser.cloneExpression(ternaryExpression.getTrueExpression()), GroovyParser.cloneExpression(ternaryExpression.getFalseExpression()));
    }

    public static TupleExpression cloneTupleExpression(TupleExpression tupleExpression) {
        LinkedList<Expression> expressionList = new LinkedList<Expression>();
        for (Expression expression : tupleExpression.getExpressions()) {
            expressionList.add(GroovyParser.cloneExpression(expression));
        }
        return new TupleExpression(expressionList);
    }

    public static MethodNode cloneMethodNode(MethodNode methodNode) {
        return new MethodNode(methodNode.getName(), methodNode.getModifiers(), methodNode.getReturnType(), methodNode.getParameters(), methodNode.getExceptions(), GroovyParser.cloneStatement(methodNode.getCode()));
    }
}

