/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.enums.windows;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public enum LocatorStrategy {
    ACCESSIBILITY_ID("Accessibility ID"),
    CLASS_NAME("Class Name"),
    NAME("Name"),
    TAG_NAME("Tag Name"),
    XPATH("XPATH");

    private final String locatorStrategy;

    private LocatorStrategy(String locatorStrategy) {
        this.locatorStrategy = locatorStrategy;
    }

    public String getLocatorStrategy() {
        return this.locatorStrategy;
    }

    public static String[] getStrategies() {
        ArrayList<String> strategies = new ArrayList<String>();
        LocatorStrategy[] locatorStrategyArray = LocatorStrategy.values();
        int n = locatorStrategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocatorStrategy str = locatorStrategyArray[n2];
            strategies.add(str.getLocatorStrategy());
            ++n2;
        }
        return strategies.toArray(new String[0]);
    }

    public static LocatorStrategy valueOfStrategy(String strategy) {
        if (StringUtils.isEmpty((CharSequence)strategy)) {
            return null;
        }
        LocatorStrategy[] locatorStrategyArray = LocatorStrategy.values();
        int n = locatorStrategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocatorStrategy str = locatorStrategyArray[n2];
            if (str.getLocatorStrategy().equals(strategy)) {
                return str;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Strategy: " + strategy + " not found");
    }
}

