/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.model;

import com.kms.katalon.core.logging.model.AbstractLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.MessageLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.model.FailureHandling;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TestStepLogRecord
extends AbstractLogRecord {
    private List<String> arguments;
    private String attachment;
    private FailureHandling flowControl;
    private int index;
    private boolean isIgnoredIfFailed;

    public TestStepLogRecord(String name) {
        super(name);
        this.setType("TEST_STEP");
    }

    public List<String> getArguments() {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        return this.arguments;
    }

    public void setArguments(List<String> args) {
        this.arguments = args;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    @Override
    public TestStatus getStatus() {
        TestStatus testStatus = super.getStatus();
        if (this.childRecords == null || this.childRecords.size() == 0) {
            return testStatus;
        }
        if (this.childRecords.size() == 1 && ((ILogRecord)this.childRecords.get(0)).getStatus().getStatusValue() == TestStatus.TestStatusValue.NOT_RUN) {
            testStatus.setStatusValue(TestStatus.TestStatusValue.NOT_RUN);
        }
        this.setMessage(((ILogRecord)this.childRecords.get(this.childRecords.size() - 1)).getMessage());
        ILogRecord[] iLogRecordArray = this.getChildRecords();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord logRecord = iLogRecordArray[n2];
            String childAttachment = null;
            if (logRecord instanceof TestStepLogRecord) {
                childAttachment = ((TestStepLogRecord)logRecord).getAttachment();
            } else if (logRecord instanceof MessageLogRecord) {
                childAttachment = ((MessageLogRecord)logRecord).getAttachment();
            }
            if (!StringUtils.isBlank((String)childAttachment)) {
                this.setAttachment(childAttachment);
            }
            ++n2;
        }
        if (this.isIgnoredIfFailed()) {
            testStatus.setStatusValue(TestStatus.TestStatusValue.PASSED);
        }
        return testStatus;
    }

    public FailureHandling getFlowControl() {
        return this.flowControl;
    }

    public void setFlowControl(FailureHandling flowControl) {
        this.flowControl = flowControl;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getIndexString() {
        int stepIndex = this.index;
        if (stepIndex == -1 && this.parentLogRecord != null) {
            return "";
        }
        if (this.parentLogRecord == null || !(this.parentLogRecord instanceof TestStepLogRecord)) {
            return String.valueOf(stepIndex);
        }
        String parentIndexString = ((TestStepLogRecord)this.parentLogRecord).getIndexString();
        Object parentIndexStringWithSeparator = StringUtils.isNotEmpty((String)parentIndexString) ? parentIndexString + "." : "";
        return (String)parentIndexStringWithSeparator + Integer.toString(stepIndex);
    }

    public boolean isIgnoredIfFailed() {
        return this.isIgnoredIfFailed;
    }

    public void setIgnoredIfFailed(boolean isIgnoredIfFailed) {
        this.isIgnoredIfFailed = isIgnoredIfFailed;
    }
}

