/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util.internal;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PathUtil {
    private static final String relativeSeparator = "/";
    private static final String windowSeparator = "\\";

    private PathUtil() {
    }

    public static String absoluteToRelativePath(String absolutePath, String projectFolderPath) {
        return PathUtil.getRelativePath(absolutePath, projectFolderPath);
    }

    public static String relativeToAbsolutePath(String relativePath, String projectFolderPath) {
        Path path = new File(relativePath).toPath();
        if (path.isAbsolute()) {
            return path.toAbsolutePath().toString();
        }
        Path projectPath = new File(projectFolderPath).toPath();
        return projectPath.resolve(path).normalize().toString();
    }

    private static String getRelativePath(String targetPath, String basePath) {
        String[] base = basePath.replace(windowSeparator, relativeSeparator).split(Pattern.quote(relativeSeparator), -1);
        String[] target = targetPath.replace(windowSeparator, relativeSeparator).split(Pattern.quote(relativeSeparator), 0);
        Object common = "";
        int commonIndex = 0;
        int i = 0;
        while (i < target.length && i < base.length) {
            if (!target[i].equals(base[i])) break;
            common = (String)common + target[i] + relativeSeparator;
            ++commonIndex;
            ++i;
        }
        if (commonIndex == 0) {
            return targetPath;
        }
        Object relative = "";
        if (base.length != commonIndex) {
            int numDirsUp = base.length - commonIndex;
            int i2 = 1;
            while (i2 <= numDirsUp) {
                relative = (String)relative + "../";
                ++i2;
            }
        }
        relative = (String)relative + targetPath.replace(windowSeparator, relativeSeparator).substring(((String)common).length());
        return relative;
    }

    public static URL getUrl(String rawUrl, String defaultProtocol) throws MalformedURLException, URISyntaxException {
        URL url = null;
        try {
            url = new URL(rawUrl);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                url = new URI(rawUrl).toURL();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                url = new URI(defaultProtocol + "://" + rawUrl).toURL();
            }
            catch (URISyntaxException uRISyntaxException) {
                url = Paths.get(rawUrl, new String[0]).toUri().toURL();
            }
        }
        return url;
    }

    public static String getRelativePathForLog(String fileName) {
        int reportPathIndex;
        Object reportPath = RunConfiguration.getReportFolder();
        if (StringUtils.isEmpty((String)reportPath)) {
            return fileName;
        }
        if (!((String)reportPath).endsWith(File.separator)) {
            reportPath = (String)reportPath + File.separator;
        }
        if ((reportPathIndex = fileName.indexOf((String)reportPath)) != 0) {
            return fileName;
        }
        return fileName.replace((CharSequence)reportPath, "");
    }

    public static File ensureDirectory(File file, boolean isFile) throws IOException {
        if (file == null) {
            throw new IOException(StringConstants.UTIL_EXC_FILE_NOT_NULL);
        }
        if (file.exists()) {
            return file;
        }
        if (!PathUtil.isValidFile(file)) {
            throw new IOException(MessageFormat.format(StringConstants.UTIL_EXC_FILE_PATH_INVALID, file.getAbsolutePath()));
        }
        if (isFile) {
            File parent = file.getParentFile();
            if (parent == null || parent.exists()) {
                return file;
            }
            parent.mkdirs();
        } else {
            file.mkdirs();
        }
        return file;
    }

    private static boolean isValidFile(File file) {
        try {
            Paths.get(file.getAbsolutePath(), new String[0]);
            return true;
        }
        catch (InvalidPathException invalidPathException) {
            return false;
        }
    }

    public static String extractFolderName(String path) {
        String folderName = path.substring(path.lastIndexOf(47) + 1);
        if (folderName.endsWith(relativeSeparator)) {
            folderName = folderName.substring(0, folderName.length() - 1);
        }
        return folderName;
    }

    public static String extractFolderTooltip(String path) {
        return path.endsWith(relativeSeparator) ? path.substring(0, path.length() - 1) : path;
    }
}

