/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.settings.composites;

import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.katalon.plugin.smart_xpath.logger.LoggerSingleton;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.execution.setting.WebUiExecutionSettingStore;
import com.kms.katalon.util.collections.Pair;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class AttributesSelectionComposite
extends Composite {
    private final String MSG_PROPERTY_NAME_IS_EXISTED = "Property name is existed!";
    private final String COL_LBL_DETECT_OBJECT_BY = "Detect object by?";
    private TableViewer tvProperty;
    private ToolItem tiPropertyDelete;
    private List<Pair<String, Boolean>> selectedAttributes = Collections.emptyList();

    public AttributesSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.createContents();
    }

    private void createContents() {
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createAttributeTableToolbar(this);
        this.createAttributesTable(this);
    }

    private Control createAttributeTableToolbar(Composite parent) {
        Composite compositeUpperAttributeTable = new Composite(parent, 0);
        compositeUpperAttributeTable.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeUpperAttributeTable.setLayout((Layout)new GridLayout(1, false));
        Button resetDefault = new Button(compositeUpperAttributeTable, 64);
        resetDefault.setLayoutData((Object)new GridData(1, 4, false, false));
        resetDefault.setText(StringConstants.RESET_DEFAULT);
        resetDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WebUiExecutionSettingStore store = WebUiExecutionSettingStore.getStore();
                    AttributesSelectionComposite.this.setInput(store.getDefaultCapturedTestObjectAttributeLocators());
                    AttributesSelectionComposite.this.handleSelectionChange(null);
                }
                catch (IOException exception) {
                    LoggerSingleton.logError(exception);
                }
            }
        });
        Label lblDragDropXPath = new Label(compositeUpperAttributeTable, 0);
        lblDragDropXPath.setText(SmartXPathMessageConstants.LBL_TIPS_FOR_BASIC_TEST_DESIGN_SETTING);
        Composite compositeAttributeTableToolBar = new Composite(parent, 0);
        compositeAttributeTableToolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeAttributeTableToolBar.setLayout((Layout)new FillLayout(256));
        ToolBar tb = new ToolBar(compositeAttributeTableToolBar, 0x820000);
        tb.setForeground(ColorUtil.getToolBarForegroundColor());
        ToolItem tiPropertyAdd = new ToolItem(tb, 8);
        tiPropertyAdd.setText(StringConstants.ADD);
        tiPropertyAdd.setImage(ImageConstants.IMG_16_ADD);
        this.tiPropertyDelete = new ToolItem(tb, 8);
        this.tiPropertyDelete.setText(StringConstants.DELETE);
        this.tiPropertyDelete.setImage(ImageConstants.IMG_16_REMOVE);
        this.tiPropertyDelete.setEnabled(false);
        ToolItem tiPropertyClear = new ToolItem(tb, 8);
        tiPropertyClear.setText(StringConstants.CLEAR);
        tiPropertyClear.setImage(ImageConstants.IMG_16_CLEAR);
        tiPropertyAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Pair element = Pair.of((Object)StringConstants.EMPTY, (Object)true);
                AttributesSelectionComposite.this.selectedAttributes.add((Pair<String, Boolean>)element);
                AttributesSelectionComposite.this.tvProperty.refresh();
                if (OSUtil.isMacBigSurOrLater()) {
                    AttributesSelectionComposite.this.tvProperty.getTable().redraw();
                }
                AttributesSelectionComposite.this.tvProperty.editElement((Object)element, 0);
            }
        });
        this.tiPropertyDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int[] selectedPropertyIndices = AttributesSelectionComposite.this.tvProperty.getTable().getSelectionIndices();
                if (selectedPropertyIndices.length == 0) {
                    return;
                }
                List selectedProperties = Arrays.stream(selectedPropertyIndices).boxed().map(i -> AttributesSelectionComposite.this.selectedAttributes.get((int)i)).collect(Collectors.toList());
                AttributesSelectionComposite.this.selectedAttributes.removeAll(selectedProperties);
                AttributesSelectionComposite.this.tvProperty.refresh();
                if (OSUtil.isMacBigSurOrLater()) {
                    AttributesSelectionComposite.this.tvProperty.getTable().redraw();
                }
                AttributesSelectionComposite.this.handleSelectionChange((TypedEvent)event);
            }
        });
        tiPropertyClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AttributesSelectionComposite.this.selectedAttributes.clear();
                AttributesSelectionComposite.this.tvProperty.refresh();
                if (OSUtil.isMacBigSurOrLater()) {
                    AttributesSelectionComposite.this.tvProperty.getTable().redraw();
                }
                AttributesSelectionComposite.this.handleSelectionChange((TypedEvent)event);
            }
        });
        return compositeAttributeTableToolBar;
    }

    private Control createAttributesTable(Composite parent) {
        Composite tablePropertyComposite = new Composite(parent, 0);
        GridData ldTableComposite = new GridData(4, 4, true, true);
        ldTableComposite.minimumHeight = 70;
        ldTableComposite.heightHint = 300;
        tablePropertyComposite.setLayoutData((Object)ldTableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tablePropertyComposite.setLayout((Layout)tableColumnLayout);
        this.tvProperty = new TableViewer(tablePropertyComposite, 68354);
        this.tvProperty.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        final Table tProperty = this.tvProperty.getTable();
        tProperty.setHeaderVisible(true);
        tProperty.setLinesVisible(ControlUtils.shouldLineVisble((Display)tProperty.getDisplay()));
        TableViewerColumn cvPropertyName = new TableViewerColumn(this.tvProperty, 16384);
        TableColumn cName = cvPropertyName.getColumn();
        cName.setText(StringConstants.NAME);
        cvPropertyName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)((Pair)element).getLeft();
            }
        });
        cvPropertyName.setEditingSupport(new EditingSupport(cvPropertyName.getViewer()){

            protected void setValue(Object element, Object value) {
                boolean isExisted;
                String newName = String.valueOf(value);
                if (StringUtils.isBlank((CharSequence)newName)) {
                    AttributesSelectionComposite.this.selectedAttributes.remove(element);
                    AttributesSelectionComposite.this.tvProperty.refresh();
                    return;
                }
                if (StringUtils.equals((CharSequence)((CharSequence)((Pair)element).getLeft()), (CharSequence)newName)) {
                    return;
                }
                boolean bl = isExisted = AttributesSelectionComposite.this.selectedAttributes.stream().filter(i -> ((String)i.getLeft()).equals(newName)).count() > 0L;
                if (isExisted) {
                    MessageDialog.openWarning((Shell)AttributesSelectionComposite.this.getShell(), (String)StringConstants.WARN, (String)"Property name is existed!");
                    AttributesSelectionComposite.this.tvProperty.refresh();
                    return;
                }
                ((Pair)element).setLeft((Object)newName);
                AttributesSelectionComposite.this.tvProperty.update(element, null);
                AttributesSelectionComposite.this.handleSelectionChange(null);
            }

            protected Object getValue(Object element) {
                return ((Pair)element).getLeft();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)tProperty);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn cvPropertySelected = new TableViewerColumn(this.tvProperty, 0x1000000);
        TableColumn cSelected = cvPropertySelected.getColumn();
        cSelected.setText("Detect object by?");
        cvPropertySelected.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object property = cell.getElement();
                if (!(property instanceof Pair)) {
                    return;
                }
                Boolean isSelected = (Boolean)((Pair)property).getRight();
                ((TableItem)cell.getViewerRow().getItem()).setChecked(isSelected.booleanValue());
                tProperty.redraw();
            }
        });
        cvPropertySelected.setEditingSupport(new EditingSupport(cvPropertySelected.getViewer()){

            protected void setValue(Object element, Object value) {
                ((Pair)element).setRight((Object)((Boolean)value));
                AttributesSelectionComposite.this.tvProperty.update(element, null);
                AttributesSelectionComposite.this.handleSelectionChange(null);
            }

            protected Object getValue(Object element) {
                return ((Pair)element).getRight();
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor();
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        tableColumnLayout.setColumnData((Widget)cName, (ColumnLayoutData)new ColumnWeightData(80, 100));
        tableColumnLayout.setColumnData((Widget)cSelected, (ColumnLayoutData)new ColumnWeightData(20, 100));
        tProperty.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 1) {
                    Pair data = (Pair)((TableItem)event.item).getData();
                    Image tmpImage = AttributesSelectionComposite.this.getCheckboxSymbol((Boolean)data.getRight());
                    int tmpWidth = 0;
                    int tmpHeight = 0;
                    int tmpX = 0;
                    int tmpY = 0;
                    tmpWidth = tProperty.getColumn(event.index).getWidth();
                    tmpHeight = ((TableItem)event.item).getBounds().height;
                    tmpX = tmpImage.getBounds().width;
                    tmpX = tmpWidth / 2 - tmpX / 2;
                    tmpY = tmpImage.getBounds().height;
                    tmpY = tmpHeight / 2 - tmpY / 2;
                    tmpX = tmpX <= 0 ? event.x : (tmpX += event.x);
                    tmpY = tmpY <= 0 ? event.y : (tmpY += event.y);
                    event.gc.drawImage(tmpImage, tmpX, tmpY);
                }
            }
        });
        this.tvProperty.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)AttributesSelectionComposite.this.tvProperty.getSelection();
                AttributesSelectionComposite.this.tiPropertyDelete.setEnabled(selection != null && selection.getFirstElement() != null);
            }
        });
        return tablePropertyComposite;
    }

    protected Image getCheckboxSymbol(boolean isChecked) {
        return isChecked ? ImageManager.getImage((String)"checkbox_checked_16.png") : ImageManager.getImage((String)"checkbox_unchecked_16.png");
    }

    public void setInput(List<Pair<String, Boolean>> input) {
        this.selectedAttributes = input;
        this.tvProperty.setInput(this.selectedAttributes);
        if (OSUtil.isMacBigSurOrLater()) {
            this.tvProperty.getTable().redraw();
        }
    }

    public List<Pair<String, Boolean>> getInput() {
        List emptyAttributeItems = this.selectedAttributes.stream().filter(item -> ((String)item.getLeft()).isEmpty()).collect(Collectors.toList());
        this.selectedAttributes.removeAll(emptyAttributeItems);
        this.selectedAttributes.stream().forEach(attrI -> attrI.setLeft((Object)StringUtils.trim((String)((String)attrI.getLeft()))));
        return this.selectedAttributes;
    }

    public boolean compareInput(List<Pair<String, Boolean>> selectedAttributes) {
        List<Pair<String, Boolean>> _selectedAttributes = this.getInput();
        return _selectedAttributes != null && _selectedAttributes.equals(selectedAttributes);
    }

    private void handleSelectionChange(TypedEvent selectionEvent) {
        this.dispatchSelectionEvent(selectionEvent);
    }

    private void dispatchSelectionEvent(TypedEvent selectionEvent) {
        this.notifyListeners(13, null);
        this.notifyListeners(14, null);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((EventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    static /* synthetic */ List access$0(AttributesSelectionComposite attributesSelectionComposite) {
        return attributesSelectionComposite.selectedAttributes;
    }
}

