/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.platform.internal.ui;

import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.ui.TestExplorerActionService;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;

public class TestExplorerActionServiceImpl
implements TestExplorerActionService {
    public void refreshFolder(com.katalon.platform.api.model.ProjectEntity project, com.katalon.platform.api.model.FolderEntity folder) throws ResourceException {
        try {
            ProjectEntity projectEntity = ProjectController.getInstance().getProject(project.getId());
            if (projectEntity == null) {
                throw new ResourceException(MessageFormat.format("Project {0} doesn't exist", project.getId()));
            }
            FolderEntity parentFolderEntity = FolderController.getInstance().getFolderByDisplayId(projectEntity, folder.getId());
            if (parentFolderEntity == null) {
                throw new ResourceException(MessageFormat.format("Folder {0} doesn't exist", folder.getId()));
            }
            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)TreeEntityUtil.getFolderTreeEntity((FolderEntity)parentFolderEntity));
        }
        catch (ControllerException e) {
            throw new ResourceException("Could not refresh folder", (Exception)((Object)e));
        }
    }

    public void selectTestCases(com.katalon.platform.api.model.ProjectEntity project, List<com.katalon.platform.api.model.TestCaseEntity> testCases) throws ResourceException {
        try {
            ProjectEntity projectEntity = ProjectController.getInstance().getProject(project.getId());
            if (projectEntity == null) {
                throw new ResourceException(MessageFormat.format("Project {0} doesn't exist", project.getId()));
            }
            Object[] testCaseTrees = testCases.stream().map(tc -> {
                try {
                    return TestCaseController.getInstance().getTestCaseByDisplayId(tc.getId());
                }
                catch (ControllerException controllerException) {
                    return null;
                }
            }).filter(entity -> entity != null).map(entity -> {
                try {
                    return TreeEntityUtil.getTestCaseTreeEntity((TestCaseEntity)entity, (ProjectEntity)projectEntity);
                }
                catch (Exception exception) {
                    return null;
                }
            }).filter(treeEntity -> treeEntity != null).collect(Collectors.toList()).toArray();
            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/SET_SELECTED_ITEMS", (Object)testCaseTrees);
        }
        catch (ControllerException e) {
            throw new ResourceException("Could not set selected test cases on Tests Explorer ", (Exception)((Object)e));
        }
    }
}

