/*
 * Decompiled with CFR 0.152.
 */
package jd.ide.eclipse.editors;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jd.core.v1.ClassFileToJavaSourceDecompiler;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.api.printer.Printer;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.BaseDecompilerSourceMapper;
import org.sf.feeling.decompiler.jd.decompiler.JDCorePrinter;
import org.sf.feeling.decompiler.jd.decompiler.JDCoreZipLoader;

public abstract class JDSourceMapper
extends BaseDecompilerSourceMapper {
    private static final String JAVA_CLASS_SUFFIX = ".class";
    private static final String JAVA_SOURCE_SUFFIX = ".java";
    private static final int JAVA_SOURCE_SUFFIX_LENGTH = 5;
    private static JDCoreZipLoader.EntriesCache entriesCache = null;
    private File basePath;

    public JDSourceMapper(File basePath, IPath sourcePath, String sourceRootPath, Map<String, String> options) {
        super(sourcePath, sourceRootPath, options);
        this.basePath = basePath;
    }

    public char[] findSource(String javaSourcePath) {
        char[] source = null;
        if (this.rootPaths == null) {
            source = super.findSource(javaSourcePath);
        } else {
            Iterator iterator = this.rootPaths.iterator();
            while (iterator.hasNext() && source == null) {
                String sourcesRootPath = (String)iterator.next();
                source = super.findSource(String.valueOf(sourcesRootPath) + '/' + javaSourcePath);
            }
        }
        if (source == null && javaSourcePath.endsWith(JAVA_SOURCE_SUFFIX)) {
            String classPath = String.valueOf(javaSourcePath.substring(0, javaSourcePath.length() - 5)) + JAVA_CLASS_SUFFIX;
            try {
                File decompilePath = this.basePath.getAbsoluteFile();
                if (decompilePath.isFile()) {
                    String result = this.decompile(decompilePath.toString(), classPath);
                    if (result != null) {
                        source = result.toCharArray();
                    }
                } else {
                    JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.sf.feeling.decompiler", 0, "Unable to decompile: " + decompilePath + " is not a valid file.", null));
                }
            }
            catch (Exception e) {
                JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.sf.feeling.decompiler", 0, e.getMessage(), (Throwable)e));
            }
        }
        return source;
    }

    public String decompile(String basePath, String classPath) throws Exception {
        IPreferenceStore store = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean realignmentLineNumber = store.getBoolean("jd.ide.eclipse.prefs.RealignLineNumbers");
        boolean unicodeEscape = false;
        boolean showLineNumbers = store.getBoolean("jd.ide.eclipse.prefs.DisplayLineNumbers");
        TreeMap<String, Boolean> configuration = new TreeMap<String, Boolean>();
        configuration.put("realignLineNumbers", realignmentLineNumber);
        if (classPath.endsWith(JAVA_CLASS_SUFFIX)) {
            classPath = classPath.substring(0, classPath.length() - 6);
        }
        Path jarPath = Paths.get(basePath, new String[0]);
        JDCoreZipLoader.EntriesCache cache = null;
        if (entriesCache != null && entriesCache.isForTheSameFile(jarPath)) {
            cache = entriesCache;
        }
        Throwable throwable = null;
        Object var11_12 = null;
        try (JDCoreZipLoader loader = new JDCoreZipLoader(jarPath, cache);){
            JDCorePrinter printer = new JDCorePrinter(unicodeEscape, showLineNumbers);
            ClassFileToJavaSourceDecompiler decompiler = new ClassFileToJavaSourceDecompiler();
            decompiler.decompile((Loader)loader, (Printer)printer, classPath, configuration);
            entriesCache = loader.getEntriesCache();
            return printer.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getVersion() {
        return "1.1.3";
    }
}

