/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.controls;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class FileInput
extends Composite {
    private Label label;
    private int style;
    private String filePath;
    private String dialogTitle;
    private String[] filterExtensions;
    private String[] filterNames;
    private String filterPath;

    public FileInput(Composite parent, int style) {
        super(parent, 0);
        this.style = style;
        this.init(this);
    }

    private void init(Composite parent) {
        Composite container = ComponentBuilder.gridContainer(parent, 2).fillHorizontal().gridSpacing(ComponentUtil.applyZoom(5)).build();
        ComponentBuilder.canvas(container).text("Choose file").autoSizeMD(100).bold().secondaryButton().noFillHorizontal().onClick(event -> this.triggerOpenFile()).build();
        this.label = ComponentBuilder.label(container, this.style).cursorPointer().text("No file choosen").contentAlign(16384).color(ColorUtil.getColor("#919299")).hoverColor(ColorUtil.getColor("#aaa")).activeColor(ColorUtil.getColor("#999")).fillHorizontal().onClick(event -> this.triggerOpenFile()).build();
    }

    private void triggerOpenFile() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4);
        fileDialog.setFilterExtensions(this.filterExtensions);
        fileDialog.setFilterNames(this.filterNames);
        fileDialog.setFilterPath(this.filterPath);
        fileDialog.setText(this.dialogTitle);
        String filePath = StringUtils.defaultString((String)fileDialog.open());
        this.setText(filePath);
        ComponentEventUtil.triggerModifyEvent((Widget)this, filePath);
    }

    public FileInput setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
        return this;
    }

    public FileInput setFilterPath(String filterPath) {
        this.filterPath = filterPath;
        return this;
    }

    public FileInput setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
        return this;
    }

    public FileInput setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
        return this;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public void setMessage(String message) {
        this.label.setText(message);
    }

    public String getText() {
        return this.filePath;
    }

    public void setText(String text) {
        String shortenText = ComponentDataUtil.getShortenText(text, (Control)this.label);
        this.label.setText(StringUtils.isBlank((String)shortenText) ? "No file choosen" : shortenText);
        this.filePath = text;
    }
}

