/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.jdt.groovy.internal.compiler.GroovyClassLoaderFactory;
import org.codehaus.jdt.groovy.internal.compiler.ast.AbortResolutionException;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyEclipseBug;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTAnnotationNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNodeBuilder;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.builder.AbortIncrementalBuildException;

public class JDTResolver
extends ResolveVisitor {
    private static final boolean DEBUG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.codehaus.groovy.eclipse.core/debug/resolver"));
    private static final int BOOLEAN_LENGTH = "boolean".length();
    private static final Map<String, ClassNode> COMMON_TYPES;
    public static boolean recordInstances;
    public static List<JDTResolver> instances;
    private GroovyCompilationUnitScope compilationUnitScope;
    private Map<TypeBinding, JDTClassNode> inProgress;
    private Map<TypeBinding, JDTClassNode> nodeCache;
    private Map<String, Set<String>> unresolvables;
    private Set<ClassNode> resolvedClassNodes;

    static {
        HashMap<String, ClassNode> commonTypes = new HashMap<String, ClassNode>();
        commonTypes.put("boolean", ClassHelper.boolean_TYPE);
        commonTypes.put("byte", ClassHelper.byte_TYPE);
        commonTypes.put("char", ClassHelper.char_TYPE);
        commonTypes.put("double", ClassHelper.double_TYPE);
        commonTypes.put("float", ClassHelper.float_TYPE);
        commonTypes.put("int", ClassHelper.int_TYPE);
        commonTypes.put("long", ClassHelper.long_TYPE);
        commonTypes.put("short", ClassHelper.short_TYPE);
        commonTypes.put("void", ClassHelper.VOID_TYPE);
        commonTypes.put("java.lang.Boolean", ClassHelper.Boolean_TYPE);
        commonTypes.put("java.lang.Byte", ClassHelper.Byte_TYPE);
        commonTypes.put("java.lang.Character", ClassHelper.Character_TYPE);
        commonTypes.put("java.lang.Double", ClassHelper.Double_TYPE);
        commonTypes.put("java.lang.Float", ClassHelper.Float_TYPE);
        commonTypes.put("java.lang.Integer", ClassHelper.Integer_TYPE);
        commonTypes.put("java.lang.Long", ClassHelper.Long_TYPE);
        commonTypes.put("java.lang.Short", ClassHelper.Short_TYPE);
        commonTypes.put("java.lang.Void", ClassHelper.void_WRAPPER_TYPE);
        commonTypes.put("java.lang.Number", ClassHelper.Number_TYPE);
        commonTypes.put("java.lang.Object", ClassHelper.OBJECT_TYPE);
        commonTypes.put("java.lang.String", ClassHelper.STRING_TYPE);
        COMMON_TYPES = Collections.unmodifiableMap(commonTypes);
    }

    private void log(String string) {
        System.out.printf("JDTResolver@%x[%d]: %s%n", System.identityHashCode((Object)this), Thread.currentThread().getId(), string);
    }

    private void log(String string, ClassNode type, boolean foundit) {
        this.log(String.valueOf(string) + " " + type.getName() + "? " + foundit);
    }

    public static JDTClassNode getCachedNode(String name) {
        for (JDTResolver instance : instances) {
            JDTClassNode node = JDTResolver.getCachedNode(instance, name);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static JDTClassNode getCachedNode(JDTResolver instance, String name) {
        for (JDTClassNode nodeFromCache : instance.nodeCache.values()) {
            if (!name.equals(String.valueOf(nodeFromCache.getJdtBinding().readableName()))) continue;
            return nodeFromCache;
        }
        return null;
    }

    public GroovyCompilationUnitScope getScope() {
        return this.compilationUnitScope;
    }

    public JDTResolver(CompilationUnit compUnit) {
        super(compUnit);
        if (recordInstances) {
            if (instances == null) {
                instances = new ArrayList<JDTResolver>();
            }
            instances.add(this);
        }
    }

    public void record(GroovyTypeDeclaration typeDecl) {
        GroovyTypeDeclaration[] anonymousTypes;
        int n;
        typeDecl.getClassNode().putNodeMetaData(GroovyTypeDeclaration.class, (Object)typeDecl);
        TypeDeclaration[] memberTypes = typeDecl.memberTypes;
        if (memberTypes != null) {
            TypeDeclaration[] typeDeclarationArray = memberTypes;
            n = memberTypes.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration memberType = typeDeclarationArray[n2];
                this.record((GroovyTypeDeclaration)memberType);
                ++n2;
            }
        }
        if ((anonymousTypes = typeDecl.getAnonymousTypes()) != null) {
            GroovyTypeDeclaration[] groovyTypeDeclarationArray = anonymousTypes;
            int n3 = anonymousTypes.length;
            n = 0;
            while (n < n3) {
                GroovyTypeDeclaration anonymousType = groovyTypeDeclarationArray[n];
                this.record(anonymousType);
                ++n;
            }
        }
    }

    public void startResolving(ClassNode classNode, SourceUnit sourceUnit) {
        if (this.resolvedClassNodes == null) {
            this.resolvedClassNodes = new HashSet<ClassNode>();
            this.unresolvables = new HashMap<String, Set<String>>();
            this.inProgress = new IdentityHashMap<TypeBinding, JDTClassNode>();
            this.nodeCache = new IdentityHashMap<TypeBinding, JDTClassNode>();
        }
        try {
            try {
                Set names = this.unresolvables.computeIfAbsent(classNode.getModule().getMainClassName(), x -> new HashSet());
                Iterator nodes = classNode.getInnerClasses();
                while (nodes.hasNext()) {
                    String name = ((ClassNode)nodes.next()).getNameWithoutPackage();
                    name = name.substring(name.lastIndexOf(36) + 1);
                    names.remove(name);
                }
                this.compilationUnitScope = (GroovyCompilationUnitScope)((Object)classNode.getNodeMetaData(GroovyCompilationUnitScope.class));
                super.startResolving(classNode, sourceUnit);
            }
            catch (AbortResolutionException abortResolutionException) {
                this.resetSourceUnit();
                assert (classNode.getNodeMetaData(GroovyTypeDeclaration.class) == null);
            }
        }
        finally {
            this.resetSourceUnit();
            assert (classNode.getNodeMetaData(GroovyTypeDeclaration.class) == null);
        }
    }

    protected boolean commencingResolution() {
        GroovyTypeDeclaration typeDecl = (GroovyTypeDeclaration)((Object)this.currentClass.getNodeMetaData(GroovyTypeDeclaration.class));
        this.currentClass.removeNodeMetaData(GroovyTypeDeclaration.class);
        if (typeDecl != null) {
            this.currentClass.removeNodeMetaData(GroovyCompilationUnitScope.class);
            this.compilationUnitScope = null;
            if (typeDecl.scope == null) {
                if (typeDecl.hasErrors()) {
                    return false;
                }
                throw new GroovyEclipseBug("commencingResolution failed: declaration found, but unexpectedly found no scope for " + this.currentClass.getName());
            }
            this.compilationUnitScope = (GroovyCompilationUnitScope)typeDecl.scope.compilationUnitScope();
            this.currentClass.putNodeMetaData(GroovyCompilationUnitScope.class, (Object)this.compilationUnitScope);
            if (DEBUG) {
                this.log("commencing resolution for " + this.currentClass.getName());
            }
            if (this.currentClass.getOuterClass() == null) {
                this.compilationUnitScope.verifyMethods(this.compilationUnitScope.environment.methodVerifier());
                typeDecl.resolve(this.compilationUnitScope);
            }
            return true;
        }
        if (this.resolvedClassNodes.contains(this.currentClass)) {
            return false;
        }
        if (this.compilationUnitScope != null) {
            TypeDeclaration[] typeDeclarationArray = this.compilationUnitScope.referenceContext.types;
            int n = this.compilationUnitScope.referenceContext.types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration t = typeDeclarationArray[n2];
                if (this.currentClass == ((GroovyTypeDeclaration)t).getClassNode()) {
                    return !t.hasErrors();
                }
                ++n2;
            }
        }
        throw new GroovyEclipseBug("commencingResolution failed: no declaration found for class " + this.currentClass);
    }

    protected void finishedResolution() {
        this.resolvedClassNodes.add(this.currentClass);
        this.currentClass.removeNodeMetaData(GroovyCompilationUnitScope.class);
    }

    public synchronized void cleanUp() {
        if (this.inProgress != null) {
            this.inProgress.clear();
        }
        this.currentClass = null;
        this.resetVariableScope();
        this.setClassNodeResolver(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public ClassNode resolve(String name) {
        ClassNode commonType;
        if ((name.charAt(0) == 'j' || name.length() <= BOOLEAN_LENGTH) && (commonType = COMMON_TYPES.get(name)) != null) {
            return commonType;
        }
        int i = 0;
        while (name.charAt(i) == '[') {
            ++i;
        }
        if (i > 0) {
            name = name.substring(i + 1, name.length() - 1);
            ClassNode type = this.resolve(name);
            while (i > 0) {
                type = type.makeArray();
                --i;
            }
            return type;
        }
        i = name.indexOf(60);
        if (i > 0) {
            name = name.substring(0, i);
        }
        if (name.indexOf(63) < 0) {
            Set unresolvable;
            for (ClassNode node : this.resolvedClassNodes) {
                if (!node.getName().equals(name)) continue;
                return node;
            }
            List modules = this.compilationUnit.getAST().getModules();
            if (!(modules.isEmpty() || ((ModuleNode)modules.get(0)).getClasses().isEmpty() || (unresolvable = this.unresolvables.computeIfAbsent(((ModuleNode)modules.get(0)).getMainClassName(), x -> new HashSet())).contains(name))) {
                JDTResolver jDTResolver = this;
                synchronized (jDTResolver) {
                    ClassNode previousClass = this.currentClass;
                    try {
                        this.currentClass = (ClassNode)((ModuleNode)modules.get(0)).getClasses().get(0);
                        ClassNode type = ClassHelper.makeWithoutCaching((String)name);
                        if (super.resolve(type, true, true, true)) {
                            ClassNode classNode = type.redirect();
                            return classNode;
                        }
                        unresolvable.add(name);
                    }
                    finally {
                        this.currentClass = previousClass;
                    }
                }
            }
        }
        return ClassHelper.OBJECT_TYPE;
    }

    protected boolean resolve(ClassNode type, boolean testModuleImports, boolean testDefaultImports, boolean testNestedClasses) {
        ClassNode commonRedirect;
        String name = type.getName();
        if (name.indexOf(63) != -1) {
            return false;
        }
        if ((name.charAt(0) == 'j' || name.length() <= BOOLEAN_LENGTH) && (commonRedirect = COMMON_TYPES.get(name)) != null) {
            type.setRedirect(commonRedirect);
            return true;
        }
        Set<String> unresolvable = this.unresolvables.get(this.currentClass.getModule().getMainClassName());
        if (unresolvable.contains(name)) {
            return false;
        }
        boolean b = super.resolve(type, testModuleImports, testDefaultImports, testNestedClasses);
        if (!b) {
            unresolvable.add(name);
        }
        return b;
    }

    protected boolean resolveNestedClass(ClassNode type) {
        boolean resolved = super.resolveNestedClass(type);
        this.recordDependency(type.getName());
        if (DEBUG) {
            this.log("resolveNestedClass", type, resolved);
        }
        return resolved;
    }

    protected boolean resolveFromModule(ClassNode type, boolean testModuleImports) {
        ReferenceBinding binding;
        AccessRestriction restriction;
        boolean resolved = super.resolveFromModule(type, testModuleImports);
        this.recordDependency(type.getName());
        if (DEBUG) {
            this.log("resolveFromModule", type, resolved);
        }
        if (resolved && type.redirect() instanceof JDTClassNode && ((JDTClassNode)type.redirect()).getJdtBinding().hasRestrictedAccess() && (restriction = this.compilationUnitScope.environment.getAccessRestriction((binding = ((JDTClassNode)type.redirect()).getJdtBinding()).erasure())) != null) {
            SingleTypeReference ref = new SingleTypeReference(type.getNameWithoutPackage().toCharArray(), (long)type.getStart() << 32 | (long)type.getEnd() - 1L);
            this.compilationUnitScope.problemReporter().forbiddenReference((TypeBinding)binding, (ASTNode)ref, restriction.classpathEntryType, restriction.classpathEntryName, restriction.getProblemId());
        }
        return resolved;
    }

    protected boolean resolveFromCompileUnit(ClassNode type) {
        boolean resolved = super.resolveFromCompileUnit(type);
        this.recordDependency(type.getName());
        if (DEBUG) {
            this.log("resolveFromCompileUnit", type, resolved);
        }
        return resolved;
    }

    protected boolean resolveFromDefaultImports(ClassNode type, boolean testDefaultImports) {
        boolean resolved = super.resolveFromDefaultImports(type, testDefaultImports);
        this.recordDependency(type.getName());
        if (DEBUG) {
            this.log("resolveFromDefaultImports", type, resolved);
        }
        return resolved;
    }

    protected boolean resolveFromStaticInnerClasses(ClassNode type, boolean testNestedClasses) {
        boolean resolved = super.resolveFromStaticInnerClasses(type, testNestedClasses);
        this.recordDependency(type.getName());
        if (DEBUG) {
            this.log("resolveFromStaticInnerClasses", type, resolved);
        }
        return resolved;
    }

    protected boolean resolveToOuter(ClassNode type) {
        if (this.compilationUnitScope != null) {
            ProblemReferenceBinding prBinding;
            TypeBinding jdtBinding;
            char[][] compoundName;
            block12: {
                compoundName = CharOperation.splitOn((char)'.', (char[])type.getName().toCharArray());
                jdtBinding = null;
                try {
                    jdtBinding = this.compilationUnitScope.getType(compoundName, compoundName.length);
                }
                catch (AbortCompilation t) {
                    if (t.silentException instanceof AbortIncrementalBuildException) break block12;
                    throw t;
                }
            }
            if (jdtBinding instanceof ProblemReferenceBinding && (prBinding = (ProblemReferenceBinding)jdtBinding).problemId() == 4) {
                jdtBinding = prBinding.closestMatch();
            }
            if ((jdtBinding instanceof BinaryTypeBinding || jdtBinding instanceof SourceTypeBinding) && CharOperation.equals((char[][])compoundName, (char[][])((ReferenceBinding)jdtBinding).compoundName)) {
                if (DEBUG) {
                    this.log("resolveToOuter (jdt)", type, true);
                }
                type.setRedirect(this.convertToClassNode(jdtBinding));
                return true;
            }
        }
        if (this.compilationUnit.getClassLoader() instanceof GroovyClassLoaderFactory.GrapeAwareGroovyClassLoader) {
            GroovyClassLoaderFactory.GrapeAwareGroovyClassLoader loader = (GroovyClassLoaderFactory.GrapeAwareGroovyClassLoader)this.compilationUnit.getClassLoader();
            if (loader.grabbed) {
                try {
                    Class c = loader.loadClass(type.getName(), false, true);
                    if (DEBUG) {
                        this.log("resolveToOuter (grab)", type, true);
                    }
                    type.setRedirect(ClassHelper.make((Class)c));
                    return true;
                }
                catch (ClassNotFoundException | CompilationFailedException throwable) {
                    // empty catch block
                }
            }
        }
        if (DEBUG) {
            this.log("resolveToOuter", type, false);
        }
        return false;
    }

    protected AnnotationNode convertToAnnotationNode(AnnotationBinding jdtBinding) {
        if (jdtBinding == null || jdtBinding.getAnnotationType().problemId() != 0) {
            return null;
        }
        return new JDTAnnotationNode(jdtBinding, this);
    }

    protected ClassNode convertToClassNode(TypeBinding jdtBinding) {
        ClassNode existingNode = this.checkForExisting(jdtBinding);
        if (existingNode != null) {
            if (DEBUG) {
                this.log("Using cached ClassNode for binding " + JDTResolver.toString(jdtBinding));
            }
            return existingNode;
        }
        if (DEBUG) {
            this.log("Building new JDTClassNode for binding " + JDTResolver.toString(jdtBinding));
        }
        return this.createJDTClassNode(jdtBinding);
    }

    private ClassNode checkForExisting(TypeBinding jdtBinding) {
        ClassNode existing;
        if (jdtBinding.id > 0 && (jdtBinding.id <= 11 || jdtBinding.id <= 34 && jdtBinding.id >= 26) && (existing = COMMON_TYPES.get(String.valueOf(jdtBinding.readableName()))) != null) {
            return existing;
        }
        JDTClassNode node = this.inProgress.get(jdtBinding);
        if (node == null) {
            node = this.nodeCache.get(jdtBinding);
        }
        if (node != null) assert (CharOperation.equals((char[])jdtBinding.readableName(), (char[])node.getJdtBinding().readableName()));
        return node;
    }

    private ClassNode createJDTClassNode(TypeBinding jdtBinding) {
        JDTClassNodeBuilder cnb = new JDTClassNodeBuilder(this);
        ClassNode classNode = cnb.configureType(jdtBinding);
        if (classNode instanceof JDTClassNode) {
            JDTClassNode jdtNode = (JDTClassNode)classNode;
            assert (!this.inProgress.containsKey(jdtBinding));
            this.inProgress.put(jdtBinding, jdtNode);
            jdtNode.setUpGenerics();
            assert (this.nodeCache.get(jdtBinding) == null) : "not unique";
            this.nodeCache.put(jdtBinding, jdtNode);
            this.inProgress.remove(jdtBinding);
        }
        return classNode;
    }

    private void recordDependency(String typeName) {
        if (this.compilationUnitScope != null) {
            if (typeName.indexOf(46) != -1) {
                this.compilationUnitScope.recordQualifiedReference(CharOperation.splitOn((char)'.', (char[])typeName.toCharArray()));
            } else {
                this.compilationUnitScope.recordSimpleReference(typeName.toCharArray());
            }
        }
    }

    private static String toString(TypeBinding jdtBinding) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(jdtBinding.readableName());
        buffer.append('(').append(jdtBinding.id).append(')');
        try {
            Object lookup = ReflectionUtils.throwableGetPrivateField(jdtBinding.getClass(), "environment", jdtBinding);
            buffer.append("[from lookup ").append(Integer.toHexString(System.identityHashCode(lookup))).append(']');
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return buffer.toString();
    }
}

