/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import groovy.lang.GroovyClassLoader;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.ClosureSignatureHint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.util.Util;

public class TypeLookupResult {
    public final TypeConfidence confidence;
    public final ClassNode declaringType;
    public ClassNode receiverType;
    public final ClassNode type;
    public final ASTNode declaration;
    public final VariableScope scope;
    public final String extraDoc;
    public boolean isGroovy;
    public AnnotationNode enclosingAnnotation;
    public BinaryExpression enclosingAssignment;

    public TypeLookupResult(ClassNode type, ClassNode declaringType, ASTNode declaration, TypeLookupResult that) {
        this(type, declaringType, declaration, that.confidence, that.scope, that.extraDoc);
        this.enclosingAnnotation = that.enclosingAnnotation;
        this.enclosingAssignment = that.enclosingAssignment;
        this.receiverType = that.receiverType;
        this.isGroovy = that.isGroovy;
    }

    public TypeLookupResult(ClassNode type, ClassNode declaringType, ASTNode declaration, TypeConfidence confidence, VariableScope scope) {
        this(type, declaringType, declaration, confidence, scope, null);
    }

    public TypeLookupResult(ClassNode type, ClassNode declaringType, ASTNode declaration, TypeConfidence confidence, VariableScope scope, String extraDoc) {
        this.confidence = confidence;
        this.type = type;
        this.declaringType = declaringType;
        this.declaration = declaration;
        this.scope = scope;
        this.extraDoc = extraDoc;
    }

    public TypeLookupResult resolveTypeParameterization(ClassNode objExprType, boolean isStatic) {
        if (this.declaringType != null && (this.declaration instanceof FieldNode || this.declaration instanceof PropertyNode || this.declaration instanceof MethodNode && !(this.declaration instanceof ConstructorNode))) {
            ClassNode objectType = objExprType;
            if (objectType == null) {
                objectType = this.isGroovy || !isStatic ? this.scope.getDelegateOrThis() : this.declaringType;
            }
            if (ClassHelper.isPrimitiveType((ClassNode)objectType)) {
                objectType = ClassHelper.getWrapper((ClassNode)objectType);
            } else if (objectType.isGenericsPlaceHolder()) {
                objectType = Arrays.stream(GroovyUtils.getTypeParameterBounds(objectType)).filter(bound -> bound.isDerivedFrom(this.declaringType) || bound.implementsInterface(this.declaringType)).findFirst().orElse(objectType);
            } else if (objectType.equals((Object)VariableScope.CLASS_CLASS_NODE) && !this.declaringType.equals((Object)VariableScope.CLASS_CLASS_NODE) && !this.isGroovy) {
                objectType = VariableScope.getFirstGenerics(objectType);
            }
            if (!(this.declaration instanceof MethodNode)) {
                GenericsMapper mapper;
                ClassNode maybe;
                if (GenericsUtils.hasUnresolvedGenerics((ClassNode)this.type) && !(maybe = VariableScope.resolveTypeParameterization(mapper = GenericsMapper.gatherGenerics(objectType, this.declaringType), VariableScope.clone(this.type))).toString(false).equals(this.type.toString(false))) {
                    return new TypeLookupResult(maybe, this.declaringType, this.declaration, this);
                }
            } else {
                MethodNode method = (MethodNode)this.declaration;
                if (!isStatic && method.getName().equals("getClass") && method.getParameters().length == 0) {
                    ClassNode classType = VariableScope.clone(method.getReturnType());
                    classType.getGenericsTypes()[0].setUpperBounds(new ClassNode[]{objectType});
                    return new TypeLookupResult(classType, this.declaringType, (ASTNode)method, this.confidence, this.scope, this.extraDoc);
                }
                if ((GenericsUtils.hasUnresolvedGenerics((ClassNode)method.getReturnType()) || GroovyUtils.getParameterTypes(method.getParameters()).stream().anyMatch(GenericsUtils::hasUnresolvedGenerics)) && (method = this.resolveTypeParameterization(method, objectType, isStatic)) != this.declaration) {
                    return new TypeLookupResult(method.getReturnType(), this.declaringType, (ASTNode)method, this);
                }
            }
        }
        return this;
    }

    private MethodNode resolveTypeParameterization(MethodNode method, ClassNode selfType, boolean isStatic) {
        VariableScope.CallAndType cat;
        GenericsMapper mapper;
        ArrayList<ClassNode> argumentTypes = new ArrayList<ClassNode>();
        if (this.isGroovy) {
            argumentTypes.add(selfType);
        }
        ClassNode targetType = null;
        if (!(this.scope.getEnclosingNode() instanceof MethodPointerExpression)) {
            if (this.scope.getMethodCallArgumentTypes() != null) {
                argumentTypes.addAll(this.scope.getMethodCallArgumentTypes());
            }
            GenericsMapper mapper2 = GenericsMapper.gatherGenerics(argumentTypes, selfType, method, this.scope.getMethodCallGenericsTypes());
            BiFunction<String, ClassNode, ClassNode> finder = mapper2::findParameter;
            Predicate<GenericsType> unresolved = tp -> finder.apply(tp.getName(), null) == null;
            if (this.scope.getMethodCallGenericsTypes() == null && Arrays.stream(GroovyUtils.getGenericsTypes(method)).anyMatch(unresolved)) {
                int n;
                GenericsMapper gm;
                Predicate<Expression> test = exp -> exp instanceof StaticMethodCallExpression && exp == this.scope.getCurrentNode() || exp instanceof MethodCallExpression && ((MethodCallExpression)exp).getMethod() == this.scope.getCurrentNode();
                if (TypeLookupResult.testEnclosingAssignment(this.scope, test)) {
                    targetType = this.scope.getEnclosingAssignment().getLeftExpression().getType();
                } else {
                    Parameter[] params;
                    int index;
                    VariableScope.CallAndType cat2 = this.scope.getEnclosingMethodCallExpression();
                    if (cat2 != null && (index = TypeLookupResult.indexOf(TypeLookupResult.asList(cat2.call.getArguments()), test)) != -1 && (params = TypeLookupResult.parameters(cat2)).length > 0 && (targetType = params[Math.min(index, params.length - 1)].getType()).isArray() && index > params.length - 1) {
                        targetType = targetType.getComponentType();
                    }
                }
                if (targetType != null && (gm = GenericsMapper.gatherGenerics(Collections.singletonList(targetType), selfType, TypeLookupResult.returnTypeStub(method), new GenericsType[0])).hasGenerics()) {
                    GenericsType[] genericsTypeArray = method.getGenericsTypes();
                    int n2 = genericsTypeArray.length;
                    n = 0;
                    while (n < n2) {
                        GenericsType tp2 = genericsTypeArray[n];
                        if (unresolved.test(tp2) && gm.findParameter(tp2.getName(), null) != null) {
                            mapper2.allGenerics.getLast().put(tp2.getName(), gm.findParameter(tp2.getName(), null));
                        }
                        ++n;
                    }
                }
                GenericsType[] genericsTypeArray = method.getGenericsTypes();
                n = genericsTypeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    GenericsType tp3 = genericsTypeArray[n3];
                    if (unresolved.test(tp3)) {
                        GenericsMapper gm2 = GenericsMapper.gatherGenerics(Collections.singletonList(this.type), selfType, TypeLookupResult.returnTypeStub(method), new GenericsType[0]);
                        ClassNode cn = gm2.findParameter(tp3.getName(), null);
                        if (cn == null || cn.isGenericsPlaceHolder() && cn.getUnresolvedName().equals(tp3.getName())) {
                            cn = TypeLookupResult.erasure(tp3);
                        }
                        mapper2.allGenerics.getLast().put(tp3.getName(), cn);
                    }
                    ++n3;
                }
            }
            return VariableScope.resolveTypeParameterization(mapper2, (MethodNode)this.declaration);
        }
        if (!isStatic && !method.isStatic()) {
            mapper = GenericsMapper.gatherGenerics(argumentTypes, selfType, method, new GenericsType[0]);
            method = VariableScope.resolveTypeParameterization(mapper, method);
        }
        if ((cat = this.scope.getEnclosingMethodCallExpression()) != null) {
            Parameter[] params;
            int index = TypeLookupResult.asList(cat.call.getArguments()).indexOf(this.scope.getEnclosingNode());
            if (index != -1 && (params = TypeLookupResult.parameters(cat)).length > 0) {
                targetType = params[Math.min(index, params.length - 1)].getType();
                if (targetType.isArray() && index >= params.length - 1) {
                    targetType = targetType.getComponentType();
                }
                if (targetType.equals((Object)VariableScope.CLOSURE_CLASS_NODE)) {
                    MethodNode source = method;
                    Parameter target = params[Math.min(index, params.length - 1)];
                    method = TypeLookupResult.findClosureSignature(target, source, this.scope.getEnclosingModuleNode().getContext(), cat.call).map(types -> {
                        GenericsMapper gm = GenericsMapper.gatherGenerics(Arrays.asList(types), callAndType.declaringType, source, new GenericsType[0]);
                        MethodNode mn = VariableScope.resolveTypeParameterization(gm, source);
                        return mn;
                    }).orElse(method);
                }
            }
        } else if (TypeLookupResult.testEnclosingAssignment(this.scope, rhs -> rhs == this.scope.getEnclosingNode())) {
            targetType = this.scope.getEnclosingAssignment().getLeftExpression().getType();
        }
        if (targetType != null) {
            if (targetType.equals((Object)VariableScope.CLOSURE_CLASS_NODE)) {
                ClassNode returnType = Optional.of(targetType).map(ClassNode::getGenericsTypes).filter(Objects::nonNull).map(gts -> gts[0].getType()).orElse(VariableScope.OBJECT_CLASS_NODE);
                mapper = GenericsMapper.gatherGenerics(Collections.singletonList(returnType), this.declaringType, TypeLookupResult.returnTypeStub(method), new GenericsType[0]);
                method = VariableScope.resolveTypeParameterization(mapper, method);
            } else if (ClassHelper.isSAMType((ClassNode)targetType)) {
                ClassNode[] pt = (ClassNode[])GenericsUtils.parameterizeSAM((ClassNode)targetType).getV1();
                if (isStatic && !method.isStatic()) {
                    selfType = pt[0];
                    pt = Arrays.copyOfRange(pt, 1, pt.length);
                }
                mapper = GenericsMapper.gatherGenerics(Arrays.asList(pt), selfType, method, new GenericsType[0]);
                method = VariableScope.resolveTypeParameterization(mapper, method);
                mapper = GenericsMapper.gatherGenerics(targetType);
                method = VariableScope.resolveTypeParameterization(mapper, method);
            }
        }
        if (method.getGenericsTypes() != null && GenericsUtils.hasUnresolvedGenerics((ClassNode)method.getReturnType())) {
            mapper = GenericsMapper.gatherGenerics(GroovyUtils.getParameterTypes(method.getParameters()), selfType, method, new GenericsType[0]);
            GenericsType[] genericsTypeArray = method.getGenericsTypes();
            int n = genericsTypeArray.length;
            int n4 = 0;
            while (n4 < n) {
                GenericsType tp4 = genericsTypeArray[n4];
                if (mapper.findParameter(tp4.getName(), null) == null) {
                    mapper.allGenerics.getLast().put(tp4.getName(), TypeLookupResult.erasure(tp4));
                }
                ++n4;
            }
            method = VariableScope.resolveTypeParameterization(mapper, (MethodNode)this.declaration);
        }
        return method;
    }

    private static ClassNode erasure(GenericsType tp) {
        ClassNode cn = tp.getType().redirect();
        if (tp.getType().getGenericsTypes() != null) {
            tp = tp.getType().getGenericsTypes()[0];
        }
        if (tp.getUpperBounds() != null) {
            cn = tp.getUpperBounds()[0];
        }
        if (GenericsUtils.hasUnresolvedGenerics((ClassNode)cn)) {
            cn = cn.getPlainNodeReference();
        }
        return cn;
    }

    private static List<Expression> asList(Expression args) {
        if (args instanceof TupleExpression) {
            return ((TupleExpression)args).getExpressions();
        }
        return Collections.singletonList(args);
    }

    private static Parameter[] parameters(VariableScope.CallAndType cat) {
        if (cat.declaration instanceof MethodNode) {
            MethodNode declaration = (MethodNode)cat.declaration;
            Parameter[] parameters = declaration.getParameters();
            if (!declaration.getDeclaringClass().equals((Object)cat.getPerceivedDeclaringType())) {
                parameters = Arrays.copyOfRange(parameters, 1, parameters.length);
            }
            return parameters;
        }
        return Parameter.EMPTY_ARRAY;
    }

    private static MethodNode returnTypeStub(MethodNode node) {
        MethodNode stub = new MethodNode("", 0, VariableScope.VOID_CLASS_NODE, new Parameter[]{new Parameter(node.getReturnType(), "")}, null, null);
        stub.setDeclaringClass(node.getDeclaringClass());
        stub.setGenericsTypes(node.getGenericsTypes());
        return stub;
    }

    private static <T> int indexOf(List<T> list, Predicate<? super T> test) {
        ListIterator<T> iter = list.listIterator();
        while (iter.hasNext()) {
            if (!test.test(iter.next())) continue;
            return iter.previousIndex();
        }
        return -1;
    }

    private static boolean testEnclosingAssignment(VariableScope scope, Predicate<Expression> rhsTest) {
        return Optional.ofNullable(scope.getEnclosingAssignment()).filter(bexp -> bexp instanceof DeclarationExpression).map(BinaryExpression::getRightExpression).filter(rhsTest).isPresent();
    }

    private static Optional<ClassNode[]> findClosureSignature(Parameter target, MethodNode origin, SourceUnit unit, MethodCall call) {
        return GroovyUtils.getAnnotations((AnnotatedNode)target, VariableScope.CLOSURE_PARAMS.getName()).findFirst().map(cp -> {
            CompilationUnit cu = ((EclipseSourceUnit)sourceUnit).resolver.compilationUnit;
            try {
                Class hint = (Class)StaticTypeCheckingSupport.evaluateExpression((Expression)GeneralUtils.castX((ClassNode)VariableScope.CLASS_CLASS_NODE, (Expression)cp.getMember("value")), (CompilerConfiguration)unit.getConfiguration(), (GroovyClassLoader)cu.getTransformLoader());
                String[] opts = (String[])(cp.getMember("options") == null ? ClosureParams.class.getMethod("options", new Class[0]).getDefaultValue() : StaticTypeCheckingSupport.evaluateExpression((Expression)GeneralUtils.castX((ClassNode)VariableScope.STRING_CLASS_NODE.makeArray(), (Expression)cp.getMember("options")), (CompilerConfiguration)unit.getConfiguration(), (GroovyClassLoader)cu.getTransformLoader()));
                List sigs = ((ClosureSignatureHint)hint.newInstance()).getClosureSignatures(origin, unit, cu, opts, (ASTNode)((Expression)call));
                if (sigs != null) {
                    List<ClassNode> parameterTypes = GroovyUtils.getParameterTypes(origin.getParameters());
                    for (ClassNode[] sig : sigs) {
                        if (sig.length != parameterTypes.size() || !IntStream.range(0, sig.length).allMatch(i -> GroovyUtils.isAssignable(sig[i], (ClassNode)parameterTypes.get(i)))) continue;
                        return sig;
                    }
                }
            }
            catch (Exception | LinkageError e) {
                Util.log((Throwable)e, (String)("Error processing @ClosureParams of " + call.getMethodAsString()));
            }
            return null;
        });
    }

    public static enum TypeConfidence {
        EXACT,
        INFERRED,
        LOOSELY_INFERRED,
        UNKNOWN;


        public static TypeConfidence findLessPrecise(TypeConfidence left, TypeConfidence right) {
            return left.isLessThan(right) ? left : right;
        }

        public boolean isLessThan(TypeConfidence that) {
            return this.ordinal() > that.ordinal();
        }

        public boolean isAtLeast(TypeConfidence that) {
            return this.ordinal() <= that.ordinal();
        }
    }
}

