/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.handlers;

import com.katalon.recorder.mobile.core.presentation.IMobileRecorderDialog;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MImperativeExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUiFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenMobileRecorderHandler {
    private static final String RECORDER_TOOL_ITEM_ID = "com.kms.katalon.composer.mobile.recorder.handledtoolitem.record.mobile";
    private static final String RECORDER_TOOL_ITEM_MENU_ID = "com.kms.katalon.composer.mobile.recorder.menu.0";
    private static final String ANDROID_MENU_ITEM_ID = "com.kms.katalon.composer.mobile.recorder.directmenuitem.android";
    private static final String ANDROID_MENU_ITEM_LABEL = "Android Devices";
    private static final String ANDROID_MENU_ITEM_ICON_URI = "platform:/plugin/com.kms.katalon.composer.resources/icons/execution/android_16.png";
    private static final String ANDROID_MENU_ITEM_TOOLTIP = "Record Android applications";
    private static final String ANDROID_MENU_ITEM_CONTRIBUTION_URI = "bundleclass://com.kms.katalon.composer.mobile.recorder/com.kms.katalon.composer.mobile.recorder.handlers.OpenAndroidRecorderHandler";
    private static final String IOS_MENU_ITEM_ID = "com.kms.katalon.composer.mobile.recorder.directmenuitem.ios";
    private static final String IOS_MENU_ITEM_LABEL = "iOS Devices";
    private static final String IOS_MENU_ITEM_ICON_URI = "platform:/plugin/com.kms.katalon.composer.resources/icons/execution/apple_16.png";
    private static final String IOS_MENU_ITEM_TOOLTIP = "Record iOS applications";
    private static final String IOS_MENU_ITEM_CONTRIBUTION_URI = "bundleclass://com.kms.katalon.composer.mobile.recorder/com.kms.katalon.composer.mobile.recorder.handlers.OpenIosRecorderHandler";
    private static final String SEPARATOR_MENU_ITEM_ID = "com.kms.katalon.composer.mobile.recorder.menuseparator.0";
    private static final String REMOTE_MENU_ITEM_ID = "com.kms.katalon.composer.mobile.recorder.directmenuitem.remote";
    private static final String REMOTE_MENU_ITEM_LABEL = "Remote Devices";
    private static final String REMOTE_MENU_ITEM_ICON_URI = "platform:/plugin/com.kms.katalon.composer.resources/icons/execution/remote_16.png";
    private static final String REMOTE_MENU_ITEM_TOOLTIP = "Record mobile applications on remote devices";
    private static final String REMOTE_MENU_ITEM_CONTRIBUTION_URI = "bundleclass://com.kms.katalon.composer.mobile.recorder/com.kms.katalon.composer.mobile.recorder.handlers.OpenRemoteDeviceRecorderHander";
    private static final String KOBITON_MENU_CONTRIBUTION_ID = "com.kms.katalon.composer.mobile.recorder.dynamicmenucontribution.";
    private static final String KOBITON_MENU_CONTRIBUTION_URI = "bundleclass://com.kms.katalon.composer.mobile.recorder/com.kms.katalon.composer.mobile.recorder.menu.MobileRecorderKobitonDeviceMenuContribution";
    private static final String CUSTOM_CAPABILITIES_MENU_ITEM_ID = "com.kms.katalon.composer.mobile.recorder.menu.customcapabilities";
    private static final String CUSTOM_CAPABILITIES_MENU_ITEM_LABEL = "Custom Capabilities";
    private static final String CUSTOM_CAPABILITIES_MENU_ITEM_CONTRIBUTION_ID = "com.kms.katalon.composer.mobile.recorder.customcapabilities";
    private static final String CUSTOM_CAPABILITIES_MENU_ITEM_CONTRIBUTION_URI = "bundleclass://com.kms.katalon.composer.mobile.recorder/com.kms.katalon.composer.mobile.recorder.menu.MobileRecorderCustomCapabilitiesMenuContribution";
    private static final String TESTCLOUD_MENU_ITEM_ID = "com.kms.katalon.composer.integration.testcloud.directmenuitem.record.testclouddevices";
    private static final String TESTCLOUD_MENU_ITEM_LABEL = "TestCloud Devices";
    private static final String TESTCLOUD_MENU_ITEM_ICON_URI = "platform:/plugin/com.kms.katalon.composer.resources/icons/testcloud_icon_16x16.png";
    private static final String TESTCLOUD_MENU_ITEM_TOOLTIP = "Record mobile applications on TestCloud devices";
    private static final String TESTCLOUD_MENU_ITEM_CONTRIBUTION_URI = "bundleclass://com.kms.katalon.composer.mobile.recorder/com.kms.katalon.composer.mobile.recorder.handlers.OpenTestCloudObjectRecordDialogHandler";
    private static final String TESTCLOUD_FEATURE_EXPRESSION_URI = "bundleclass://com.kms.katalon.composer.integration.testcloud/com.kms.katalon.composer.integration.testcloud.handlers.TestCloudMobileFeatureExpression";
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IEclipseContext context;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    private MHandledToolItem recorderToolItem;
    private MMenu cachedRecorderToolItemMenu;
    private IPropertyChangeListener preferenceChangeListener;
    private boolean isUsingSmartMobileRecorder = false;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @PostConstruct
    public void initialize() {
        ScopedPreferenceStore betaFeaturePreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.betaFeature");
        String smartMobileRecorderOption = betaFeaturePreferenceStore.getString("betaFeature.smartMobileRecorder");
        this.isUsingSmartMobileRecorder = StringUtils.equals((CharSequence)Boolean.TRUE.toString(), (CharSequence)smartMobileRecorderOption);
        this.recorderToolItem = (MHandledToolItem)this.modelService.find(RECORDER_TOOL_ITEM_ID, (MUIElement)this.application);
        this.updateMenuForToolItem();
        this.registerObjectSpyMobileEvent();
        this.registerPreferenceChangeListener();
    }

    @PreDestroy
    public void dispose() {
        if (this.preferenceChangeListener != null) {
            ScopedPreferenceStore betaFeaturePreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.betaFeature");
            betaFeaturePreferenceStore.removePropertyChangeListener(this.preferenceChangeListener);
        }
    }

    private void registerObjectSpyMobileEvent() {
        this.eventBroker.subscribe("OBJECT_SPY/MOBILE", new EventHandler(){

            public void handleEvent(Event event) {
                boolean shouldOpenSmartMobileRecorder;
                boolean bl = shouldOpenSmartMobileRecorder = OpenMobileRecorderHandler.this.canExecute() && OpenMobileRecorderHandler.this.isUsingSmartMobileRecorder;
                if (shouldOpenSmartMobileRecorder) {
                    OpenMobileRecorderHandler.this.openSmartMobileRecorderDialog(Display.getCurrent().getActiveShell());
                }
            }
        });
    }

    private void registerPreferenceChangeListener() {
        ScopedPreferenceStore betaFeaturePreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.betaFeature");
        this.preferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("betaFeature.smartMobileRecorder".equals(event.getProperty())) {
                    String newValue = (String)event.getNewValue();
                    OpenMobileRecorderHandler.this.isUsingSmartMobileRecorder = StringUtils.equals((CharSequence)Boolean.TRUE.toString(), (CharSequence)newValue);
                    if (OpenMobileRecorderHandler.this.recorderToolItem != null) {
                        Display.getDefault().asyncExec(() -> OpenMobileRecorderHandler.this.updateMenuForToolItem());
                    }
                }
            }
        };
        betaFeaturePreferenceStore.addPropertyChangeListener(this.preferenceChangeListener);
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell activeShell) {
        if (this.isUsingSmartMobileRecorder) {
            this.openSmartMobileRecorderDialog(activeShell);
            return;
        }
        this.openMobileRecorderDropdown();
    }

    private boolean openSmartMobileRecorderDialog(Shell activeShell) {
        try {
            IMobileRecorderDialog mobileRecorderDialog = (IMobileRecorderDialog)this.context.get(IMobileRecorderDialog.class);
            return mobileRecorderDialog.open() == 0;
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)activeShell, (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
            return false;
        }
    }

    private void openMobileRecorderDropdown() {
        Object widget = this.recorderToolItem.getWidget();
        if (widget == null) {
            return;
        }
        ToolItem toolItem = (ToolItem)widget;
        org.eclipse.swt.widgets.Event e = new org.eclipse.swt.widgets.Event();
        e.type = 13;
        e.widget = toolItem;
        e.detail = 4;
        e.x = toolItem.getBounds().x;
        e.y = toolItem.getBounds().height;
        toolItem.notifyListeners(13, e);
    }

    private void updateMenuForToolItem() {
        if (this.recorderToolItem == null) {
            return;
        }
        if (this.isUsingSmartMobileRecorder) {
            if (this.recorderToolItem.getMenu() != null) {
                this.recorderToolItem.setMenu(null);
            }
        } else if (this.recorderToolItem.getMenu() == null) {
            this.createRecorderDropdownMenu();
        }
        this.recorderToolItem.setWidget(null);
        this.recorderToolItem.setToBeRendered(false);
        this.recorderToolItem.setToBeRendered(true);
    }

    private void createRecorderDropdownMenu() {
        if (this.cachedRecorderToolItemMenu == null) {
            this.cachedRecorderToolItemMenu = MMenuFactory.INSTANCE.createMenu();
            this.cachedRecorderToolItemMenu.setElementId(RECORDER_TOOL_ITEM_MENU_ID);
            this.createAndroidDevicesMenuItem();
            this.createIosDevicesMenuItem();
            this.createMenuSeparator();
            this.createRemoteDevicesMenuItem();
            this.createTestCloudDevicesMenuItem();
            this.createKobitonDevicesMenuItem();
            this.createCustomCapabilitiesMenuItem();
        }
        this.recorderToolItem.setMenu(this.cachedRecorderToolItemMenu);
    }

    private void createAndroidDevicesMenuItem() {
        MDirectMenuItem androidItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        androidItem.setElementId(ANDROID_MENU_ITEM_ID);
        androidItem.setLabel(ANDROID_MENU_ITEM_LABEL);
        androidItem.setIconURI(ANDROID_MENU_ITEM_ICON_URI);
        androidItem.setTooltip(ANDROID_MENU_ITEM_TOOLTIP);
        androidItem.setContributionURI(ANDROID_MENU_ITEM_CONTRIBUTION_URI);
        this.cachedRecorderToolItemMenu.getChildren().add(androidItem);
    }

    private void createIosDevicesMenuItem() {
        MDirectMenuItem iosItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        iosItem.setElementId(IOS_MENU_ITEM_ID);
        iosItem.setLabel(IOS_MENU_ITEM_LABEL);
        iosItem.setIconURI(IOS_MENU_ITEM_ICON_URI);
        iosItem.setTooltip(IOS_MENU_ITEM_TOOLTIP);
        iosItem.setContributionURI(IOS_MENU_ITEM_CONTRIBUTION_URI);
        this.cachedRecorderToolItemMenu.getChildren().add(iosItem);
    }

    private void createMenuSeparator() {
        MMenuSeparator separator = MMenuFactory.INSTANCE.createMenuSeparator();
        separator.setElementId(SEPARATOR_MENU_ITEM_ID);
        this.cachedRecorderToolItemMenu.getChildren().add(separator);
    }

    private void createRemoteDevicesMenuItem() {
        MDirectMenuItem remoteItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        remoteItem.setElementId(REMOTE_MENU_ITEM_ID);
        remoteItem.setLabel(REMOTE_MENU_ITEM_LABEL);
        remoteItem.setIconURI(REMOTE_MENU_ITEM_ICON_URI);
        remoteItem.setTooltip(REMOTE_MENU_ITEM_TOOLTIP);
        remoteItem.setContributionURI(REMOTE_MENU_ITEM_CONTRIBUTION_URI);
        this.cachedRecorderToolItemMenu.getChildren().add(remoteItem);
    }

    private void createTestCloudDevicesMenuItem() {
        MDirectMenuItem testCloudItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        testCloudItem.setElementId(TESTCLOUD_MENU_ITEM_ID);
        testCloudItem.setLabel(TESTCLOUD_MENU_ITEM_LABEL);
        testCloudItem.setIconURI(TESTCLOUD_MENU_ITEM_ICON_URI);
        testCloudItem.setTooltip(TESTCLOUD_MENU_ITEM_TOOLTIP);
        testCloudItem.setContributionURI(TESTCLOUD_MENU_ITEM_CONTRIBUTION_URI);
        MImperativeExpression visibilityExpression = MUiFactory.INSTANCE.createImperativeExpression();
        visibilityExpression.setContributionURI(TESTCLOUD_FEATURE_EXPRESSION_URI);
        testCloudItem.setVisibleWhen((MExpression)visibilityExpression);
        this.cachedRecorderToolItemMenu.getChildren().add(testCloudItem);
    }

    private void createKobitonDevicesMenuItem() {
        MDynamicMenuContribution kobitonContribution = MMenuFactory.INSTANCE.createDynamicMenuContribution();
        kobitonContribution.setElementId(KOBITON_MENU_CONTRIBUTION_ID);
        kobitonContribution.setContributionURI(KOBITON_MENU_CONTRIBUTION_URI);
        this.cachedRecorderToolItemMenu.getChildren().add(kobitonContribution);
    }

    private void createCustomCapabilitiesMenuItem() {
        MMenu customCapabilitiesMenu = MMenuFactory.INSTANCE.createMenu();
        customCapabilitiesMenu.setElementId(CUSTOM_CAPABILITIES_MENU_ITEM_ID);
        customCapabilitiesMenu.setLabel(CUSTOM_CAPABILITIES_MENU_ITEM_LABEL);
        MDynamicMenuContribution customCapabilitiesContribution = MMenuFactory.INSTANCE.createDynamicMenuContribution();
        customCapabilitiesContribution.setElementId(CUSTOM_CAPABILITIES_MENU_ITEM_CONTRIBUTION_ID);
        customCapabilitiesContribution.setContributionURI(CUSTOM_CAPABILITIES_MENU_ITEM_CONTRIBUTION_URI);
        customCapabilitiesMenu.getChildren().add(customCapabilitiesContribution);
        this.cachedRecorderToolItemMenu.getChildren().add(customCapabilitiesMenu);
    }
}

