/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools.schema;

import com.kms.katalon.ai.mcp.tools.schema.TestDataSchema;
import com.kms.katalon.entity.testdata.DataFileEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExcelFileSchema
extends TestDataSchema {
    public final String dataSourceUrl;
    public final boolean containsHeaders;
    public final String sheetName;

    public ExcelFileSchema(String testDataId, String testDataName, String description, String location, String dataSourceUrl, boolean containsHeaders, String sheetName) {
        super(testDataId, testDataName, description, location);
        this.dataSourceUrl = dataSourceUrl;
        this.containsHeaders = containsHeaders;
        this.sheetName = sheetName;
    }

    @Override
    public String getDriver() {
        return DataFileEntity.DataFileDriverType.ExcelFile.toString();
    }

    @Override
    public Map<String, Object> toSchemaProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.getBaseProperties());
        properties.put("driver", this.createConstProperty(this.getDriver(), "Test data driver type for Excel files"));
        properties.put("dataSourceUrl", this.createProperty("string", "Data source URL for Excel file"));
        properties.put("containsHeaders", this.createProperty("boolean", "Whether the first row contains headers"));
        properties.put("sheetName", this.createProperty("string", "Sheet name in the Excel file"));
        return properties;
    }

    @Override
    public List<String> getRequiredFields() {
        return List.of("testDataId", "testDataName", "driver", "location", "dataSourceUrl");
    }

    @Override
    public Map<String, Object> toDataMap() {
        Map<String, Object> dataMap = super.toDataMap();
        dataMap.put("dataSourceUrl", this.dataSourceUrl);
        dataMap.put("containsHeaders", this.containsHeaders);
        dataMap.put("sheetName", this.sheetName);
        return dataMap;
    }
}

