/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.network.core.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class HttpResponse {
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    String body;
    InputStream content;
    int statusCode;
    private List<Map.Entry<String, String>> headers;

    private HttpResponse(Builder builder) {
        this.statusCode = builder.statusCode;
        this.content = builder.content;
        this.body = builder.body;
        this.headers = builder.headers;
    }

    public String getBody() {
        return this.body;
    }

    public InputStream getContent() {
        return this.content;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public <T> T json(Class<T> valueType) throws MalformedContentException {
        return this.json(valueType, mapper);
    }

    public <T> T json(Class<T> valueType, ObjectMapper objectMapper) throws MalformedContentException {
        if (StringUtils.isEmpty((CharSequence)this.body)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(this.body, valueType);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
        catch (Exception e) {
            throw new MalformedContentException(e);
        }
    }

    public <T> T json(TypeReference<T> valueTypeRef) throws MalformedContentException {
        if (StringUtils.isEmpty((CharSequence)this.body)) {
            return null;
        }
        try {
            return (T)mapper.readValue(this.body, valueTypeRef);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
        catch (Exception e) {
            throw new MalformedContentException(e);
        }
    }

    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers;
    }

    public <T> List<T> jsonArray(Class<T> clazz) throws MalformedContentException {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            JsonNode jsonNode = mapper.readTree(this.body);
            for (JsonNode node : jsonNode) {
                try {
                    Object item = mapper.treeToValue((TreeNode)node, clazz);
                    list.add(item);
                }
                catch (Exception e) {
                    throw new MalformedContentException(e);
                }
            }
        }
        catch (Exception e) {
            throw new MalformedContentException(e);
        }
        return list;
    }

    public static class Builder {
        private String body;
        private InputStream content;
        private int statusCode;
        private List<Map.Entry<String, String>> headers;

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder content(InputStream content) {
            this.content = content;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder addHeader(String key, String value) {
            if (Objects.isNull(this.headers)) {
                throw new IllegalArgumentException("headers is null due to not calling the setCapacity(int cap) before adding header");
            }
            this.headers.add(new AbstractMap.SimpleEntry<String, String>(key, value));
            return this;
        }

        public HttpResponse build() {
            return new HttpResponse(this);
        }

        public Builder setCapacity(int capacity) {
            this.headers = new ArrayList<Map.Entry<String, String>>(capacity);
            return this;
        }
    }
}

