/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.filters;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import net.lightbody.bmp.filters.HttpsAwareFiltersAdapter;
import org.littleshoot.proxy.impl.ProxyUtils;

public class WhitelistFilter
extends HttpsAwareFiltersAdapter {
    private final boolean whitelistEnabled;
    private final int whitelistResponseCode;
    private final Collection<Pattern> whitelistUrls;

    public WhitelistFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, boolean whitelistEnabled, int whitelistResponseCode, Collection<Pattern> whitelistUrls) {
        super(originalRequest, ctx);
        this.whitelistEnabled = whitelistEnabled;
        this.whitelistResponseCode = whitelistResponseCode;
        this.whitelistUrls = whitelistUrls != null ? whitelistUrls : Collections.emptyList();
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (!this.whitelistEnabled) {
            return null;
        }
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpObject;
            if (ProxyUtils.isCONNECT((HttpObject)httpRequest)) {
                return null;
            }
            boolean urlWhitelisted = false;
            String url = this.getFullUrl(httpRequest);
            for (Pattern pattern : this.whitelistUrls) {
                if (!pattern.matcher(url).matches()) continue;
                urlWhitelisted = true;
                break;
            }
            if (!urlWhitelisted) {
                HttpResponseStatus status = HttpResponseStatus.valueOf((int)this.whitelistResponseCode);
                DefaultFullHttpResponse resp = new DefaultFullHttpResponse(httpRequest.getProtocolVersion(), status);
                HttpHeaders.setContentLength((HttpMessage)resp, (long)0L);
                return resp;
            }
        }
        return null;
    }
}

